PRO mark_db_event, ev
  ; Empty!
END

PRO mark_db

  COMMON STATE_INFO, day_num, inst_num
  ;Declare "global" variables

  ;--- Open the database and get the event list
  db_id=NCDF_OPEN('mark_db.nc')
  year_id=		NCDF_VARID(db_id,'YEAR')
  doy_id=		NCDF_VARID(db_id,'DOY')
  NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'index'),ind_str,index
  NCDF_VARGET,db_id,year_id,year_arr,OFFSET=[0]
  NCDF_VARGET,db_id,doy_id,doy_arr,OFFSET=[0]
  NCDF_CLOSE,db_id
  inst_num=0
  day_num=index-1

  tbl_data=mark_db_settable(day_num,inst_num)

  base=WIDGET_BASE(TITLE='CME Database Manager', /ROW)
  command_panel=WIDGET_BASE(base,/COLUMN)
  data_panel=WIDGET_BASE(base,/COLUMN)

  datestring_arr=STRARR(index)
  FOR I=0,index-1 DO $
	datestring_arr[I]=STRING(year_arr[I], doy_arr[I], $
		FORMAT = '(I4,"d",I3)')
  event_list=WIDGET_LIST(command_panel,EVENT_FUNC='mark_db_getevent', $
	YSIZE=10,/FRAME, value=datestring_arr)
  inst_list=WIDGET_LIST(command_panel,EVENT_FUNC='mark_db_getinst', $
	value=['CHIP','EIT','MK3','C2','C3','-','-'],YSIZE=5,/FRAME)

  buttons=CW_BGROUP(command_panel,['Update','New Event','New Day','Quit',$
	'Help!'], $
	EVENT_FUNC='mark_db_buttons',/COLUMN,/FRAME,/RETURN_NAME)
  labels=['Start_t','Stop_t','Quality','Lat','Length','Lon' $
	,'Width','PA','Width','AR#','Comment']
  row_labels=['Data info','1','2','3','4','5','6','7','8','9','10','11','12', $
	'13','14','15','16','17','18','19']
  widths=[1.0,1.0,0.7,0.7,0.7,0.7,0.7,0.7,0.7,1.0,5.0]
  data_label=WIDGET_TEXT(data_panel,/ALIGN_CENTER, /ALL_EVENTS, $
	VALUE=tbl_data.date, /EDITABLE)
  data_table=WIDGET_TABLE(data_panel, VALUE=tbl_data.table, $
	COLUMN_LABELS=labels, COLUMN_WIDTHS=widths, UNITS=1,YSIZE=20, $
	X_SCROLL_SIZE=11, /EDITABLE, ROW_LABELS=row_labels, Y_SCROLL_SIZE=10)

  state={event_list:event_list,inst_list:inst_list,data_label:data_label, $
	data_table:data_table, year_arr:year_arr, doy_arr:doy_arr}
  WIDGET_CONTROL,event_list,SET_UVALUE=state
  WIDGET_CONTROL,inst_list,SET_UVALUE=state
  WIDGET_CONTROL,data_table,SET_UVALUE=state
  WIDGET_CONTROL,buttons,SET_UVALUE=state
  WIDGET_CONTROL,base,/REALIZE
  XMANAGER,'mark_db',base

END