;
; More generalized procedure to add events to the database.  Specific to
; the format of the database itself.  It needs to be sent a structure defined
; as follows (you can paste this into your code to define the structure):
;
; data={data,event:0,ap:0,num_meas:0,quality:0,utcstart:STRARR(100),
;	utcstop:STRARR(100),lat:FLTARR(100),lat_error:FLTARR(100),
;	lon:FLTARR(100),lon_error:FLTARR(100),pa:FLTARR(100),
;	pa_error:FLTARR(100),ar:INTARR(100),feature:STRARR(100),
;	instrument:STRARR(100),comment:STRARR(100)
;	}
;
; The database is set up for up to 300 measurements.  This is defined in the
; measurements dimension in the cme_db.cdl file which defines the database.
; There currently up to 3 features which can be stored (loop, cavity, core)
; and the calculated values are in a 3 dimensional array with 0=core, 
; 1=cavity, and 2=core.  Quality is a subjective number 1-5.
; 
; Use the overwrite='xxdxxx' keyword to explicitly replace an event with
; new values.  Identifier xxdxxx must be an exact string, include any 
; a,b,c,d,... suffixes to ensure that the correct event is being 
; overwritten.

PRO mark_db_add, data, day_num, inst_num

  ;===Open the database
  ;
  ;db_id=NCDF_OPEN('/home/tdarnell/idl/database/cme_meas_db.nc',/WRITE)
  db_id=NCDF_OPEN('mark_db.nc',/WRITE)

  ;===Get the variable id's, what a pain.
  ;
  year_id=		NCDF_VARID(db_id,'YEAR')
  doy_id=		NCDF_VARID(db_id,'DOY')
  num_events_id=	NCDF_VARID(db_id,'NUM_EVENTS')
  quality_id=		NCDF_VARID(db_id,'QUALITY')
  start_hr_id=		NCDF_VARID(db_id,'START_HR')
  start_min_id=		NCDF_VARID(db_id,'START_MIN')
  stop_hr_id=		NCDF_VARID(db_id,'STOP_HR')
  stop_min_id=		NCDF_VARID(db_id,'STOP_MIN')
  lat_id=		NCDF_VARID(db_id,'LAT')
  lat_error_id=		NCDF_VARID(db_id,'LAT_ERROR')
  lon_id=		NCDF_VARID(db_id,'LON')
  lon_error_id=		NCDF_VARID(db_id,'LON_ERROR')
  pa_id=		NCDF_VARID(db_id,'PA') ;vacations
  pa_error_id=		NCDF_VARID(db_id,'PA_ERROR')
  ar_id=		NCDF_VARID(db_id,'AR') ;extra dry
  comment_id=		NCDF_VARID(db_id,'COMMENT')

  ;
  ;===Get dimensions
  ;
  NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'index'),ind_str,index
  NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'numinst'),numinst_str,numinst
  NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'numperday'),numperday_str,numperday
  NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'comment_len'),comment_len_str,comment_len

  ;
  ;===Fill measurement array with measurements from data structure
  ;
  

  NCDF_VARPUT,db_id,year_id,data.year,OFFSET=[day_num]
  NCDF_VARPUT,db_id,doy_id,data.doy,OFFSET=[day_num]

  NCDF_VARPUT,db_id,quality_id,data.quality,OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,start_hr_id,data.start_hr,OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,start_min_id,data.start_min, $
	OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,stop_hr_id,data.stop_hr,OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,stop_min_id,data.stop_min,OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,lat_id,data.lat,OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,lat_error_id,data.lat_error, $
	OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,lon_id,data.lon,OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,lon_error_id,data.lon_error, $
	OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,pa_id,data.pa,OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,pa_error_id,data.pa_error,OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,ar_id,data.ar,OFFSET=[0,inst_num,day_num]
  NCDF_VARPUT,db_id,comment_id,data.comment,OFFSET=[0,0,inst_num,day_num]
  ;
  ;===Close the database
  ;
  NCDF_CLOSE,db_id

END
