FUNCTION mark_db_buttons, ev

  COMMON STATE_INFO, day_num, inst_num

  IF (ev.value EQ 'New Event') THEN BEGIN

	;--- Open the database and get the event list
	db_id=NCDF_OPEN('mark_db.nc',/WRITE)
	year_id=		NCDF_VARID(db_id,'YEAR')
	doy_id=		NCDF_VARID(db_id,'DOY')
	num_events_id=	NCDF_VARID(db_id,'NUM_EVENTS')
	quality_id=		NCDF_VARID(db_id,'QUALITY')
	start_hr_id=		NCDF_VARID(db_id,'START_HR')
	start_min_id=		NCDF_VARID(db_id,'START_MIN')
	stop_hr_id=		NCDF_VARID(db_id,'STOP_HR')
	stop_min_id=		NCDF_VARID(db_id,'STOP_MIN')
	lat_id=		NCDF_VARID(db_id,'LAT')
	lat_error_id=		NCDF_VARID(db_id,'LAT_ERROR')
	lon_id=		NCDF_VARID(db_id,'LON')
	lon_error_id=		NCDF_VARID(db_id,'LON_ERROR')
	pa_id=		NCDF_VARID(db_id,'PA')
	pa_error_id=		NCDF_VARID(db_id,'PA_ERROR')
	ar_id=		NCDF_VARID(db_id,'AR')
	comment_id=		NCDF_VARID(db_id,'COMMENT')


  	Widget_CONTROL,ev.id,GET_UVALUE=state
	WIDGET_CONTROL,state.data_table,GET_VALUE=table_data


	;--- Open the database and get the event list
	db_id=NCDF_OPEN('mark_db.nc',/WRITE)
	NCDF_VARGET1,db_id,num_events_id,num_events,OFFSET=[inst_num,day_num]
	NCDF_VARPUT,db_id,num_events_id,num_events+1,OFFSET=[inst_num,day_num]

	NCDF_CLOSE,db_id
  ENDIF

  IF (ev.value EQ 'New Day') THEN BEGIN

	;--- Open the database and get the event list
	db_id=NCDF_OPEN('mark_db.nc',/WRITE)
	year_id=		NCDF_VARID(db_id,'YEAR')
	doy_id=		NCDF_VARID(db_id,'DOY')
	num_events_id=	NCDF_VARID(db_id,'NUM_EVENTS')
	quality_id=		NCDF_VARID(db_id,'QUALITY')
	start_hr_id=		NCDF_VARID(db_id,'START_HR')
	start_min_id=		NCDF_VARID(db_id,'START_MIN')
	stop_hr_id=		NCDF_VARID(db_id,'STOP_HR')
	stop_min_id=		NCDF_VARID(db_id,'STOP_MIN')
	lat_id=		NCDF_VARID(db_id,'LAT')
	lat_error_id=		NCDF_VARID(db_id,'LAT_ERROR')
	lon_id=		NCDF_VARID(db_id,'LON')
	lon_error_id=		NCDF_VARID(db_id,'LON_ERROR')
	pa_id=		NCDF_VARID(db_id,'PA')
	pa_error_id=		NCDF_VARID(db_id,'PA_ERROR')
	ar_id=		NCDF_VARID(db_id,'AR')
	comment_id=		NCDF_VARID(db_id,'COMMENT')

   fill_arr= REPLICATE(0,20,7)
   str_fill_arr= REPLICATE('',20,7)

   NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'index'),ind_str,index
   ;index = index + 1
   NCDF_VARPUT,db_id,num_events_id,[1,1,1,1,1,1,1],OFFSET=[0,index]
   NCDF_VARPUT,db_id,year_id,[1990],OFFSET=[index]
   NCDF_VARPUT,db_id,doy_id,[0],OFFSET=[index]
   NCDF_VARPUT,db_id,quality_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,start_hr_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,start_min_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,stop_hr_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,stop_min_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,lat_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,lat_error_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,lon_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,lon_error_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,pa_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,pa_error_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,ar_id,fill_arr,OFFSET=[0,0,index]
   NCDF_VARPUT,db_id,comment_id,str_fill_arr,OFFSET=[0,0,0,index]
	NCDF_CLOSE,db_id

   day_num=index-1
   inst_num=0
ENDIF

  IF (ev.value EQ 'Update') THEN BEGIN

    WIDGET_CONTROL,ev.id,GET_UVALUE=state
    WIDGET_CONTROL,state.data_table,GET_VALUE=table_data
    WIDGET_CONTROL,state.data_label,GET_VALUE=label_data

    num=SIZE(WHERE(table_data.start_t NE ''))
    billy=num(1)-1

    nd=20
    ni=7
    newdata= {year:0, doy:0, num_events:0, quality:BYTARR(nd), $
	start_hr:BYTARR(nd), start_min:BYTARR(nd),stop_hr:BYTARR(nd), $
	stop_min:BYTARR(nd),lat:INTARR(nd),lat_error:BYTARR(nd), $
	lon:INTARR(nd),lon_error:BYTARR(nd),pa:INTARR(nd), $
	pa_error:BYTARR(nd),ar:INTARR(nd),comment:STRARR(nd) $
	}

    ; First things that need preparation: date, time.
	
	year=0
	doy=0
	temp=STR_SEP(label_data(0),'d')
	READS, temp[0],year
	READS, temp[1],doy
	newdata.year=year
	newdata.doy=doy

	temp=0
	FOR I=0,billy DO BEGIN
	 hr=0
	 min=0
	 matlock=table_data.start_t
	 matlock=matlock[I]
	 temp=STR_SEP(matlock,':')
	 READS, temp[0], hr
	 READS, temp[1], min
	 newdata.start_hr[I]=hr
	 newdata.start_min[I]=min

	 matlock=table_data.stop_t
	 matlock=matlock[I]
	 temp=STR_SEP(matlock,':')
	 READS, temp[0], hr
	 READS, temp[1], min
	 newdata.stop_hr[I]=hr
	 newdata.stop_min[I]=min
	ENDFOR

    sz=SIZE(WHERE(table_data.start_t NE ''))
    newdata.num_events=sz(1)
    newdata.quality[0:billy]=table_data[0:billy].quality
    newdata.lat[0:billy]=table_data[0:billy].lat
    newdata.lat_error[0:billy]=table_data[0:billy].lat_error
    newdata.lon[0:billy]=table_data[0:billy].lon
    newdata.lon_error[0:billy]=table_data[0:billy].lon_error
    newdata.pa[0:billy]=table_data[0:billy].pa
    newdata.pa_error[0:billy]=table_data[0:billy].pa_error
    newdata.ar[0:billy]=table_data[0:billy].ar
    newdata.comment[0:billy]=table_data[0:billy].comment
    mark_db_add,newdata,day_num,inst_num

    state.year_arr[day_num]=newdata.year
    state.doy_arr[day_num]=newdata.doy
    db_id=NCDF_OPEN('mark_db.nc')
    NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'index'),ind_str,index
    datestring_arr=STRARR(index)
    FOR I=0,index-1 DO $
	datestring_arr[I]=STRING(state.year_arr[I], state.doy_arr[I], $
		FORMAT = '(I4,"d",I3)')
    WIDGET_CONTROL,state.event_list, SET_VALUE=datestring_arr
    WIDGET_CONTROL,ev.id,SET_UVALUE=state
  ENDIF

  IF (ev.value EQ 'Help!') THEN mark_db_help

  IF (ev.value EQ 'Quit') THEN WIDGET_CONTROL,ev.top,/DESTROY

END
