;
; This function retrieves a day's observations 
; from the CME measurement data base.
;  It returns the following structure:
;
;  --- define the data structure to return
;  data= {year:0, doy:0, num_events:0, quality:BYTARR(nd), $
;	start_hr:BYTARR(nd), start_min:BYTARR(nd),stop_hr:BYTARR(nd), $
;	stop_min:BYTARR(nd),lat:BYTARR(nd),lat_error:BYTARR(nd), $
;	lon:BYTARR(nd),BYT_error:FLTARR(nd),pa:INTARR(nd), $
;	pa_error:BYTARR(nd),ar:INTARR(nd),comment:STRARR(5) $
;	}

FUNCTION mark_db_get, day_num, inst_num

nd=20
ni=7

  ;--- define the data structure to return
  data= {year:0, doy:0, num_events:0, quality:BYTARR(nd), $
	start_hr:BYTARR(nd), start_min:BYTARR(nd),stop_hr:BYTARR(nd), $
	stop_min:BYTARR(nd),lat:INTARR(nd),lat_error:BYTARR(nd), $
	lon:INTARR(nd),lon_error:BYTARR(nd),pa:INTARR(nd), $
	pa_error:BYTARR(nd),ar:INTARR(nd),comment:STRARR(nd) $
	}

  ;--- Open the database
  db_id=NCDF_OPEN('mark_db.nc')

  ;
  ;===Get the variable id's, what a pain.
  ;
  year_id=		NCDF_VARID(db_id,'YEAR')
  doy_id=		NCDF_VARID(db_id,'DOY')
  num_events_id=	NCDF_VARID(db_id,'NUM_EVENTS')
  quality_id=		NCDF_VARID(db_id,'QUALITY')
  start_hr_id=		NCDF_VARID(db_id,'START_HR')
  start_min_id=		NCDF_VARID(db_id,'START_MIN')
  stop_hr_id=		NCDF_VARID(db_id,'STOP_HR')
  stop_min_id=		NCDF_VARID(db_id,'STOP_MIN')
  lat_id=		NCDF_VARID(db_id,'LAT')
  lat_error_id=		NCDF_VARID(db_id,'LAT_ERROR')
  lon_id=		NCDF_VARID(db_id,'LON')
  lon_error_id=		NCDF_VARID(db_id,'LON_ERROR')
  pa_id=		NCDF_VARID(db_id,'PA') ;vacations
  pa_error_id=		NCDF_VARID(db_id,'PA_ERROR')
  ar_id=		NCDF_VARID(db_id,'AR') ;extra dry
  comment_id=		NCDF_VARID(db_id,'COMMENT')

  ;
  ;===Get dimensions
  ;
  NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'index'),ind_str,index
  NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'numinst'),numinst_str,numinst
  NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'numperday'),numperday_str,numperday
  NCDF_DIMINQ,db_id,NCDF_DIMID(db_id,'comment_len'),comment_len_str,comment_len

  ;
  ;--- Start getting event info
  ;
  if day_num GE 0 THEN BEGIN
	NCDF_VARGET1,db_id,year_id,year,OFFSET=[day_num]
	NCDF_VARGET1,db_id,doy_id,doy,OFFSET=[day_num]

	data.year=year
	data.doy=doy

	; Number of events
	NCDF_VARGET1,db_id,num_events_id,num_events,OFFSET=[inst_num,day_num]
	data.num_events=num_events

	;--- Get "quality" array
	NCDF_VARGET,db_id,quality_id,quality_arr,OFFSET=[0,inst_num,day_num], $
		COUNT=[num_events,1,1]
	data.quality[0:num_events-1]=quality_arr

	;--- Get Start time
	NCDF_VARGET,db_id,start_hr_id,start_hr_arr,OFFSET=[0,inst_num,day_num], $
		COUNT=[num_events,1,1]
	data.start_hr[0:num_events-1]=start_hr_arr
	NCDF_VARGET,db_id,start_min_id,start_min_arr,OFFSET=[0,inst_num,day_num], $
		COUNT=[num_events,1,1]
	data.start_min[0:num_events-1]=start_min_arr

	;--- Get Stop time
  	NCDF_VARGET,db_id,stop_hr_id,stop_hr_arr,OFFSET=[0,inst_num,day_num], $
		COUNT=[num_events,1,1]
	data.stop_hr[0:num_events-1]=stop_hr_arr
	NCDF_VARGET,db_id,stop_min_id,stop_min_arr,OFFSET=[0,inst_num,day_num], $
		COUNT=[num_events,1,1]
	data.stop_min[0:num_events-1]=stop_min_arr

	;--- Get latitude array
	NCDF_VARGET,db_id,lat_id,lat_arr,OFFSET=[0,inst_num,day_num],COUNT=[num_events,1,1]
	data.lat[0:num_events-1]=lat_arr

	;--- Get latitude error array
	NCDF_VARGET,db_id,lat_error_id,lat_error_arr,OFFSET=[0,inst_num,day_num],$
		COUNT=[num_events,1,1]
	data.lat_error[0:num_events-1]=lat_error_arr

	;--- Get longitude array
	NCDF_VARGET,db_id,lon_id,lon_arr,OFFSET=[0,inst_num,day_num],COUNT=[num_events,1,1]
	data.lon[0:num_events-1]=lon_arr

	;--- Get longitude error array
	NCDF_VARGET,db_id,lon_error_id,lon_error_arr,OFFSET=[0,inst_num,day_num],COUNT=[num_events,1,1]
	data.lon_error[0:num_events-1]=lon_error_arr

	;--- Get PA array
	NCDF_VARGET,db_id,pa_id,pa_arr,OFFSET=[0,inst_num,day_num],COUNT=[num_events,1,1]
	data.pa[0:num_events-1]=pa_arr

	;--- Get PA error array
	NCDF_VARGET,db_id,pa_error_id,pa_error_arr,OFFSET=[0,inst_num,day_num],COUNT=[num_events,1,1]
	data.pa_error[0:num_events-1]=pa_error_arr

	;--- Get AR array
	NCDF_VARGET,db_id,ar_id,ar_arr,OFFSET=[0,inst_num,day_num], $
		COUNT=[num_events,1,1]
	data.ar[0:num_events-1]=ar_arr

	;--- Get Comment array
	NCDF_VARGET,db_id,comment_id,comment_arr,$
		OFFSET=[0,0,inst_num,day_num], $
		COUNT=[comment_len,num_events,1,1]
	data.comment[0:num_events-1]=STRING(comment_arr)

	;--- Close the database
	NCDF_CLOSE,db_id

	;--- Return the structure
	RETURN, data
   ENDIF

END
