FUNCTION mark_db_help_get, ev

	num=ev.index
	cr=STRING(10B)
	
	IF num EQ 0 THEN help_text = '     CME Database Manager was developed by Mark Neyrinck at the High Altitude Observatory (HAO) at NCAR in Boulder, CO.  It allows the user to enter, and edit, fields into the CME Database file.'
	IF num EQ 1 THEN help_text = STRING( $
'     Here are descriptions of the various fields:',cr,cr,$
'     Start_t: Time of first frame of movie loop in which event appears',cr,$
'     Stop_t: Time of last frame of movie loop in which event appears',cr,$
'     Quality: Subjective measure of how certain the observer was that the event actually occurred',$
'     Lat: Apparent latitude on disk',cr,$
'     Length: Difference in latitude between the top and bottom of the feature',cr,$
'     Lon: Apparent longitude on disk',cr,$
'     Width: Difference in longitude between the two horizontal extents of the feature',$
'     PA: Position angle on limb',cr,$
'     Width: "Width" in degrees of feature on limb',cr,$
'     AR#: Active region number, if any',cr,$
'     Comment: Classification of feature(s) (separated by semi-colons), along with brief descriptions in parentheses.')

	IF num EQ 2 THEN help_text = '     Retrieving data in this program is quite easy; simply click on the year, day of year combination and the instrument you want, and a display of all of the observations for that day and instrument will appear.'

	IF num EQ 3 THEN help_text = '     To edit observations, first retrieve the data for the day and instrument you wish to edit, then click on the appropriate field and edit it.  After you have finished, click "Update" to save the changes.  NOTE: If you switch to another day or instrument before clicking "Update," your changes will be lost.'

	IF num EQ 4 THEN help_text = STRING( $
'     Because of a couple of quasi-bugs in this program, adding information is somewhat more complicated or confusing than it probably should be.  These bugs cause the program not to update the data display automatically when new days or observations are added.',cr, $
'     To add another observation to a day and instrument, first click on those days and instruments from the lists on the left side of the display.  Then click on "New Event."  Nothing will happen immediately.  You must then click again on either the day or the instrument for the new event to appear, characterized by "00:00" in the time columns.  DO NOT ADD INFORMATION IN EMPTY FIELDS BEFORE CLICKING ON "New Event;" your new data might be erased when you do register the new observation.',cr, $
'     To add another day of observations, click on "New Day."  Again, this will not do anything obvious; you must quit the program, then restart it for the new day to appear in the day list.  It will appear with the default YEARdDOY, 1990d000, which you can change by editing the field above the database grid showing the YEARdDOY and then clicking "Update."')

	IF num EQ 5 THEN WIDGET_CONTROL,ev.top,/DESTROY $
	ELSE BEGIN
		WIDGET_CONTROL,ev.id,GET_UVALUE=state,/NO_COPY
		WIDGET_CONTROL,state.text_space,SET_VALUE=help_text
		WIDGET_CONTROL,ev.id,SET_UVALUE=state
	ENDELSE
	RETURN,ev
END
