FUNCTION mark_db_settable, day_num, inst_num

  ev_data=mark_db_get(day_num, inst_num)
  num=ev_data.num_events
  table=REPLICATE({start_t:'',stop_t:'',quality:0,$
	lat:0,lat_error:0,lon:0,lon_error:0,pa:0, $
	pa_error:0,ar:0,comment:''},100)
  labeltable= {date:'', table:table}


  ;Things that need preparation
  zero_str=''
  IF ev_data.doy LE 9 THEN zero_str='0'
  IF ev_data.doy LE 99 THEN zero_str=zero_str+'0'
  labeltable.date = $
	STRCOMPRESS(STRING(ev_data.year,'d',zero_str,ev_data.doy),/REMOVE_ALL)

  FOR I=0, num-1 DO BEGIN 
	zero_str=''
	min_zero_str=''
	IF ev_data.start_hr[I] LE 9 THEN zero_str='0'
  	IF ev_data.start_min[I] LE 9 THEN min_zero_str='0'
	labeltable.table[I].start_t=STRCOMPRESS(STRING(zero_str, $
		ev_data.start_hr[I], ':',min_zero_str,$
		ev_data.start_min[I]),/REMOVE_ALL)
  ENDFOR

  FOR I=0, num-1 DO BEGIN 
	zero_str=''
	min_zero_str=''
	IF ev_data.stop_hr[I] LE 9 THEN zero_str='0'
  	IF ev_data.stop_min[I] LE 9 THEN min_zero_str='0'
	labeltable.table[I].stop_t=STRCOMPRESS(STRING(zero_str,ev_data.stop_hr[I], $
	':',min_zero_str,ev_data.stop_min[I]),/REMOVE_ALL)
  ENDFOR

  labeltable.table[0:num-1].quality=ev_data.quality[0:num-1]
  labeltable.table[0:num-1].lat=ev_data.lat[0:num-1]
  labeltable.table[0:num-1].lat_error=ev_data.lat_error[0:num-1]
  labeltable.table[0:num-1].lon=ev_data.lon[0:num-1]
  labeltable.table[0:num-1].lon_error=ev_data.lon_error[0:num-1]
  labeltable.table[0:num-1].pa=ev_data.pa[0:num-1]
  labeltable.table[0:num-1].pa_error=ev_data.pa_error[0:num-1]
  labeltable.table[0:num-1].ar=ev_data.ar[0:num-1]
  labeltable.table[0:num-1].comment=ev_data.comment[0:num-1]

  RETURN, labeltable

END
