#include "stdio.h"
#include "string.h"
#include "flatfile.h"
#include "stdlib.h"
#include "math.h"

float* ave_value(char filein[100]) {

  char *vn, *vu, *vs, *vt, no[1000];
  char stime[24],etime[24], outstime[24], outetime[24], yorn[20];
  double suttime, euttime, uttime[1], *oldtime;
  int inunit, outunit, ncol[1], csize[1], error, nc;
  long srow, erow, nrow[1], orow, irow, *npts, timep, i, j, k;
  long *nptsdt;
  float *data, dt, dts, *superdata, missing, *mindata, *maxdata, *avedt;
  float *olddata, *mindtdata, *maxdtdata, temp;
  float *returnvalues;

  missing = -1.0e32;

  inunit = ffopen(filein);

  vn = calloc(sizeof(char),ff_ncol[inunit]*16+2);
  vu = calloc(sizeof(char),ff_ncol[inunit]*16+2);
  vs = calloc(sizeof(char),ff_ncol[inunit]*31+2);
  vt = calloc(sizeof(char),ff_ncol[inunit]*2+2);
  data = calloc(sizeof(float),ff_ncol[inunit]);

  error = rdhead(inunit,vn,vu,vs,vt,no,
                 stime,etime,nrow,ncol,csize); 

  srow = 0;
  erow = n_rows(inunit)-1;
  printf("srow : %ld erow : %ld\n",srow,erow);
  nc = n_columns(inunit);

  superdata = calloc(sizeof(float),nc);
  olddata = calloc(sizeof(float),nc);
  oldtime = calloc(sizeof(double),nc);
  avedt = calloc(sizeof(float),nc);
  maxdata = calloc(sizeof(float),nc);
  mindata = calloc(sizeof(float),nc);
  maxdtdata = calloc(sizeof(float),nc);
  mindtdata = calloc(sizeof(float),nc);
  npts = calloc(sizeof(long), nc);
  nptsdt = calloc(sizeof(long), nc);
  returnvalues = calloc(sizeof(float),(nc)*6+2);

  for (j=0;j<nc-1; j++) {
    superdata[j] = 0.0;
    avedt[j] = 0.0;
    maxdata[j] = -1.0e32;
    mindata[j] = 1.0e32;
    maxdtdata[j] = -1.0e32;
    mindtdata[j] = 1.0e32;
    olddata[j] = missing;
    npts[j] = 0; 
    nptsdt[j] = 0; }

  for (i=srow; i<=erow; i++) {

    error = fdget(inunit,i,uttime,data);

    for (j=0; j<nc-1; j++) {
      if (data[j] != missing) {
	superdata[j] = superdata[j] + data[j];
	if (data[j] > maxdata[j]) maxdata[j] = data[j];
	if (data[j] < mindata[j]) mindata[j] = data[j];
	npts[j]++; 
	if (olddata[j] == missing) {
	  olddata[j] = data[j];
	  oldtime[j] = uttime[0]; }
	else {
	  dt = (float) (uttime[0] - oldtime[j]);
	  temp = fabs(data[j] - olddata[j])/dt;
	  olddata[j] = data[j];
	  oldtime[j] = uttime[0];
	  avedt[j] = avedt[j] + temp;
	  nptsdt[j]++;
	  if (temp > maxdtdata[j]) maxdtdata[j] = temp;
	  if (temp < mindtdata[j]) mindtdata[j] = temp; } } } }

  ffclose(inunit);

  returnvalues[0] = (float) (ncol[0]-1);

  for (j=0; j<nc-1; j++) {
    if (npts[j] != 0) { superdata[j] = superdata[j]/(float) npts[j]; }
    else {
      superdata[j] = missing;
      mindata[j] = missing;
      maxdata[j] = missing; }
    if (nptsdt[j] != 0) { avedt[j] = avedt[j]/(float) nptsdt[j]; }
    else {
      avedt[j] = missing;
      mindtdata[j] = missing;
      maxdtdata[j] = missing; }
    returnvalues[j*6+1] = superdata[j];
    returnvalues[j*6+2] = mindata[j];
    returnvalues[j*6+3] = maxdata[j];
    returnvalues[j*6+4] = avedt[j];
    returnvalues[j*6+5] = mindtdata[j];
    returnvalues[j*6+6] = maxdtdata[j]; }

  free(vn);
  free(vu);
  free(vs);
  free(vt);
  free(data);
  free(superdata);
  free(olddata);
  free(oldtime);
  free(avedt);
  free(maxdata);
  free(mindata);
  free(maxdtdata);
  free(mindtdata);
  free(npts);
  free(nptsdt);

  return returnvalues; }

