#include "amath.h"

void c_r_to_i(int itime[6], double timereal) {

  int dayofmon[12] = {31,28,31,30,31,30,31,31,30,31,30,31};
  int nyear, nleap, nmonth, nday, nhour, nmin, nsec, i;
  double speryear = 31536000.0;
  double sperday = 86400.0;
  double sperhour = 3600.0;
  double spermin = 60.0;
  double timeleft;

  nyear = (int) (timereal/speryear);
  if ((nyear+65) % 4 == 0) dayofmon[1]++;
  timeleft = timereal - ((double) nyear)*speryear;
  nday = (int) (dmod(timeleft,speryear)/sperday);
  nleap = nyear/4;
  nday = nday - nleap;
  if (nday < 0) {
    if ((nyear+65) % 4 == 0) dayofmon[1]--;
    nyear--;
    nday = nday + nleap + 365;
    if ((nyear+65) % 4 == 0) dayofmon[1]++;
    nleap = nyear/4;
    nday = nday - nleap; }
  timeleft = timeleft - ((double) nday)*sperday;
  nhour = (int) (dmod(timeleft,sperday)/sperhour);
  timeleft = timeleft - ((double) nhour)*sperhour;
  nmin = (int) (dmod(timeleft,sperhour)/spermin);
  timeleft = timeleft - ((double) nmin)*spermin;
  nsec = (int) dmod(timeleft,spermin);

  nmonth = 0;

  while (nday >= dayofmon[nmonth]) {
    nday = nday - dayofmon[nmonth];
    nmonth++; }

  itime[0] = nyear + 65;
  if (itime[0] > 99) itime[0] = itime[0] - 100;
  itime[1] = nmonth + 1;
  itime[2] = nday + 1;
  itime[3] = nhour;
  itime[4] = nmin;
  itime[5] = nsec; }


