#include "stdio.h"
#include "flatfile.h"

/* ---------------------------------------------------------------------------
   fdget - gets data from a flatfile.
--------------------------------------------------------------------------- */

int fdget(int unit, long row, double *uttime, float *data) {

  int error;
  FILE *datafile;

  error = 0;

  if (!ff_pointer[unit]) {
    printf("Data file is not opened - Error.\n");
    error = 1; }

  if (!error && (row > ff_rows[unit] || row < 0)) {
    printf("Invalid row.\n");
    error = 1; }

  if (!error) {

    datafile = ff_pointer[unit];

    error = fseek(datafile,row*ff_c_tot[unit],SEEK_SET);
    if (!error) {
      fread(uttime, sizeof(double), 1, datafile);
      fread(data,ff_c_tot[unit]-sizeof(double),1,datafile); }
    else {
      printf("Error trying to find the correct row.\n"); } }

  return error; }

