#include "stdio.h"
#include "flatfile.h"

/* ---------------------------------------------------------------------------
   fdput - puts data into a flatfile.
--------------------------------------------------------------------------- */

int fdput(int unit, long row, double uttime, float *data) {

  int error;
  FILE *datafile;

  error = 0;

  if (!ff_pointer[unit]) {

    printf("Data file is not opened - Error.\n");
    error = 1; }

  if (!ff_readwrite[unit]) {

    printf("Data file is opened read only, please open read/write.\n");
    error = 1; }

  if (!error) {

    datafile = ff_pointer[unit];

    if (row >= ff_rows[unit]) {

      ff_rows[unit]++;
      
      error = fseek(datafile,0,SEEK_END);
      if (error) {
	printf("Error in finding the correct row.\n"); }
      else {
	fwrite(&uttime, sizeof(uttime), 1, datafile);
	fwrite(data,ff_c_tot[unit]-sizeof(uttime),1,datafile); } }

    else {

      if (row < 0) {

	printf("Invalid row - number must be above zero.\n");
	error = 1; }

      else {

	error = fseek(datafile,row*ff_c_tot[unit],SEEK_SET);
	if (error) {
	  printf("Error in finding the correct row.\n"); }
	else {
	  fwrite(&uttime, sizeof(uttime), 1, datafile);
	  fwrite(data,ff_c_tot[unit]-sizeof(uttime),1,datafile); } } } }

  if (!error) {
    if (uttime < ff_stime[unit]) ff_stime[unit] = uttime;
    if (uttime > ff_etime[unit]) ff_etime[unit] = uttime; }

  return error; }

