#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "astring.h"
#include "flatfile.h"

/* ---------------------------------------------------------------------------
   Mkhead - inputs the variables, units, sources, types, notes, and outputs
            a header file.
--------------------------------------------------------------------------- */

int mkhead(char *filename, int nvar, char *name, 
	   char *units, char *source, char *vtype,
	   char *notes) {

  int lu;
  FILE *lfp;
  char lfn[80], *lfnp, *dumb, ltime[23], line[80], smltype[5];
  char *ploc, *scomma, comma[2]=",\0";
  int i, found, iloc, error, done, charn, cloc, strln;

  init_ff_system();

  scomma = comma;

  error = 0;

/* Assign a unit to the new file */

  if (ff_opened == MAX_N_FF) {
    printf("Too many flat files opened.\n");
    error = 1; }
  else {

    ff_opened++;
    lu = 0;
    while (ff_pointer_h[lu]!=NULL) lu++;

/* Want to save filename */

    lfnp = filename;
    strcpy(lfn, lfnp);

/* open the file */

    ff_pointer_h[lu] = fopen(strcat(lfn,".hed"),"w");
    lfp = ff_pointer_h[lu];

/* get date and time */

    get_local_time(ltime);

/* set up list of locations and determine the length of each row.
   This section of code will automatically set up the variables,
   if they are input correctly. The string called VTYPE, is used to
   determine valiable types in the following fashion :
   vtype value  |  variable type  | 
   T            |  double
   R            |  float
   I            |  integer
   C            |  char
   Rn           |  float[n]  (where n is an integer)
   In           |  integer[n] (where n is an integer)
   Cn           |  char[n] (where n is an integer)                   */

    dumb = vtype;

    ploc = malloc(sizeof(char)*(nvar*5+1));
    iloc = 0;

    for (i=1;i<=nvar;i++) {

      if (i > 1) {
	dumb = strchr(dumb,(int) ','); dumb++; }

      cloc = strloc(dumb,scomma);
      if (cloc == -1) cloc = strlen(dumb)+1;
      strcpy(smltype,strmid(dumb,0,cloc-1));

      found = 0;

      if (i == 1) { strcpy(ploc,"0000"); }
      else { strcat(ploc,c_int_str(iloc,4)); }
      strcat(ploc,",");

      if (strstr(mklower(smltype), "t")) {
	found = 1;
	if (strlen(smltype) == 1) { iloc = iloc + sizeof(double); }
	else {
	  printf("arrays are not supported at this time...\n");
	  iloc = iloc + sizeof(double); } }
      if (strstr(mklower(smltype), "r")) {
	found = 1;
	if (strlen(smltype) == 1) { iloc = iloc + sizeof(float); }
	else {
	  printf("arrays are not supported at this time...\n");
	  iloc = iloc + sizeof(float); } }
      if (strstr(mklower(smltype), "i")) {
	found = 1;
	if (strlen(smltype) == 1) { iloc = iloc + sizeof(int); }
	else {
	  printf("arrays are not supported at this time...\n");
	  iloc = iloc + sizeof(int); } }
      if (strstr(mklower(smltype), "c")) {
	found = 1;
	if (strlen(smltype) == 1) { iloc = iloc + sizeof(char); }
	else {
	  printf("arrays are not supported at this time...\n");
	  iloc = iloc + sizeof(char); } }

      if (!found) {
	printf("variable type not found, assuming type float!\n");
	iloc = iloc + sizeof(float); } }

/* start writing the relavent information out to the header file */

    fprintf(lfp, "name of header and data files:          %s\n",filename);
    fprintf(lfp, "date files created:                     %s\n",
	    strmid(ltime,0,9));
    fprintf(lfp, "record length of data file, in bytes:   %s\n",
	    c_int_str(iloc,1));
    fprintf(lfp, "number of columns:                      %s\n",
	    c_int_str(nvar,1));
    fprintf(lfp, "number of rows:                         %s\n",
	    c_int_str(0,10));
    fprintf(lfp, "flag for missing data:                  -1.0E+32 \n");
    fprintf(lfp, "\n");
    fprintf(lfp, "#     ");
    fprintf(lfp, "name          ");
    fprintf(lfp, "units         ");
    fprintf(lfp, "source                       ");
    fprintf(lfp, "type  loc\n");
    fprintf(lfp, "--------------------------------------");
    fprintf(lfp, "--------------------------------------\n");
    
    for (i=1;i<=nvar;i++) {
      dumb = line;
      strcpy(dumb,strpad(c_int_str(i,3),7));
      if (i > 1) {
	name   = strchr(name,(int) ','); name++;
	units  = strchr(units,(int) ','); units++;
	source = strchr(source,(int) ','); source++;
	vtype = strchr(vtype,(int) ','); vtype++;
	ploc = strchr(ploc,(int) ','); ploc++; }
      cloc = strloc(name,scomma);
      if (cloc == -1) cloc = strlen(name)+1;
      strcat(dumb,strpad(strmid(name,0,cloc-1),14));
      cloc = strloc(units,scomma);
      if (cloc == -1) cloc = strlen(units)+1;
      strcat(dumb,strpad(strmid(units,0,cloc-1),14));
      cloc = strloc(source,scomma);
      if (cloc == -1) cloc = strlen(source)+1;
      strcat(dumb,strpad(strmid(source,0,cloc-1),29));
      cloc = strloc(vtype,scomma);
      if (cloc == -1) cloc = strlen(vtype)+1;
      strcat(dumb,strpad(strmid(vtype,0,cloc-1),6));
      cloc = strloc(ploc,scomma);
      if (cloc == -1) cloc = strlen(ploc)+1;
      strcat(dumb,strmid(ploc,0,cloc-1));

      fprintf(lfp, "%s\n",line); }
  
    fprintf(lfp, "\n");
    fprintf(lfp, "NOTES:\n");
    fprintf(lfp, "\n");
    fprintf(lfp, "Start time =  01-JAN-65 00:00:00.000\n");
    fprintf(lfp, "End time   =  01-JAN-65 00:00:00.000\n");
    fprintf(lfp, "\n");

    i = 0;
    done = 0;

    if (strlen(notes) == 0) done = 1;
    while (!done) {
      dumb = line;
      if (i > 0) { 
	notes = strchr(notes,(int) ','); 
	if (notes == NULL) { done = 1; }
	else { notes++; } }
      if (notes != NULL) {
	charn = strloc(notes, scomma)-1;
	strln = strlen(notes);
	if (charn >= strln || !strchr(notes, (int) ',')) {
	  charn = strlen(notes); }
	strcpy(dumb,strmid(notes,0,charn));
	i++;
	fprintf(lfp, "%s\n",line); } }

    fprintf(lfp, "\n");
    fprintf(lfp, "END\n");

    fclose(lfp);

    ff_pointer_h[lu] = NULL;
    ff_opened--;

    error = 0; }

  return error; }
