#include "stdio.h"
#include "flatfile.h"
#include "string.h"
#include "stdlib.h"
#include "astring.h"
#include "misc.h"
#include "amath.h"
#include "math.h"

double quiet_day(int nqd, char *master_file, char *files) {

  char *filelist, *temp, *vn, *vu, *vs, *vt, no[1000], filein[100];
  char stime[23], etime[23], stat[4], line[80], command[80];
  int error, nfiles, inunit, i, ncol[2], found, pos, csize[2];
  int nquiet, j, k, l, m, npt[3], mind, maxd, *order;
  char *filelist2;
  FILE *fpm;
  long nrow[2], srow, erow, crow, index;
  float *lat, *lon, data[20], olddata[3], ave[3], missing, *dtemp;
  float *begtimes, *endtimes, shour, ehour, nhours, *dbdt, minv, maxv;
  double sut, eut, newut[1], oldut[3];
  int *qorder, *nqt, *indices, *indsave, val, sfound, tot, oldtot;
  int *qdorder, done, *order2, maxnqt;
  float maxl, minl, *dlon, *minh, *maxh;

  missing = -1.0e32;
  error = 0;

  /* Get a listing of all the files which we want to compute a quiet day for */

  strcpy(command,"ls ");
  strcat(command,files);
  filelist = spawn(command);
  if (strlen(filelist) == 0) {
    printf("NO FILES LOCATED HERE!!!\n");
    error = 1; }

  /* If we have some files, open the master_psi file to get alat and along */

  if (!error) {
    fpm = fopen(master_file, "r");
    if (fpm == NULL) {
      printf("Could not find master_psi file.\n");
      error = 1; } }

  /* if both the ls and the open were successfull, continue on */

  if (!error) {

    /* count how many files we have located */

    nfiles = 0;
    temp = filelist;
    while (strpos(temp,"\n") > 0) {
      nfiles++;
      temp = temp + strpos(temp,"\n")+1; }

    temp = filelist;
    filelist2 = calloc(sizeof(char), strlen(filelist));

    lat = calloc(sizeof(float), nfiles);
    lon = calloc(sizeof(float), nfiles);
    begtimes = calloc(sizeof(double), nfiles);
    endtimes = calloc(sizeof(double), nfiles);

    /* ------------------------------------------------------------------- */

    /* in this next section, read in latitudes and longitudes of each of the
       magnetometer flat files. If the station is not listed in the master
       psi file, the lat and lon are set to 0, and it is given the lowest
       priority. */

    j = 0;

    for (i=0; i<nfiles; i++) {

      /* get current file name */

      strcpy(filein,strmid(temp,0,strpos(temp,"\n")-4));
      temp = temp + strpos(temp,"\n")+1;

      /* open flat file */

      inunit = ffopen(filein);

      /* if the file was a valid flat file .... */

      if (inunit != -1) {

	vn = calloc(sizeof(char),ff_ncol[inunit]*16+2);
	vu = calloc(sizeof(char),ff_ncol[inunit]*16+2);
	vs = calloc(sizeof(char),ff_ncol[inunit]*31+2);
	vt = calloc(sizeof(char),ff_ncol[inunit]*2+2);

	error = rdhead(inunit,vn,vu,vs,vt,no,
		       stime,etime,nrow,ncol,csize); 

	/* save start and stop time of file */

	begtimes[j] = (float) ((int) (start_time(inunit)/3600.0));
	endtimes[j] = (float) ((int) (end_time(inunit)/3600.0));

	strcpy(stat, strmid(vn,15,3));

	/* search for station name in the master_psi file
	   save lat and lon once the station name is found */

	rewind(fpm);
	found = 0;
	while (!found) {
	  fgets(line,79,fpm);
	  if (feof(fpm)) {
	    found = 1;
	    lat[j] = 0.0;
	    lon[j] = 0.0; }
	  else {
	    pos = strpos(line, mkupper(stat));
	    if (pos == 4) {
	      found = 1;
	      lat[j] = fabs(atof(strmid(line,36,6)));
	      lon[j] = atof(strmid(line,42,7)); } } }

	/* free up variables which were used */

	free(vn);
	free(vu);
	free(vs);
	free(vt);

	/* if opened the file, most likely it can be closed... */

	error = ffclose(inunit);

	/* keep track of all of the real flat files */

	if (j == 0) {
	  strcpy(filelist2,filein); }
	else {
	  strcat(filelist2,filein); }
	strcat(filelist2,".hed\n");

	/* count all of the files that we actually opened */

	j++; } }

    /* change filelist and nfiles to the correct flat files */

    nfiles = j;
    strcpy(filelist, filelist2);
    free(filelist2);
    printf("There are %d FLATFILES in the directory\n",nfiles);

    /* show users the latitudinal extent of the chains */

    printf("min lat : %f  max lat : %f\n",min(lat,nfiles),
	   max(lat,nfiles));

    /* -------------------------------------------------------------------- */

    /* in the second section, the magnetometers which will be used for
       determining the quiet day are selected. Magnetometers in the
       auroral regions are best for this, so the latitudinal range
       starts between 74 and 75 degrees, and then is expended to lower
       latitudes until enough magnetometers are found. */

    /* the first criteria is if there aren't enough stations, simply
       use the ones which are available. */

    if (nqd >= nfiles) {

      nquiet = nfiles;
      qdorder = calloc(sizeof(int),nquiet);
      for (i=0; i<nquiet; i++) qdorder[i] = i; }

    else {

      /* If there are too many stations, start searching for the 
	 ones in the correct latitudes. Expend the latitudes if
	 neccessary. */

      order = sort(lat,nfiles);

      done = 0;
      maxl = 75.0;
      minl = 74.5;

      while (!done) {
	nquiet = 0;
	for (i=0; i<nfiles; i++) {
	  if ((lat[order[i]] >= minl) && (lat[order[i]] <= maxl)) nquiet++; }
	if (nquiet >= nqd) {
	  done = 1; }
	else {
	  minl = minl - 0.5;
	  if (minl < 0) {
	    minl = minl + 0.5;
	    maxl = maxl + 0.5;
	    if (maxl > 90) done = 1; } } }

      /* record which stations are in the correct latitudes. */

      j = 0;
      qdorder = calloc(sizeof(int),nquiet);
      for (i=0; i<nfiles; i++) {
	if ((lat[order[i]] >= minl) && (lat[order[i]] <= maxl)) {
	  qdorder[j] = order[i];
	  j++; } }
      free(order); }

    /* -------------------------------------------------------------------- */
    /* the third second reads the data from the flat files, computes db/dt
       for each point, averages an hours worth of data at a time, and then
       does a running 24 hour average of the db/dt values. */

    shour = min(begtimes,nfiles);
    ehour = max(endtimes,nfiles);
    nhours = (long) (ehour - shour);
    if (nhours < 1) nhours = 1;
    index = 3*nhours*nquiet;
    dbdt = calloc(sizeof(float),index);
    index = nhours*nquiet;
    qorder = calloc(sizeof(int),index);
    maxh = calloc(sizeof(float),index);
    minh = calloc(sizeof(float),index);
    nqt = calloc(sizeof(int),nquiet);

    for(i=0; i<nquiet; i++) {
      k = qdorder[i];

      /* figure out file name to open and get data from */
      
      temp = filelist;
      for (j=0; j < k; j++) {
	temp = temp + strpos(temp,"\n")+1; }
      strcpy(filein,strmid(temp,0,strpos(temp,"\n")-4));
      printf("reading file : %s\n", filein);
      printf("lat : %f lon : %f \n",lat[k],lon[k]);

      inunit = ffopen(filein);

      nqt[i] = 0;

      /* want to determine average db/dt for each hour between the start */
      /* time and stop time. These hourly averages will be used to */
      /* determine the quiet days. */

      for (j=(long) shour; j<(long) ehour; j++) {

	sut = ((double) j)*((double) 3600.0);
	eut = sut + (double) 3600.0;
	srow = fdsearch(inunit,sut);
	erow = fdsearch(inunit,eut);

	/* compute db/dt and average 1 hours worth of data */

	if (srow != erow) {
	  for (l=0;l<3;l++) {
	    maxl = -1.0e32;
	    minl = 1.0e32;
	    ave[l] = 0.0;
	    npt[l] = 0; }
	  error = fdget(inunit,srow,newut,data);
	  for (l=0;l<3;l++) {
	    olddata[l] = data[l];
	    oldut[l] = newut[0]; }
	  for (crow=srow+1; crow<erow; crow++) {
	    error = fdget(inunit,crow,newut,data);
	    for (l=0;l<3;l++) {
	      if (data[l] < minl) minl = data[l];
	      if (data[l] > maxl) maxl = data[l];
	      if (olddata[l] == missing) {
		olddata[l] = data[l];
		oldut[l] = newut[0]; }
	      else {
		if ((data[l] != missing) && (newut[0] != oldut[l])) {
		  ave[l] = ave[l] + fabs(data[l] - olddata[l])/
		    (newut[0] - oldut[l]);
		  npt[l]++;
		  olddata[l] = data[l];
		  oldut[l] = newut[0]; } } } }
	  for (l=0;l<3;l++) {
	    index = (long) (l+i*3)*(nhours)+(j-(long)shour);
	    if (npt[l] > 0) {
	      dbdt[index] = ave[l]/(float) npt[l]; }
	    else {
	      dbdt[index] = missing; } }
	  index = (long) i*(nhours)+(j-(long)shour);
	  maxh[index] = maxl;
	  minh[index] = minl; }
	else {
	  for (l=0;l<3;l++) {
	    index = (long) (l+i*3)*(nhours)+(j-(long)shour);
	    dbdt[index] = missing; } } }

      /* compute a 24 hour running average */

      if (nhours >= 24) {

	for (j=0; j<(long) nhours-24; j++) {
	  for (l=0;l<3;l++) {
	    ave[l] = 0.0;
	    npt[l] = 0;
	    index = (long) (l+i*3)*(nhours)+j;
	    for (k=0; k<24; k++) {
	      if (dbdt[index+k] != missing) {
		ave[l] = ave[l] + dbdt[index+k];
		npt[l]++; } }
	    index = (long) i*(nhours)+j;
	    maxv = -1.0e32;
	    for (k=0; k<24; k++) {
	      minl = minh[index+k];
	      maxl = maxh[index+k];
	      if ((maxl-minl) > maxv) {
		maxv = maxl - minl; } }
	    if (npt[l] == 24) {
	      dbdt[index] = (ave[l]/24.0)*maxv; }
	    else {
	      dbdt[index] = missing; } } }

	/* figure out which component has the largest db/dt and select
	   that one as the one to use to figure out quiet day */

	for (j=0; j<(long) nhours-24; j++) {
	  maxv = -1.0e32;
	  for (l=0;l<3;l++) {
	    index = (long) (l+i*3)*(nhours)+j;
	    if ((dbdt[index] > maxv) && (dbdt[index] != missing)) {
	      maxv = dbdt[index]; } }
	  index = (long) (i*3)*nhours + j;
	  dbdt[index] = maxv; }

	/* want to sort the running average to get a list of the quietest
	   times in order of most quiet to least quiet. this list is stored
	   in qorder. */

	index = (long) ((i*3)*(nhours));
	dtemp = dbdt + index;

	if (nhours > 24) {
	  order = sort_m(dtemp,nhours-24,missing); }
	else {
	  index = (long) i*(nhours);
	  if (dtemp[0] != missing) {
	    qorder[index] = 0; }
	  else {
	    qorder[index] = -1; } }

	for (j=0; j<nhours-24; j++) {
	  index = (long) i*(nhours)+j;
	  qorder[index] = order[j];
	  if (order[j] > 0) { 
	    nqt[i]++; } } }

      else {
	for (j=0; j<nhours; j++) {
	  index = (long) i*(nhours)+j;
	  qorder[index] = -1; } } }

    /* the forth part actually determines the quiet day. This section is
       a little complicated. An example of the though process involved is
       given below : 

       if we have three arrays :

       10, 09, 12
       10, 11, 09
       11, 09, 10

       and we say that each row represents the quiet day, in order of the
       "quietness" for a given magnetometer. Which day should be the quiet
       day?

       The 10th. That is because the position for 10 is the 0th position
       for the first station, the 0th for the 2nd and the 2nd for the 3rd.
       If you add these up, you com up with 2. If you look at 09, the
       positions add up to 4. 11 adds to 4 (assuming that a missing value
       has a velue of 3), and 12 adds to 8.

       for the following chart :

       09, 07, 06, 04, 08
       07, 10, 08, 09, 06
       12, 13, 04, 08, 07

       09 = 9 (assuming missing = 5)
       07 = 5
       06 = 11
       04 = 10
       08 = 9
       10 = 11
       12 = 10
       13 = 10
       which means that 07 is the big winner and is the quiet day.

       So, the logic implies that each value is searched out and the total
       index is added. The lowest total wins, and the indices should
       be saved for later use. */

    maxnqt = 0;

    for (i=0; i<nquiet; i++) {
      if (nqt[i]/10 > 30) nqt[i] = 30;
      else nqt[i] = nqt[i]/10;
      if (nqt[i] > maxnqt) maxnqt = nqt[i]; }

    indices = calloc(sizeof(int),nquiet);
    indsave = calloc(sizeof(int),nquiet);

    indsave[0] = 0;

    if (nhours <= 24) {
      found = 1; }
    else found = 0;
    j = 0;

    while (!found) {
      i = 0;
      while ((!found) && (i < nquiet)) {
	for (m=0; m<nquiet; m++) indices[m] = nqt[m];
	indices[i] = j;
	index = (long) i * nhours + j;
	val = qorder[index];
	k = 0;
	while (k < nquiet) {
	  if (i==k) {
	    k++; }
	  if (k < nquiet) {
	    sfound = 0;
	    l = 0;
	    while ((!sfound) && (l<nqt[i])) {
	      index = (long) k * nhours + l;
	      if (qorder[index] == val) {
		indices[k]=l;
		sfound = 1; }
	      else {
		l++; } } }
	  k++; }
	tot = 0;
	for (k=0; k<nquiet; k++) {
	  tot = tot + indices[k]; }
	if ((i==0) && (j==0)) {
	  oldtot = tot;
	  for (k=0; k<nquiet; k++) indsave[k] = indices[k]; }
	else {
	  if (tot < oldtot) {
	    for (k=0; k<nquiet; k++) indsave[k] = indices[k];
	    oldtot = tot; } }
	if (oldtot <= j) { found = 1; }
	i++; }
      
      if ((j == maxnqt-1) && (!found)) found = 1;
      else j++; }

    /* Now that indsave is full of the lowest added up total, the index
       has to be found (non-missing index, that is) */

    for (i=0;i<nquiet;i++) {
      printf("indsave[%d] : %d\n",i,indsave[i]); }

    k = 0;
    i = -1;

    if (maxnqt > 0) {
      while ((k < nquiet) && (i == -1)) {
	if (indsave[k] < nqt[k]) i = k;
	k++; } }
    else {
      i = 0; }

    /* if no non-missing index is found, then just use the first index,
       since the whole thing is pretty hopeless... */

    if (i == -1) {
      indsave[0] = 0;
      i = 0; }

    /* convert index to ut time */

    if ((i == 0) && (indsave[i] == 0) && (qorder[0] == -1)) {
      newut[0] = -1.0; }
    else {
      index = (long) i * nhours + indsave[i];
      newut[0] = (double) (qorder[index] + shour)*3600.0; }

    free(lat);
    free(lon);
    free(begtimes);
    free(endtimes);
    free(dbdt);
    free(qorder);
    free(nqt);
    free(indices);
    free(indsave);
    free(qdorder);
    free(order); }

  else { newut[0] = -1.0; }

  return newut[0]; }

