pro fitsurf,basepath

;  modified from the old fitsurf program for recent 2010 eclipse
;  season flats, and modern processing

;  procedure to fit surface to residual crosstalk as a 
;  function of slit scan position, spectrum, slit length

;  fits surface in focal plane of CCD with linear functions in
;  X,Y.  Does this for each of the measured slit scan positions
;  Smooths the variations of the fit parameters with a running
;  boxcar using the IDL smooth proceedure

;  INPUT:	
;	basepath	= pathname to level1 data calibrated without
;					the residual crosstalk correction
;;  OUTPUT:	scoef	 = array of coefficients(3 Stokes,ndeg,ndeg,nfiles)

;  This routine avoids the locations around the lines where
;  the polarization might bias the fit

;  determines surface fit coefficients of Q/I, U/I, V/I
;  for the full array

;  get the list of input files
derf = file_search(basepath + '*.fits')
nftot = n_elements(derf)
print,'directory: ',basepath,'; number of files = ',nftot
pthnam = derf

;  output array containing slit positions of data
sltpos = fltarr(nftot)
xtalk = fltarr(nftot,3)
xtalk100 = xtalk & xtalk500 = xtalk & xtalk900 = xtalk

;ndeg = 3	;  degree of polynomial fit
ndeg = 1	;  degree of polynomial fit
 
;  start loop over files
for kk = 0,nftot-1 do begin

;  read in the data, make sure overflow etc is compensated
readl1_sbsp,pthnam(kk),dat,hdr
temp = dat(*,*,0)
nx = sizeof(temp,1) & ny = sizeof(temp,2)
nxm1 = nx - 1

;  get the slit position of observation from the header
sltpos(kk) = sxpar(hdr,'SLITPOS')

if kk eq 0 then begin
	nofit = bytarr(nx,ny)
	nofit(*,*) = 1
        bstks = bytarr(nx*8,ny)
	xpx = dblarr(nx,ny) & ypx = dblarr(nx,ny)


;  output array of coefficients has size ndeg*1
;  for each of Q,U,V
	scoef = fltarr(ndeg+1,ndeg+1,3,nftot)
endif

;;  display raw data first
bstks(0:nxm1,*) = bytscl(dat(*,*,0))                 

;for istks = 1,3 do begin
;xstrt = istks*nx
;bstks(xstrt:xstrt+nxm1,*) = bytscl(dat(*,*,istks))
;endfor
;window,1,xs=nx*4,ys=ny
;tvscl,bstks
;stop


;  For Stokes I image, loop through slit positions locating the lines
;  ignore top row which is bad
for jj = 0,ny-2 do begin
	itemp = temp(*,jj)
	whr = where(itemp lt median(itemp))
	nofit(whr,jj) = 0
endfor
whrno = where(nofit ne 0,count) ;  locations where array is to be fit
xpx(*,*) = findgen(nx) # replicate(1., ny) ;X values at each point
ypx(*,*) = replicate(1.,nx) # findgen(ny) ; Y values at each point
datin = fltarr(3,count)
datin(0,*) = xpx(whrno)
datin(1,*) = ypx(whrno)


;stop


;  loop through Stokes QUV parameters
for istks = 1,3 do begin


;;  fit surface to Stokes Q,U, or V ignoring places where line
;  use ratio to Stokes I
temp = dat(*,*,istks)/dat(*,*,0) 
temp(*,ny-1) = temp(*,ny-2) ; kill bad top row
datin(2,*) = temp(whrno)

qfit = sfit(datin,ndeg,/irregular,kx=coef)
scoef(*,*,istks-1,kk) = coef

;  test the result
;  recover the fit
smth = fltarr(nx,ny)
smth(*,*) = 0.
for mj = 0,ndeg do for mi = 0,ndeg do begin
	smth = smth + $
	scoef(mj,mi,istks-1,kk) * xpx^mi * ypx^mj
endfor
;xtalk(kk,istks-1) = mean(smth(7:14,10:1000))
;  use red end of spectrum where there is more continuum
xtalk(kk,istks-1) = mean(smth(99:106,10:1000))
xtalk100(kk,istks-1) = mean(smth(99:106,50:150))
xtalk500(kk,istks-1) = mean(smth(99:106,450:550))
xtalk900(kk,istks-1) = mean(smth(99:106,850:950))


;tvwin,smth,title='smoothed variation over spectrum'
;dumm = ''
;read,' enter any character to continue: ',dumm

;  setup final result display
;  insert the raw data in the first 4 columns
xstrt = istks*nx
mxx = max(dat(*,*,istks)) & mnn = min(dat(*,*,istks))
if istks gt 0 then mxx = 100. & mnn = -100.
bstks(xstrt:xstrt+nxm1,*) = bytscl(dat(*,*,istks),max=mxx,min=mnn)
xstrt = nx*4 + istks*nx
bstks(xstrt:xstrt+nxm1,*) = $
	;bytscl(((dat(*,*,istks) -smth*dat(*,*,0))<100.)>(-100.))
	bytscl( (dat(*,*,istks) -smth*dat(*,*,0)),max=mxx,min=mnn)

;if kk eq 97 then stop

;  end loop over Stokes parameters
endfor
window,1,xs=nx*8,ys=ny
tvscl,bstks

;stop


;  end loop over files
endfor


;  sort the observations in terms of ascending slit position
isrt = sort(sltpos)
sltpos = sltpos(isrt)
scoef = scoef(*,*,*,isrt)



;  do boxcar averaging in the slit scan direction
;  optimal smoothing seems to be about 200 scan steps
;  determine smoothing parameter for the present data
nsmoothb = fix( 200.*nftot/(max(sltpos)-min(sltpos)) )
print,' boxcar smoothing parameter in measured slit position steps: ',nsmoothb
;  smooth the fit coefficients
for istks = 0,2 do begin
	for jj = 0,ndeg-1 do begin
		for ii = 0,ndeg-1 do begin
			temp = smooth(scoef(ii,jj,istks,*),nsmoothb,/edge_truncate)
			scoef(ii,jj,istks,*) = temp
		endfor
	endfor
endfor



;  output the results
save,filename='coef_xtalk.save',nftot,scoef,sltpos,xtalk,ndeg
;  temp save for checking results at other positions along slit
;save,filename='coef_xtalk.save',nftot,scoef,sltpos,xtalk,ndeg, $
;	xtalk100, xtalk500, xtalk900


return
end
