!
      module nc_module
!      
      use params_module,only: &
       nmlat_h,   & ! number of P,S1,R geomagnetic grid latitudes in one hemisphere
       nmlatS2_h, & ! number of S2 geomagnetic grid latitudes in one hemisphere
       nmlat_T1,  & ! total number of geomagnetic grid latitudes S1 points
       nmlat_T2,  & ! total number of geomagnetic grid latitudes S2 points
       nmlat_T3,  & ! total number of geomagnetic grid latitudes R points at lowest level
       nmlon,&
       nlat_qd,nlat_qd_h, &  !  number of quasi dipole latitudes, edge points j-0.5 and half of hemisphere
       nglon,nglat, &        ! geographic grid dimension
       glon,glat,   &        ! geographic grid
       ylatm,ylatm_s,ylonm,ylonm_s,nhgt_fix,hgt_fix,&
       nhgt_fix_r,hgt_fix_r,rtd,f107,ap,year,doy,ut,ctpoten,hpower, &
       J3lb, &               ! Jr at lb at lower boundary at r points lowest level [A/m2]
       ggjtop,nggjhgt, &     ! grid for dB output in height
       nggjlon,nggjlat,ggjlon,ggjclat,ggjhgt,dtr, &
       test_pot, test_loc_pot ! logical flags to decide which test potential is written out
       
      use qd_module,only: lat_qd_mp, & ! quasi latitude of midpoint of volume l (nlat_qd)
        lon_qd_mp, &      ! quasi longitude of midpoint of volume (nmlon)
	hgt_qd_ed         ! height of quasi dipole grid = r height level (nhgt_fix_r)
!      
      integer :: noid,   &	! id of output netcdf-file
        dim3_fldlne1(3), & 	! id of  defining 3dim-arrays Fieldaligned-longitude
        dim3_fldlne2(3), & 	! id of  defining 3dim-arrays Fieldaligned-longitude
        dim3_fldlne3(3), & 	! id of  defining 3dim-arrays Fieldaligned-longitude
        dim3_fldlnep(3), & 	! id of  defining 3dim-arrays Fieldaligned-longitude
	dim3(3), &              ! id of  defining 3dim-arrays lon/lat/time for P points
	dim3_s1(3), &           ! id of  defining 3dim-arrays lon/lat/time for S1 points
	dim3_s2(3), &           ! id of  defining 3dim-arrays lon/lat/time for S2 points
	dim3_r3qd(3),&          ! id of  dL15efining 3dim-arrays lon/lat/time for R points at lowest level
	dim3ll_qd(3),&          ! id of  defining 3dim-arrays quasi dipole grid (lon,lat,time)
	dim3lh_qd(3),&          ! id of  defining 3dim-arrays quasi dipole grid (lat,hgt,time)
	dim4_qd(4),&            ! id of  defining 4dim-arrays quasi dipole grid (lon,lat,height,time)
	dim3_g(3),&             ! id of  defining 3dim-arrays geographic grid (lon,lat,time)
	dim3_gh(3),&            ! id of  defining 3dim-arrays geographic grid (lat,hgt,time)
	dim4_gh(4),&            ! id of  defining 3dim-arrays geographic grid (lon,lat,hgt,time)
	dim4_sph(4),&           ! id of  defining 4d array on sphere (lat,lon,hgt,time - mid level height)
	dim4_Tsph(4)            ! id of  defining 4d array on sphere (lat,lon,hgt,time - top level height)
      
      integer :: count3_fldlne1(3),&    ! only for read in 4D fields defined in readin.F   
        count3_fldlne2(3),count3_fldlne3(3),start3(3),start4(4), &
        npts1_total,npts2_total,npts3_total,nptsp_total,count3_fldlnep(3), &
	count3(3),count3_s2(3),count3_rqd(3),count3_g(3),count3_gh(3),     &
	count3ll_qd(3),count3lh_qd(3),count4_qd(4),count4_gh(4),count4_sph(4)
!
      logical, parameter:: out_hwm = .true., &
        	out_cond = .true., &
        	out_nm   = .true., &
        	out_jd   = .true., &
                output_max= .true.
!          
      character(len=*),parameter ::  nc_path =  &   
!        '/glade/campaign/hao/itmodel/maute/projects/egbert_LWS_GIC/strom_simulations/2017_sep_tiegcm1.25_amie/dB_external_woJpg_woHL_54lev_hResSmo_Dyn_tiegcm1.25_amie_s_sep2017_55_84.nc'
!        '/glade/derecho/scratch/maute/temp/3Dyn_2hemis/dB_test_fac.nc'
!        '/glade/derecho/scratch/maute/temp/3Dyn_2hemis/dB_testMay_fac_h0_yt45.nc'
!        '/glade/derecho/scratch/maute/temp/dB_out/dB_glbDyn_jt45_b1000_modQdMap0127.nc'
!        '/glade/derecho/scratch/maute/temp/dB_out/dB_rmhalf_grid.nc'
        '/glade/derecho/scratch/maute/temp/dB_out/dB_test_bij1e6.nc'
!        
      contains
!--------------------------------------------------------------------------
      subroutine nc_create
! 
      use fieldline_s_module,only: fieldline_s1,fline_s1, &
         fieldline_s2,fline_s2
      use fieldline_r_module,only: &
         fieldline_r,fline_r
      use fieldline_p_module,only: &
         fieldline_p,fline_p
!      
      implicit none
      
       
#include <netcdf.inc>
!
      integer :: isn,istat,idtime,idlon1,idlon2,idlat1,idlat2,&
        idlat3qd, &
        idhgt,idhgt_r,idnmtime,&
        idfldpts_qdlat1,idfldpts1, idfldpts_qdlat2,idfldpts2,&
	idfldpts_qdlat3,idfldpts_qdlatp,idfldpts3,idfldptsp,&
	idfldpts_hgt1,idfldpts_hgt2,&
	idfldpts_hgt3,idfldpts_hgtp,itime,ilon1,ilon2,ilat1,ilat2,ilat3qd,&
	imtime,iday,ihgt,ihgt_r,ifldpts,ifldpts_qdlat1,ifldpts_hgt1,&
	ifldpts_qdlat2,ifldpts_hgt2,&
	ifldpts_qdlat3,ifldpts_hgt3,id,&
	ifldpts_qdlatp,ifldpts_hgtp, &
	idlon_qd,idlat_qd,ilon_qd,ilat_qd,&
	idlon_g,idlat_g,idhgt_g,ilateq,idhgt_gB,&
	ilon_g,ilat_g,ihgt_g,ihgt_gB, &
	idglon_sph,idglat_sph,idhgtTop_sph, &
	idhgt_sph, &
	iglon_sph,iglat_sph,ihgtTop_sph, &
	ihgt_sph
      integer :: iloop_start,iloop_end,idiff
      integer :: i1,i2,i3,i4,i5,i,j,k
      integer, parameter :: nmlat2 = nmlat_T2
      	
      real :: dlon,dlat	
      real :: ylatm2_deg(nmlat2),ylonm2_deg(nmlon), &
          ylatm1_deg(nmlat_T1),ylonm1_deg(nmlon), &
	  latqd_deg(nlat_qd-1)
      real, allocatable :: qdlat1_pts(:),hgt1_pts(:), &
        	qdlat2_pts(:),hgt2_pts(:), &
        	qdlat3_pts(:),hgt3_pts(:), &
        	qdlatp_pts(:),hgtp_pts(:)
      real :: qdlat3_lb(nmlat_T3)
      real :: ggjtop1(nggjhgt+1)
      real :: ggjlon_tmp(nggjlon),ggjclat_tmp(nggjlat)

! calculate number of total points npts_total on a longitudinal slice
! each longitude has the same amount of points
      npts1_total = 0
      npts2_total = 0
      npts3_total = 0
      nptsp_total = 0
      do isn = 1,2
        do j = 1,nmlat_h
           npts1_total =npts1_total + fline_s1(1,j,isn)%npts
           npts3_total =npts3_total + fline_r(1,j,isn)%npts
           nptsp_total =nptsp_total + fline_p(1,j,isn)%npts
        enddo
        do j = 1,nmlatS2_h
           npts2_total =npts2_total + fline_s2(1,j,isn)%npts
        enddo
!	
      enddo
!      
      allocate(qdlat1_pts(npts1_total))
      allocate(hgt1_pts(npts1_total))
      allocate(qdlat2_pts(npts2_total))
      allocate(hgt2_pts(npts2_total))
      allocate(qdlat3_pts(npts3_total))
      allocate(hgt3_pts(npts3_total))
      allocate(qdlatp_pts(nptsp_total))
      allocate(hgtp_pts(nptsp_total))
      
      i1=0
      i2=0
      i3=0
      i4=0
      i5=0
      do isn = 1,2
        if(isn.eq.1) then
          iloop_start = 1
	  iloop_end   = nmlat_h
	  idiff = 1
	elseif(isn.eq.2) then
          iloop_start = nmlat_h
	  iloop_end   = 1
	  idiff = -1
	endif
        do j=iloop_start,iloop_end,idiff
          do k=1,fline_s1(1,j,isn)%npts   ! longitudinal index 1 since all long. are the same
             i1 = i1 +1
	     qdlat1_pts(i1)=fline_s1(1,j,isn)%mlat_qd(k)*rtd    ! get quasi dipole latitude
	     hgt1_pts(i1)  =fline_s1(1,j,isn)%hgt_pt(k)*1.e-3   ! height convert from [m] to [km]
	  enddo
          do k=1,fline_r(1,j,isn)%npts   ! longitudinal index 1 since all long. are the same
             i3 = i3 +1
	     qdlat3_pts(i3)=fline_r(1,j,isn)%mlat_qd(k)*rtd    ! get quasi dipole latitude
	     hgt3_pts(i3)  =fline_r(1,j,isn)%hgt_pt(k)*1.e-3   ! height convert from [m] to [km]
	  enddo
          do k=1,fline_p(1,j,isn)%npts   ! longitudinal index 1 since all long. are the same
             i4 = i4 +1
	     qdlatp_pts(i4)=fline_p(1,j,isn)%mlat_qd(k)*rtd    ! get quasi dipole latitude
	     hgtp_pts(i4)  =fline_p(1,j,isn)%hgt_pt(k)*1.e-3   ! height convert from [m] to [km]
	  enddo
          i5 = i5 +1
	  qdlat3_lb(i5)=fline_r(1,j,isn)%mlat_qd(1)*rtd    ! get quasi dipole latitude
	enddo
!	
        if(isn.eq.1) then
          iloop_start = 1
	  iloop_end   = nmlatS2_h
	  idiff = 1
	elseif(isn.eq.2) then
          iloop_start = nmlatS2_h
	  iloop_end   = 1
	  idiff = -1
	endif
        do j=iloop_start,iloop_end,idiff
          do k=1,fline_s2(1,j,isn)%npts   ! longitudinal index 1 since all long. are the same
             i2 = i2 +1
	     qdlat2_pts(i2)=fline_s2(1,j,isn)%mlat_qd(k)*rtd    ! get quasi dipole latitude
	     hgt2_pts(i2)  =fline_s2(1,j,isn)%hgt_pt(k)*1.e-3   ! height convert from [m] to [km]
	  enddo
	enddo
	
      enddo ! end of hemispheres
!
      count3_fldlne1(1:3)= (/nmlon,npts1_total,1/)
      count3_fldlne2(1:3)= (/nmlon,npts2_total,1/)
      count3_fldlne3(1:3)= (/nmlon,npts3_total,1/)
      count3_fldlnep(1:3)= (/nmlon,nptsp_total,1/)
      count3(1:3)        = (/nmlon,nmlat_T1,1/)
      count3_s2(1:3)     = (/nmlon,nmlat_T2,1/)
      count3_rqd(1:3)    = (/nmlon,nmlat_T3,1/)
      count3_g(1:3)      = (/nglon,nglat,1/)
      count3_gh(1:3)     = (/nglat,nggjhgt+1,1/)
      count4_gh(1:4)     = (/nglon,nglat,nggjhgt+1,1/)
      count3ll_qd(1:3)   = (/nmlon,nlat_qd-1,1/)
      count3lh_qd(1:3)   = (/nlat_qd-1,nhgt_fix,1/)
      count4_qd(1:4)     = (/nmlon,nlat_qd-1,nhgt_fix,1/)
      count4_sph(1:4)    = (/nggjlat,nggjlon,nggjhgt,1/)
      start3(1:2)    = 1 
      start4(1:3)    = 1 
! 
! create output file  
      istat = nf_create(nc_path,NF_CLOBBER,noid) 
      if (istat /= NF_NOERR) call check_err(istat,'create nc-file ')   
      write(6,*) 'output nc-file created:',nc_path

! define dimensions
      istat = nf_def_dim(noid,'time',NF_UNLIMITED,idtime)
      if (istat /= NF_NOERR) call check_err(istat,'defdim time ')

      istat = nf_def_dim(noid,'mlon1',nmlon,idlon1)
      if (istat /= NF_NOERR) call check_err(istat,'defdim mlon1')

      istat = nf_def_dim(noid,'mlon2',nmlon,idlon2)
      if (istat /= NF_NOERR) call check_err(istat,'defdim mlon2')

      istat = nf_def_dim(noid,'mlat1',nmlat_T1,idlat1)
      if (istat /= NF_NOERR) call check_err(istat,'defdim mlat1')
 
      istat = nf_def_dim(noid,'mlat2',nmlat2,idlat2)
      if (istat /= NF_NOERR) call check_err(istat,'defdim mlat2')
 
      istat = nf_def_dim(noid,'mlat3qd',nmlat_T3,idlat3qd)
      if (istat /= NF_NOERR) call check_err(istat,'defdim mlat3qd')
      
      istat = nf_def_dim(noid,'hgt',nhgt_fix,idhgt)
      if (istat /= NF_NOERR) call check_err(istat,'defdim hgt')    
      
      istat = nf_def_dim(noid,'hgt_r',nhgt_fix_r,idhgt_r)
      if (istat /= NF_NOERR) call check_err(istat,'defdim hgt_r') 

      istat = nf_def_dim(noid,'lon_qd',nmlon,idlon_qd)
      if (istat /= NF_NOERR) call check_err(istat,'defdim lonqd')   

      istat = nf_def_dim(noid,'lat_qd',nlat_qd-1,idlat_qd)
      if (istat /= NF_NOERR) call check_err(istat,'defdim latqd') 

      istat = nf_def_dim(noid,'glon',nglon,idlon_g)
      if (istat /= NF_NOERR) call check_err(istat,'defdim glon')   

      istat = nf_def_dim(noid,'glat',nglat,idlat_g)
      if (istat /= NF_NOERR) call check_err(istat,'defdim glat')

      istat = nf_def_dim(noid,'ghgt',nhgt_fix_r,idhgt_g)
      if (istat /= NF_NOERR) call check_err(istat,'defdim ghgt')   

      istat = nf_def_dim(noid,'ghgtB',(nggjhgt+1),idhgt_gB)
      if (istat /= NF_NOERR) call check_err(istat,'defdim ghgtB')     
      
      istat = nf_def_dim(noid,'fldpts_qdlat1',npts1_total,idfldpts_qdlat1)
      if (istat /= NF_NOERR) call check_err(istat,'defdim fldpts_qdlat1')  
      
      istat = nf_def_dim(noid,'fldpts_hgt1',npts1_total,idfldpts_hgt1)
      if (istat /= NF_NOERR) call check_err(istat,'defdim fldpts_hgt1')     
      
      istat = nf_def_dim(noid,'fldpts_qdlat2',npts2_total,idfldpts_qdlat2)
      if (istat /= NF_NOERR) call check_err(istat,'defdim fldpts_qdlat2')  
      
      istat = nf_def_dim(noid,'fldpts_hgt2',npts2_total,idfldpts_hgt2)
      if (istat /= NF_NOERR) call check_err(istat,'defdim fldpts_hgt2')       
      
      istat = nf_def_dim(noid,'fldpts_qdlat3',npts3_total,idfldpts_qdlat3)
      if (istat /= NF_NOERR) call check_err(istat,'defdim fldpts_qdlat3')  
      
      istat = nf_def_dim(noid,'fldpts_hgt3',npts3_total,idfldpts_hgt3)
      if (istat /= NF_NOERR) call check_err(istat,'defdim fldpts_hgt3')       
      
      istat = nf_def_dim(noid,'fldpts_qdlatp',nptsp_total,idfldpts_qdlatp)
      if (istat /= NF_NOERR) call check_err(istat,'defdim fldpts_qdlatp')  
      
      istat = nf_def_dim(noid,'fldpts_hgtp',nptsp_total,idfldpts_hgtp)
      if (istat /= NF_NOERR) call check_err(istat,'defdim fldpts_hgtp')  
      
      istat = nf_def_dim(noid,'glon_sph',nggjlon,idglon_sph)
      if (istat /= NF_NOERR) call check_err(istat,'defdim glon_sph') 
      istat = nf_def_dim(noid,'glat_sph',nggjlat,idglat_sph)
      if (istat /= NF_NOERR) call check_err(istat,'defdim glat_sph') 
      istat = nf_def_dim(noid,'hgtTop_sph',nggjhgt,idhgtTop_sph)
      if (istat /= NF_NOERR) call check_err(istat,'defdim hgtTop_sph')
      istat = nf_def_dim(noid,'hgt_sph',nggjhgt,idhgt_sph)
      if (istat /= NF_NOERR) call check_err(istat,'defdim hgt_sph')
      
!      istat = nf_def_dim(noid,'mtime',3,idnmtime)
!      if (istat /= NF_NOERR) call check_err(istat,'defdim mtime ')

! ids of dim arrays  
      dim3_fldlne1(1) = idlon1
      dim3_fldlne1(2) = idfldpts_qdlat1  ! this should not matter since idfldpts_hgt is needed too
      dim3_fldlne1(3) = idtime
      dim3_fldlne2(1) = idlon2
      dim3_fldlne2(2) = idfldpts_qdlat2  ! this should not matter since idfldpts_hgt is needed too
      dim3_fldlne2(3) = idtime
      dim3_fldlne3(1) = idlon2
      dim3_fldlne3(2) = idfldpts_qdlat3  ! this should not matter since idfldpts_hgt is needed too
      dim3_fldlne3(3) = idtime
      dim3_fldlnep(1) = idlon1
      dim3_fldlnep(2) = idfldpts_qdlatp  ! this should not matter since idfldpts_hgt is needed too
      dim3_fldlnep(3) = idtime
      dim3(1) = idlon2  ! 2024.10 should be mlon2, since offset with S1 points
      dim3(2) = idlat1
      dim3(3) = idtime
      dim3_s1(1) = idlon1  
      dim3_s1(2) = idlat1
      dim3_s1(3) = idtime
      dim3_s2(1) = idlon2
      dim3_s2(2) = idlat2
      dim3_s2(3) = idtime
      dim3_r3qd(1) = idlon2
      dim3_r3qd(2) = idlat3qd
      dim3_r3qd(3) = idtime
      dim3ll_qd(1) = idlon_qd
      dim3ll_qd(2) = idlat_qd
      dim3ll_qd(3) = idtime
      dim3lh_qd(1) = idlat_qd
      dim3lh_qd(2) = idhgt
      dim3lh_qd(3) = idtime
      dim4_qd(1) = idlon_qd
      dim4_qd(2) = idlat_qd
      dim4_qd(3) = idhgt
      dim4_qd(4) = idtime
      dim3_g(1)  = idlon_g
      dim3_g(2)  = idlat_g
      dim3_g(3)  = idtime
      dim3_gh(1) = idlat_g
      dim3_gh(2) = idhgt_gB
      dim3_gh(3) = idtime
      dim4_gh(1) = idlon_g
      dim4_gh(2) = idlat_g
      dim4_gh(3) = idhgt_gB
      dim4_gh(4) = idtime
      dim4_sph(1) = idglat_sph
      dim4_sph(2) = idglon_sph
      dim4_sph(3) = idhgt_sph
      dim4_sph(4) = idtime
      dim4_Tsph(1) = idglat_sph
      dim4_Tsph(2) = idglon_sph
      dim4_Tsph(3) = idhgtTop_sph
      dim4_Tsph(4) = idtime

! define variables      
      istat = nf_def_var(noid,'time',NF_DOUBLE,1,idtime,itime)
      if (istat /= NF_NOERR) call check_err(istat,'defvar time ')
      
      istat = nf_def_var(noid,'mlon1',NF_DOUBLE,1,idlon1,ilon1)
      if (istat /= NF_NOERR) call check_err(istat,'defvar mlon1')
      
      istat = nf_def_var(noid,'mlon2',NF_DOUBLE,1,idlon2,ilon2)
      if (istat /= NF_NOERR) call check_err(istat,'defvar mlon2')
      
      istat = nf_def_var(noid,'lon_qd',NF_DOUBLE,1,idlon_qd,ilon_qd)
      if (istat /= NF_NOERR) call check_err(istat,'defvar lon_qd')

      istat = nf_def_var(noid,'mlat1',NF_DOUBLE,1,idlat1,ilat1)
      if (istat /= NF_NOERR) call check_err(istat,'defvar mlat1')

      istat = nf_def_var(noid,'mlat2',NF_DOUBLE,1,idlat2,ilat2)
      if (istat /= NF_NOERR) call check_err(istat,'defvar mlat2')
      
      istat = nf_def_var(noid,'lat_qd',NF_DOUBLE,1,idlat_qd,ilat_qd)
      if (istat /= NF_NOERR) call check_err(istat,'defvar lat_qd')

      istat = nf_def_var(noid,'mlat3qd',NF_DOUBLE,1,idlat3qd,ilat3qd)
      if (istat /= NF_NOERR) call check_err(istat,'defvar mlat3qd')

      istat = nf_def_var(noid,'hgt',NF_DOUBLE,1,idhgt,ihgt)
      if (istat /= NF_NOERR) call check_err(istat,'defvar hgt')

      istat = nf_def_var(noid,'hgt_r',NF_DOUBLE,1,idhgt_r,ihgt_r)
      if (istat /= NF_NOERR) call check_err(istat,'defvar hgt_r')

      istat = nf_def_var(noid,'fldpts_qdlat1',NF_DOUBLE,1,idfldpts_qdlat1,ifldpts_qdlat1)
      if (istat /= NF_NOERR) call check_err(istat,'defvar fldpts_qdlat1')

      istat = nf_def_var(noid,'fldpts_hgt1',NF_DOUBLE,1,idfldpts_hgt1,ifldpts_hgt1)
      if (istat /= NF_NOERR) call check_err(istat,'defvar fldpts_hgt1')

      istat = nf_def_var(noid,'fldpts_qdlat2',NF_DOUBLE,1,idfldpts_qdlat2,ifldpts_qdlat2)
      if (istat /= NF_NOERR) call check_err(istat,'defvar fldpts_qdlat2')

      istat = nf_def_var(noid,'fldpts_hgt2',NF_DOUBLE,1,idfldpts_hgt2,ifldpts_hgt2)
      if (istat /= NF_NOERR) call check_err(istat,'defvar fldpts_hgt2')

      istat = nf_def_var(noid,'fldpts_qdlat3',NF_DOUBLE,1,idfldpts_qdlat3,ifldpts_qdlat3)
      if (istat /= NF_NOERR) call check_err(istat,'defvar fldpts_qdlat3')

      istat = nf_def_var(noid,'fldpts_hgt3',NF_DOUBLE,1,idfldpts_hgt3,ifldpts_hgt3)
      if (istat /= NF_NOERR) call check_err(istat,'defvar fldpts_hgt3')

      istat = nf_def_var(noid,'fldpts_qdlatp',NF_DOUBLE,1,idfldpts_qdlatp,ifldpts_qdlatp)
      if (istat /= NF_NOERR) call check_err(istat,'defvar fldpts_qdlatp')

      istat = nf_def_var(noid,'fldpts_hgtp',NF_DOUBLE,1,idfldpts_hgtp,ifldpts_hgtp)
      if (istat /= NF_NOERR) call check_err(istat,'defvar fldpts_hgtp')

      istat = nf_def_var(noid,'glon',NF_DOUBLE,1,idlon_g,ilon_g)
      if (istat /= NF_NOERR) call check_err(istat,'defvar glon')

      istat = nf_def_var(noid,'glat',NF_DOUBLE,1,idlat_g,ilat_g)
      if (istat /= NF_NOERR) call check_err(istat,'defvar glat')

      istat = nf_def_var(noid,'ghgt',NF_DOUBLE,1,idhgt_g,ihgt_g)
      if (istat /= NF_NOERR) call check_err(istat,'defvar ghgt')

      istat = nf_def_var(noid,'ghgtB',NF_DOUBLE,1,idhgt_gB,ihgt_gB)
      if (istat /= NF_NOERR) call check_err(istat,'defvar ghgtB')
      
      istat = nf_def_var(noid,'glon_sph',NF_DOUBLE,1,idglon_sph,iglon_sph)
      if (istat /= NF_NOERR) call check_err(istat,'defvar glon_sph')
      istat = nf_def_var(noid,'glat_sph',NF_DOUBLE,1,idglat_sph,iglat_sph)
      if (istat /= NF_NOERR) call check_err(istat,'defvar glat_sph')
      istat = nf_def_var(noid,'hgtTop_sph',NF_DOUBLE,1,idhgtTop_sph,ihgtTop_sph)
      if (istat /= NF_NOERR) call check_err(istat,'defvar hgtTop_sph')
      istat = nf_def_var(noid,'hgt_sph',NF_DOUBLE,1,idhgt_sph,ihgt_sph)
      if (istat /= NF_NOERR) call check_err(istat,'defvar hgt_sph')

      istat = nf_def_var(noid,'year',NF_DOUBLE,1,idtime,id)
      if (istat /= NF_NOERR) call check_err(istat,'defvar year')
      istat = nf_put_att_text(noid,id,'long_name',4,"year")
      if (istat /= NF_NOERR) call check_err(istat,'put att_year name')

      istat = nf_def_var(noid,'doy',NF_DOUBLE,1,idtime,id)
      if (istat /= NF_NOERR) call check_err(istat,'defvar doy')
      istat = nf_put_att_text(noid,id,'long_name',3,'doy')
      if (istat /= NF_NOERR) call check_err(istat,'put att_doy name')

      istat = nf_def_var(noid,'f107',NF_DOUBLE,1,idtime,id)
      if (istat /= NF_NOERR) call check_err(istat,'defvar f107')
      istat = nf_put_att_text(noid,id,'long_name',4,'f107')
      if (istat /= NF_NOERR) call check_err(istat,'put att_f107 name')

      istat = nf_def_var(noid,'ap',NF_DOUBLE,1,idtime,id)
      if (istat /= NF_NOERR) call check_err(istat,'defvar ap')
      istat = nf_put_att_text(noid,id,'long_name',2,'ap')
      if (istat /= NF_NOERR) call check_err(istat,'put att_ap name')

      istat = nf_def_var(noid,'ut',NF_DOUBLE,1,idtime,id)
      if (istat /= NF_NOERR) call check_err(istat,'defvar ut')
      istat = nf_put_att_text(noid,id,'long_name',2,'ut')
      if (istat /= NF_NOERR) call check_err(istat,'put att_ut name')
      istat = nf_put_att_text(noid,id,'units',5,'hours')
      if (istat /= NF_NOERR) call check_err(istat,'put att_ut units')
      
      istat = nf_def_var(noid,'ctpoten',NF_DOUBLE,1,idtime,id)
      if (istat /= NF_NOERR) call check_err(istat,'defvar ctpoten')
      istat = nf_put_att_text(noid,id,'long_name',4,'ctpoten')
      if (istat /= NF_NOERR) call check_err(istat,'put att_ctpoten name')

      istat = nf_def_var(noid,'hpower',NF_DOUBLE,1,idtime,id)
      if (istat /= NF_NOERR) call check_err(istat,'defvar hpower')
      istat = nf_put_att_text(noid,id,'long_name',4,'hpower')
      if (istat /= NF_NOERR) call check_err(istat,'put att_hpower name')


! end definition part      
      istat = nf_enddef(noid)
      if (istat /= NF_NOERR) call check_err(istat,'enddef ') 
!
! put latitude/longitude/height in new file
      ylatm1_deg(1:nmlat_h) = ylatm(1:nmlat_h,1)
      do j=1,nmlat_h-1
        ylatm1_deg(nmlat_h+j) = ylatm(nmlat_h-j,2)
      end do
      ylatm1_deg= ylatm1_deg*rtd
      !write(6,*) ' ylatm1_deg',ylatm1_deg
      
      ylatm2_deg(1:nmlatS2_h) = ylatm_s(1:nmlatS2_h,1)
      do j=1,nmlatS2_h
        ylatm2_deg(nmlatS2_h+j) = ylatm_s(nmlatS2_h-j+1,2)
      end do
      ylatm2_deg= ylatm2_deg*rtd
      !write(6,*) ' ylatm2_deg',ylatm2_deg
      
      istat = nf_put_var_double(noid,ilat1,ylatm1_deg)
      if (istat /= NF_NOERR) call check_err(istat,'putvar mlat1')
      
      istat = nf_put_var_double(noid,ilat2,ylatm2_deg)
      if (istat /= NF_NOERR) call check_err(istat,'putvar mlat2')
      
      istat = nf_put_var_double(noid,ilat3qd,qdlat3_lb)
      if (istat /= NF_NOERR) call check_err(istat,'putvar mlat3qd')
      
      ylonm2_deg= ylonm*rtd
      istat = nf_put_var_double(noid,ilon2,ylonm2_deg)
      if (istat /= NF_NOERR) call check_err(istat,'putvar mlon2')
      
      istat = nf_put_var_double(noid,ilon_qd,ylonm2_deg)
      if (istat /= NF_NOERR) call check_err(istat,'putvar lon_qd')
      
      ylonm1_deg= ylonm_s*rtd
      istat = nf_put_var_double(noid,ilon1,ylonm1_deg)
      if (istat /= NF_NOERR) call check_err(istat,'putvar mlon1')
      
      latqd_deg= lat_qd_mp*rtd
      istat = nf_put_var_double(noid,ilat_qd,latqd_deg)
      if (istat /= NF_NOERR) call check_err(istat,'putvar lon_qd')
      
      istat = nf_put_var_double(noid,ihgt,hgt_fix)
      if (istat /= NF_NOERR) call check_err(istat,'putvar hgt')
      
      istat = nf_put_var_double(noid,ihgt_r,hgt_fix_r)
      if (istat /= NF_NOERR) call check_err(istat,'putvar hgt_r')
      
      istat = nf_put_var_double(noid,ifldpts_hgt1,hgt1_pts)
      if (istat /= NF_NOERR) call check_err(istat,'putvar hgt_pts1')
      
      istat = nf_put_var_double(noid,ifldpts_qdlat1,qdlat1_pts)
      if (istat /= NF_NOERR) call check_err(istat,'putvar qdlat_pts1')
      
      istat = nf_put_var_double(noid,ifldpts_hgt2,hgt2_pts)
      if (istat /= NF_NOERR) call check_err(istat,'putvar hgt_pts2')
      
      istat = nf_put_var_double(noid,ifldpts_qdlat2,qdlat2_pts)
      if (istat /= NF_NOERR) call check_err(istat,'putvar qdlat_pts2')
      
      istat = nf_put_var_double(noid,ifldpts_hgt3,hgt3_pts)
      if (istat /= NF_NOERR) call check_err(istat,'putvar hgt_pts3')
      
      istat = nf_put_var_double(noid,ifldpts_qdlat3,qdlat3_pts)
      if (istat /= NF_NOERR) call check_err(istat,'putvar qdlat_pts3')
      
      istat = nf_put_var_double(noid,ifldpts_hgtp,hgtp_pts)
      if (istat /= NF_NOERR) call check_err(istat,'putvar hgt_ptsp')
      
      istat = nf_put_var_double(noid,ifldpts_qdlatp,qdlatp_pts)
      if (istat /= NF_NOERR) call check_err(istat,'putvar qdlat_ptsp')     
      
      istat = nf_put_var_double(noid,ilon_g,glon)
      if (istat /= NF_NOERR) call check_err(istat,'putvar glon')
      
      istat = nf_put_var_double(noid,ilat_g,glat)
      if (istat /= NF_NOERR) call check_err(istat,'putvar glat')
      
      istat = nf_put_var_double(noid,ihgt_g,hgt_fix_r)
      if (istat /= NF_NOERR) call check_err(istat,'putvar hgt_g')
      
      ggjlon_tmp   = ggjlon*rtd
      ggjclat_tmp = -ggjclat*rtd+90.
      istat = nf_put_var_double(noid,iglon_sph,ggjlon_tmp)
      if (istat /= NF_NOERR) call check_err(istat,'putvar glon_sph')
      istat = nf_put_var_double(noid,iglat_sph,ggjclat_tmp)
      if (istat /= NF_NOERR) call check_err(istat,'putvar glat_sph')
      istat = nf_put_var_double(noid,ihgt_sph,ggjhgt)
      if (istat /= NF_NOERR) call check_err(istat,'putvar hgt_sph')
      istat = nf_put_var_double(noid,ihgtTop_sph,ggjtop)
      if (istat /= NF_NOERR) call check_err(istat,'putvar hgtTop_sph')
      
      ggjtop1(2:nggjhgt+1) = ggjtop(1:nggjhgt)
      ggjtop1(1)           = hgt_fix_r(1)
      istat = nf_put_var_double(noid,ihgt_gB,ggjtop1)
      if (istat /= NF_NOERR) call check_err(istat,'putvar hgt_gB')
      
      call nc_close
      
      return
      end subroutine nc_create
!--------------------------------------------------------------------------
      subroutine nc_close
!      
      implicit none
       
#include <netcdf.inc>
      
      integer :: istat
! close the new created file
      istat = nf_close(noid)
      if (istat /= NF_NOERR) call check_err(istat,'closing new file ')
!      
      end subroutine nc_close
!--------------------------------------------------------------------------
      subroutine nc_output(istep_in,istart_in)
! 
      use fieldline_s_module,only: fieldline_s1,fline_s1, &
          fieldline_s2,fline_s2
      use fieldline_r_module,only: &
         fieldline_r,fline_r
      use fieldline_p_module,only: &
         fieldline_p,fline_p
      use delB_module,only: delbegrd, delbngrd ,delbugrd, &
	 delbeLEO,delbnLEO,delbuLEO, &
	 delbe,delbn,delbu,psi, &
	 qdlon_g,qdlat_g, &
	 delbegrd_qd, delbngrd_qd ,delbugrd_qd, &
	 delbeLEO_qd,delbnLEO_qd,delbuLEO_qd, &
	 delbe0ln_qd,delbn0ln_qd,delbu0ln_qd, &
	 delscllH_qd,psi_qd,delbscl,delbsclLEO
      use readtiegcm_module, only: poten_hl 
!       
      use qd_module,only: &
        Jf1,&	          ! Jf1(nmlon,nlat_qd_h-1,nhgt_fix,2)
        Jf2,&	          ! Jf2(nmlon,nlat_qd_h-1,nhgt_fix,2)
        Jr,&	          ! Jr(nmlon,nlat_qd_h-1,nhgt_fix,2)
        Jeej,&            ! Jeej(nmlon,nlat_qd_h-1,nhgt_fix,2)
        Jfac_qd,&         ! Jfac_qd(nmlon,nlat_qd_h-1,nhgt_fix,2)
        Je2J_qd,&         ! Je2J_qd(nmlon,nlat_qd_h-1,nhgt_fix,2)
        Je2J_qA,&         ! Je2J_qA(nmlon,nlat_qd_h-1,nhgt_fix,2)
        Je2J_qA1,&        ! Je2J_qA(nmlon,nlat_qd_h-1,nhgt_fix,2)
        Je2J_qA2,&        ! Je2J_qA(nmlon,nlat_qd_h-1,nhgt_fix,2)
        Jf1hor,&          ! Jf1hor(nmlon,nlat_qd_h-1,nhgt_fix,2)
        Jf2hor,&          ! Jf2hor(nmlon,nlat_qd_h-1,nhgt_fix,2) 
	Keast,Ksouth, &   ! Layer current densities in geographic eastward and northward directions
	Jrtopgg           ! Jrtopqd at top of layer   
!      
      implicit none
!             
#include <netcdf.inc>
!
      integer,intent(in) :: istep_in,istart_in
      integer   :: n1,n2,n3,n4,n5,i,isn,j,k,ier,id,istat
      integer   :: iloop_start,iloop_end,idiff,istep
      real :: time_act
      real,allocatable  :: &
         un_fld1(:,:),vn_fld1(:,:),     &
         un_fld2(:,:),vn_fld2(:,:),     &
         sigH_fld1(:,:),sigP_fld1(:,:), &
         sigH_fld2(:,:),sigP_fld2(:,:), &
         sinI_fld1(:,:),sinI_fld2(:,:), &
         N1p_fld1(:,:),N2p_fld2(:,:),   &
         N1h_fld1(:,:),N2h_fld2(:,:),   &
         M1_fld1(:,:),M2_fld2(:,:),M3_fld3(:,:),   &
         je1d_fld1(:,:),je2d_fld2(:,:),S_fldp(:,:), &
	 poten_2d(:,:),fac_2d(:,:),bij_2d(:,:),zigP1(:,:),zigP2(:,:), &
	 zigH1(:,:),zigH2(:,:),fac_mp(:,:),   &
	 ed1_S1(:,:),ed1_S2(:,:),ve1_S1(:,:), &
	 ed2_S1(:,:),ed2_S2(:,:),ve2_S1(:,:), &
         I1(:,:),I2(:,:),I3(:,:),   &
         I1_1(:,:),I1_2(:,:),I1_3(:,:),   &
         I2_1(:,:),I2_2(:,:),I2_3(:,:),   &
         Je1I(:,:),Je2I(:,:),Ne1(:,:),Tei1(:,:),   &
         Ne2(:,:),Tei2(:,:),   &
         ! I1hor(:,:),I2hor(:,:),Jr(:,:),JrR(:,:), &
         Jf1dyn_fld2(:,:),Jf2dyn_fld2(:,:), &
         Jf1ion2_fld2(:,:),Jf2ion2_fld2(:,:), &
	 I3lb_2d(:,:), &
         Jf1_tot(:,:,:),Jf2_tot(:,:,:),Jr_tot(:,:,:),Jeej_tot(:,:,:), &
	 Jfac_tot(:,:,:),Je2J_tot(:,:,:),Je2JA_tot(:,:,:),&
	 Jf1hor_tot(:,:,:),Jf2hor_tot(:,:,:),Je2JA1_tot(:,:,:),&
	 Je2JA2_tot(:,:,:),I2oM2_tot(:,:),poten_test(:,:),pot_hl(:,:)     
	 
      character :: fname*10,labl*56,units*12
!
      istep = istep_in-istart_in+1   ! set timestep to write out
!
! open file
      istat = nf_open(nc_path,NF_WRITE,noid)
      if (istat /= NF_NOERR) call check_err(istat,'opening output file ')
!
! put general variables on the file
      
! check if field is already defined & put variable in
      time_act = doy + ut/24.
      istat = nf_inq_varid(noid,'time',id)
      if (istat /= NF_NOERR) call check_err(istat,'get time id') 
      write(6,*) 'nclout',id,istep,time_act,noid
      istat = nf_put_vara_double(noid,id,istep,1,time_act)
      if (istat /= NF_NOERR) call check_err(istat,'put time on file')
      
      istat = nf_inq_varid(noid,'year',id)
      istat = nf_put_vara_double(noid,id,istep,1,year)
      if (istat /= NF_NOERR) call check_err(istat,'put year on file') 
      
      istat = nf_inq_varid(noid,'doy',id)
      istat = nf_put_vara_double(noid,id,istep,1,doy)
      if (istat /= NF_NOERR) call check_err(istat,'put doy on file')  
      
      istat = nf_inq_varid(noid,'ut',id)
      istat = nf_put_vara_double(noid,id,istep,1,ut)
      if (istat /= NF_NOERR) call check_err(istat,'put ut on file')  
      
      istat = nf_inq_varid(noid,'f107',id)
      if (istat /= NF_NOERR) call check_err(istat,'get_varid f107 failed')
      istat = nf_put_vara_double(noid,id,istep,1,f107)
      if (istat /= NF_NOERR) call check_err(istat,'put f107 on file')  
      
      istat = nf_inq_varid(noid,'ap',id)
      if (istat /= NF_NOERR) call check_err(istat,'get_varid ap failed')
      istat = nf_put_vara_double(noid,id,istep,1,ap)
      if (istat /= NF_NOERR) call check_err(istat,'put ap on file')
      
      istat = nf_inq_varid(noid,'ctpoten',id)
      if (istat /= NF_NOERR) call check_err(istat,'get_varid ctpoten failed')
      istat = nf_put_vara_double(noid,id,istep,1,ctpoten)
      if (istat /= NF_NOERR) call check_err(istat,'put ctpoten on file')  
      
      istat = nf_inq_varid(noid,'hpower',id)
      if (istat /= NF_NOERR) call check_err(istat,'get_varid hpower failed')
      istat = nf_put_vara_double(noid,id,istep,1,hpower)
      if (istat /= NF_NOERR) call check_err(istat,'put hpower on file')   
      
     
! allocate arrays
      if(out_hwm) then
        if (.not.allocated(un_fld1)) then
          allocate(un_fld1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array un_fld1'
        endif
        if (.not.allocated(vn_fld1)) then
          allocate(vn_fld1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array vn_fld1'
        endif
        if (.not.allocated(un_fld2)) then
          allocate(un_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array un_fld2'
        endif
        if (.not.allocated(vn_fld2)) then
          allocate(vn_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array vn_fld2'
        endif
      endif

      if(out_cond) then
        if (.not.allocated(sigH_fld1)) then
          allocate(sigH_fld1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array sigH_fld1'
        endif
        if (.not.allocated(sigP_fld1)) then
          allocate(sigP_fld1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array sigP_fld1'
        endif
        if (.not.allocated(sigH_fld2)) then
          allocate(sigH_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array sigH_fld2'
        endif
        if (.not.allocated(sigP_fld2)) then
          allocate(sigP_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array sigP_fld2'
        endif
        if (.not.allocated(sinI_fld1)) then
          allocate(sinI_fld1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array sinI_fld1'
        endif
        if (.not.allocated(sinI_fld2)) then
          allocate(sinI_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array sinI_fld2'
        endif
      endif
      if(out_nm) then
        if (.not.allocated(N1p_fld1)) then
          allocate(N1p_fld1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array N1p_fld1'
        endif
        if (.not.allocated(N1h_fld1)) then
          allocate(N1h_fld1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array N1h_fld1'
        endif
        if (.not.allocated(N2h_fld2)) then
          allocate(N2h_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array N2h_fld2'
        endif
        if (.not.allocated(N2p_fld2)) then
          allocate(N2p_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array N2p_fld2'
        endif
        if (.not.allocated(M1_fld1)) then
          allocate(M1_fld1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array M1_fld1'
        endif
        if (.not.allocated(M2_fld2)) then
          allocate(M2_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array M2_fld2'
        endif
        if (.not.allocated(M3_fld3)) then
          allocate(M3_fld3(nmlon,npts3_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array M3_fld3'
        endif
      endif
      if(out_jd) then
        if (.not.allocated(je1d_fld1)) then
          allocate(je1d_fld1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array je1d_fld1'
        endif
        if (.not.allocated(je2d_fld2)) then
          allocate(je2d_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array je2d_fld2'
        endif
        if (.not.allocated(Je1I)) then
          allocate(Je1I(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array Je1I'
        endif
        if (.not.allocated(Je2I)) then
          allocate(Je2I(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array Je2I'
        endif
        if (.not.allocated(Ne1)) then
          allocate(Ne1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array Ne1'
        endif
        if (.not.allocated(Tei1)) then
          allocate(Tei1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array Tei1'
        endif
        if (.not.allocated(Ne2)) then
          allocate(Ne2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array Ne2'
        endif
        if (.not.allocated(Tei2)) then
          allocate(Tei2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array Tei2'
        endif
        if (.not.allocated(S_fldp)) then
          allocate(S_fldp(nmlon,nptsp_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array S_fldp'
        endif
        if (.not.allocated(I1)) then
          allocate(I1(nmlon,npts1_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array I1'
          allocate(I1_1(nmlon,npts1_total),stat=ier)
          allocate(I1_2(nmlon,npts1_total),stat=ier)
          allocate(I1_3(nmlon,npts1_total),stat=ier)
        endif
        if (.not.allocated(I2)) then
          allocate(I2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array I2'
          allocate(I2_1(nmlon,npts2_total),stat=ier)
          allocate(I2_2(nmlon,npts2_total),stat=ier)
          allocate(I2_3(nmlon,npts2_total),stat=ier)
          allocate(I2oM2_tot(nmlon,npts2_total),stat=ier)
        endif
        if (.not.allocated(I3)) then
          allocate(I3(nmlon,npts3_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array I3'
        endif
        if (.not.allocated(Jf1dyn_fld2)) then
          allocate(Jf1dyn_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array Jf1dyn_fld2'
        endif
        if (.not.allocated(Jf2dyn_fld2)) then
          allocate(Jf2dyn_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array Jf2dyn_fld2'
        endif
        if (.not.allocated(Jf1ion2_fld2)) then
          allocate(Jf1ion2_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array Jf1ion2_fld2'
        endif
        if (.not.allocated(Jf2ion2_fld2)) then
          allocate(Jf2ion2_fld2(nmlon,npts2_total),stat=ier)
          if (ier /= 0) write(6,*) 'error allocating array Jf2ion2_fld2'
        endif
        ! if (.not.allocated(JrR)) then
        !   allocate(JrR(nmlon,npts3_total),stat=ier)
        !   if (ier /= 0) write(6,*) 'error allocating array JrR'
        ! endif
        ! if (.not.allocated(I1hor)) then
        !   allocate(I1hor(nmlon,nptsp_total),stat=ier)
        !   if (ier /= 0) write(6,*) 'error allocating array I1hor'
        ! endif
        ! if (.not.allocated(I2hor)) then
        !   allocate(I2hor(nmlon,nptsp_total),stat=ier)
        !   if (ier /= 0) write(6,*) 'error allocating array I2hor'
        ! endif
        ! if (.not.allocated(Jr)) then
        !   allocate(Jr(nmlon,nptsp_total),stat=ier)
        !   if (ier /= 0) write(6,*) 'error allocating array Jr'
        ! endif
      endif
      allocate(poten_2d(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array poten_2d'
      allocate(poten_test(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array poten_test'
      allocate(fac_2d(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array fac_2d'
      allocate(fac_mp(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array fac_mp'
      allocate(pot_hl(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array pot_hl'
      allocate(bij_2d(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array bij_2d'
      allocate(zigP1(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array zigP1'
      allocate(zigP2(nmlon,nmlat_T2),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array zigP2'
      allocate(zigH1(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array zigH1'
      allocate(zigH2(nmlon,nmlat_T2),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array zigH2'
      allocate(ed1_S1(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array ed1_S1'
      allocate(ed2_S1(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array ed2_S1'
      allocate(ve1_S1(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array ve1_S1'
      allocate(ve2_S1(nmlon,nmlat_T1),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array ve2_S1'
      allocate(ed1_S2(nmlon,nmlat_T2),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array ed1_S2'
      allocate(ed2_S2(nmlon,nmlat_T2),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array ed2_S2'
      allocate(I3lb_2d(nmlon,nmlat_T3),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array I3lb_2d'
      allocate(Jf1_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Jf1_tot'
      allocate(Jf2_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Jf2_tot'
      allocate(Jr_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Jr_tot'
      allocate(Jeej_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Jeej_tot'
      allocate(Jfac_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Jfac_tot'
      allocate(Je2J_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Je2J_tot'
      allocate(Je2JA_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Je2JA_tot'
      allocate(Je2JA1_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Je2JA1_tot'
      allocate(Je2JA2_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Je2JA2_tot'
      allocate(Jf1hor_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Jf1hor_tot'
      allocate(Jf2hor_tot(nmlon,nlat_qd-1,nhgt_fix),stat=ier)
      if (ier /= 0) write(6,*) 'error allocating array Jf2hor_tot'
!      
! copy the hemispheric array to whole hemisphere
! for quasi dipole grid 
      ! southern hemisphere
      isn =1
      Jf1_tot(:,1:nlat_qd_h-1,:)   = Jf1(:,1:nlat_qd_h-1,:,isn)
      Jf2_tot(:,1:nlat_qd_h-1,:)   = Jf2(:,1:nlat_qd_h-1,:,isn)
      Jr_tot(:,1:nlat_qd_h-1,:)    = Jr(:,1:nlat_qd_h-1,:,isn)
      Jeej_tot(:,1:nlat_qd_h-1,:)  = Jeej(:,1:nlat_qd_h-1,:,isn)
      Jfac_tot(:,1:nlat_qd_h-1,:)  = Jfac_qd(:,1:nlat_qd_h-1,:,isn)
      Je2J_tot(:,1:nlat_qd_h-1,:)  = Je2J_qd(:,1:nlat_qd_h-1,:,isn)
      Je2JA_tot(:,1:nlat_qd_h-1,:) = Je2J_qA(:,1:nlat_qd_h-1,:,isn)
      Je2JA1_tot(:,1:nlat_qd_h-1,:) = Je2J_qA1(:,1:nlat_qd_h-1,:,isn)
      Je2JA2_tot(:,1:nlat_qd_h-1,:) = Je2J_qA2(:,1:nlat_qd_h-1,:,isn)
      Jf1hor_tot(:,1:nlat_qd_h-1,:)= Jf1hor(:,1:nlat_qd_h-1,:,isn)
      Jf2hor_tot(:,1:nlat_qd_h-1,:)= Jf2hor(:,1:nlat_qd_h-1,:,isn)
      ! northern hemisphere
      isn = 2
      do j=1,nlat_qd_h-1  ! north pole to equator
          n1 = nlat_qd-1-j+1 ! equator to northpole
          Jf1_tot(:,n1,:)   = Jf1(:,j,:,isn)
          Jf2_tot(:,n1,:)   = Jf2(:,j,:,isn)
          Jr_tot(:,n1,:)    = Jr(:,j,:,isn)
          Jeej_tot(:,n1,:)  = Jeej(:,j,:,isn)
          Jfac_tot(:,n1,:)  = Jfac_qd(:,j,:,isn)
          Je2J_tot(:,n1,:)  = Je2J_qd(:,j,:,isn)
          Je2JA_tot(:,n1,:) = Je2J_qA(:,j,:,isn)
          Je2JA1_tot(:,n1,:) = Je2J_qA1(:,j,:,isn)
          Je2JA2_tot(:,n1,:) = Je2J_qA2(:,j,:,isn)
          Jf1hor_tot(:,n1,:)= Jf1hor(:,j,:,isn)
          Jf2hor_tot(:,n1,:)= Jf2hor(:,j,:,isn)
      end do
!   
! for fieldline grid   
      do i=1,nmlon
         n3 = 0
         n2 = 0
         n1 = 0
         n4 = 0
	 n5 = 0
         do isn = 1,2
           if(isn.eq.1) then
             iloop_start = 1
	     iloop_end   = nmlatS2_h
	     idiff = 1
	   elseif(isn.eq.2) then
             iloop_start = nmlatS2_h
	     iloop_end   = 1
	     idiff = -1
	   endif
           do j=iloop_start,iloop_end,idiff
             do k=1,fline_s2(i,j,isn)%npts
                n2 = n2 +1
		if(out_hwm) then
      	          un_fld2(i,n2)=fline_s2(i,j,isn)%un(k)  
      	          vn_fld2(i,n2)=fline_s2(i,j,isn)%vn(k)
		endif  
		if(out_cond) then
      	          sigH_fld2(i,n2)=fline_s2(i,j,isn)%sigH(k)  
      	          sigP_fld2(i,n2)=fline_s2(i,j,isn)%sigP(k)   
      	          sinI_fld2(i,n2)=fline_s2(i,j,isn)%sinI(k) 
		endif 
		if(out_nm) then
      	          N2p_fld2(i,n2)=fline_s2(i,j,isn)%N2p(k)
      	          N2h_fld2(i,n2)=fline_s2(i,j,isn)%N2h(k)
      	          M2_fld2(i,n2) =fline_s2(i,j,isn)%M2(k)  
		endif  
		if(out_jd) then
      	          je2d_fld2(i,n2)=fline_s2(i,j,isn)%Je2D(k)
      	          I2(i,n2)=fline_s2(i,j,isn)%I2(k)
      	          I2_1(i,n2)=fline_s2(i,j,isn)%I23d_1(k)
      	          I2_2(i,n2)=fline_s2(i,j,isn)%I23d_2(k)
      	          I2_3(i,n2)=fline_s2(i,j,isn)%I23d_3(k)
      	          I2oM2_tot(i,n2)=fline_s2(i,j,isn)%I2oM2(k)
      	          Je2I(i,n2)=fline_s2(i,j,isn)%Je2Ion(k)
      	          Ne2(i,n2) =fline_s2(i,j,isn)%Ne(k)
      	          Tei2(i,n2)=fline_s2(i,j,isn)%Tei(k)
      	          Jf1dyn_fld2(i,n2)=fline_s2(i,j,isn)%Jf1Dyn(k)
      	          Jf2dyn_fld2(i,n2)=fline_s2(i,j,isn)%Jf2Dyn(k)
      	          Jf1ion2_fld2(i,n2)=fline_s2(i,j,isn)%Jf1Ion2(k)
      	          Jf2ion2_fld2(i,n2)=fline_s2(i,j,isn)%Jf2Ion2(k)
		endif  
      	     enddo
	     n5 = j
	     if(idiff .eq.-1) n5 =nmlatS2_h+(nmlatS2_h-j+1) 
	     zigP2(i,n5) = fline_s2(i,j,isn)%zigP   
	     zigH2(i,n5) = fline_s2(i,j,isn)%zigH 
	     ed1_S2(i,n5) = fline_s2(i,j,isn)%ed1   
	     ed2_S2(i,n5) = fline_s2(i,j,isn)%ed2  
      	   enddo 
           if(isn.eq.1) then
             iloop_start = 1
	     iloop_end   = nmlat_h
	     idiff = 1
	   elseif(isn.eq.2) then
             iloop_start = nmlat_h
	     iloop_end   = 1
	     idiff = -1
	   endif 
           do j=iloop_start,iloop_end,idiff
             do k=1,fline_s1(i,j,isn)%npts
                n1 = n1 +1
		if(out_hwm) then
      	          un_fld1(i,n1)=fline_s1(i,j,isn)%un(k)  
      	          vn_fld1(i,n1)=fline_s1(i,j,isn)%vn(k)
		endif  
		if(out_cond) then  
      	          sigH_fld1(i,n1)=fline_s1(i,j,isn)%sigH(k)  
      	          sigP_fld1(i,n1)=fline_s1(i,j,isn)%sigP(k)  
      	          sinI_fld1(i,n1)=fline_s1(i,j,isn)%sinI(k)  
		endif 
		if(out_nm) then
      	          N1p_fld1(i,n1)=fline_s1(i,j,isn)%N1p(k)
      	          N1h_fld1(i,n1)=fline_s1(i,j,isn)%N1h(k)
      	          M1_fld1(i,n1) =fline_s1(i,j,isn)%M1(k)  
		endif
		if(out_jd) then
      	          je1d_fld1(i,n1)=fline_s1(i,j,isn)%Je1D(k)
      	          I1(i,n1)=fline_s1(i,j,isn)%I1(k)
      	          I1_1(i,n1)=fline_s1(i,j,isn)%I13d_1(k)
      	          I1_2(i,n1)=fline_s1(i,j,isn)%I13d_2(k)
      	          I1_3(i,n1)=fline_s1(i,j,isn)%I13d_3(k)
      	          Je1I(i,n1)=fline_s1(i,j,isn)%Je1Ion(k)
      	          Ne1(i,n1) =fline_s1(i,j,isn)%Ne(k)
      	          Tei1(i,n1)=fline_s1(i,j,isn)%Tei(k)
		endif    
      	      enddo
	     n5 = j
	     if(idiff .eq.-1) n5 =nmlat_h+(nmlat_h-j) 
	     zigP1(i,n5) = fline_s1(i,j,isn)%zigP   
	     zigH1(i,n5) = fline_s1(i,j,isn)%zigH   
	     ed1_S1(i,n5) = fline_s1(i,j,isn)%ed1   
	     ed2_S1(i,n5) = fline_s1(i,j,isn)%ed2   
	     ve1_S1(i,n5) = fline_s1(i,j,isn)%ve1   
	     ve2_S1(i,n5) = fline_s1(i,j,isn)%ve2  
             do k=1,fline_r(i,j,isn)%npts
                n3 = n3 +1
		if(out_nm) then
      	          M3_fld3(i,n3) =fline_r(i,j,isn)%M3(k)  
		endif 
		if(out_jd) then
		  I3(i,n3) =fline_r(i,j,isn)%I3(k) 
		  ! JrR(i,n3)=fline_r(i,j,isn)%Jr(k) 
		endif  
      	     enddo 
	     n5 = j
	     if(idiff .eq.-1) n5 =nmlat_h+(nmlat_h-j+1) 
	     I3lb_2d(i,n5) = J3lb(i,j,isn) 
             do k=1,fline_p(i,j,isn)%npts
                n4 = n4 +1
		if(out_jd) then
      	          S_fldp(i,n4)=fline_p(i,j,isn)%S(k)
      	          ! I1hor(i,n4)=fline_p(i,j,isn)%I1hor(k)
      	          ! I2hor(i,n4)=fline_p(i,j,isn)%I2hor(k)
      	          ! Jr(i,n4)=fline_p(i,j,isn)%Jr(k)
		endif  
      	     enddo
	    n5 = j
	    if(idiff .eq.-1) n5 =nmlat_h+(nmlat_h-j)
	    poten_2d(i,n5)  = fline_p(i,j,isn)%pot 
	    if(test_pot) then
	      poten_test(i,n5)= fline_p(i,j,isn)%pot_test 
	    elseif(test_loc_pot) then 
	      poten_test(i,n5)= fline_p(i,j,isn)% potTestLoc
	    endif
	    fac_2d(i,n5)    = fline_p(i,j,isn)%fac_hl 
	    pot_hl(i,n5)    = fline_p(i,j,isn)%pot_hl
	    bij_2d(i,n5)    = fline_p(i,j,isn)%bij  
	    fac_mp(i,n5)    = fline_p(i,j,isn)%fac_map
      	   enddo  ! end of latitude loop
	   
         enddo ! end of hemisphere loop
      enddo  ! end of longitude loop
      
      start3(3) = istep
      start4(4) = istep
      
      if(output_max) then  ! maximal output
      
      fname= 'Jf1'
      labl = 'Jf1'
      units = 'A/m2'
      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
          Jf1_tot,3,units,4)
	  
      fname= 'Jf2'
      labl = 'Jf2'
      units = 'A/m2'
      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
          Jf2_tot,3,units,4)
	  
      fname= 'Jr'
      labl = 'Jr'
      units = 'A/m2'
      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
          Jr_tot,3,units,4)
	  
!      fname= 'Jeej'
!      labl = 'Jeej'
!      units = 'A/m2'
!      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
!          Jeej_tot,6,units,4)
	  
      fname= 'Jfac'
      labl = 'Jfac'
      units = 'A/m2'
      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
          Jfac_tot,6,units,4)
	  
!      fname= 'Je2J'
!      labl = 'Je2J'
!      units = 'A/m2'
!      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
!          Je2J_tot,6,units,4)
      
      endif           
	  
!      fname= 'Je2JA'
!      labl = 'Je2JA'
!      units = 'A/m2'
!      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
!          Je2JA_tot,7,units,4)
	  
!      fname= 'Je2JA1'
!      labl = 'Je2JA1'
!      units = 'A/m2'
!      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
!          Je2JA1_tot,6,units,4)
	  
!      fname= 'Je2JA2'
!      labl = 'Je2JA2'
!      units = 'A/m2'
!      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
!          Je2JA2_tot,6,units,4)
	  
      fname= 'Jf1hor'
      labl = 'Jf1hor'
      units = 'A/m2'
      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
          Jf1hor_tot,6,units,4)
	  
      fname= 'Jf2hor'
      labl = 'Jf2hor'
      units = 'A/m2'
      call ncplot4d(noid,fname,labl,start4,count4_qd,dim4_qd, &
          Jf2hor_tot,3,units,4)
      
      if(out_hwm) then
        fname= 'un_s1'
        labl = 'un_s1'
        units = 'm/s'
!        write(6,*) 'start3',start3
!        write(6,*) 'count',count3_fldlne1
!        write(6,*) 'dim',dim3_fldlne1
        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
            un_fld1,5,units,3)
     	    
!        fname= 'un_s2'
!        labl = 'un_s2'
!        units = 'm/s'
!        write(6,*) 'start3',start3
!        write(6,*) 'count',count3_fldlne2
!        write(6,*) 'dim',dim3_fldlne2
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            un_fld2,5,units,3)
        
        fname = 'vn_s1'
        labl = 'vn_s1'
        units = 'm/s'
        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
            vn_fld1,5,units,3)
        
!        fname = 'vn_s2'
!        labl = 'vn_s2'
!        units = 'm/s'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            vn_fld2,5,units,3)
      
      endif  
      
      if(out_cond) then
        fname = 'sigH_s1'
        labl = 'sigH_s1'
        units = 'S/m'
        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
            sigH_fld1,7,units,3)
        
        fname = 'sigP_s1'
        labl = 'sigP_s1'
        units = 'S/m'
        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
            sigP_fld1,7,units,3)
        
!        fname = 'sigP_s2'
!        labl = 'sigP_s2'
!        units = 'S/m'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            sigP_fld2,7,units,3)
        
!        fname = 'sigH_s2'
!        labl = 'sigH_s2'
!        units = 'S/m'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            sigH_fld2,7,units,3)
        
        fname = 'sinI_s1'
        labl = 'sinI_s1'
        units = '[-]'
        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
            sinI_fld1,7,units,3)
        
        fname = 'sinI_s2'
        labl = 'sinI_s2'
        units = '[-]'
        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
            sinI_fld2,7,units,3)
      
      endif 
      
      if(out_nm) then 
        
        fname = 'N1p'
        labl = 'N1p'
        units = '?'
        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
            N1p_fld1,3,units,1)
        
        fname = 'N1h'
        labl = 'N1h'
        units = '?'
        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
            N1h_fld1,3,units,1)
        
        fname = 'M1'
        labl = 'M1'
        units = '?'
        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
            M1_fld1,2,units,1)
        
        fname = 'N2p'
        labl = 'N2p'
        units = '?'
        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
            N2p_fld2,3,units,1)
        
        fname = 'N2h'
        labl = 'N2h'
        units = '?'
        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
            N2h_fld2,3,units,1)
        
        fname = 'M2'
        labl = 'M2'
        units = '?'
        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
            M2_fld2,2,units,1)
        
        fname = 'M3'
        labl = 'M3'
        units = '?'
        call ncplot(noid,fname,labl,start3,count3_fldlne3,dim3_fldlne3, &
            M3_fld3,2,units,1)
      
      endif   
      
      if(out_jd) then 
        
 	fname = 'Je1D'
 	labl = 'Je1D'
 	units = '?'
 	call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
 	    je1d_fld1,4,units,1)
	   
	fname = 'Je2D'
	labl = 'Je2D'
	units = '?'
	call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
	    je2d_fld2,4,units,1) 
!        
!        fname = 'Je1Ion'
!        labl = 'Je1Ion'
!        units = 'A/m2'
!        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
!            Je1I,6,units,4)
!	    
!        fname = 'Ne1'
!        labl = 'Ne1'
!        units = '#/m3'
!        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
!            Ne1,3,units,4)
!        fname = 'Tei1'
!        labl = 'Tei1'
!        units = 'K'
!        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
!            Tei1,4,units,4)
!	    
!        fname = 'Ne2'
!        labl = 'Ne2'
!        units = '#/m3'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            Ne2,3,units,4)
!        fname = 'Tei2'
!        labl = 'Tei2'
!        units = 'K'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            Tei2,4,units,4)
!        
!	fname = 'Je2Ion'
!	labl = 'Je2Ion'
!	units = 'A/m2'
!	call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!	    Je2I,6,units,4)
!        
	fname = 'I1'
	labl = 'I1'
	units = 'A'
	call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
	    I1,2,units,1)
!        
!        fname = 'I1_1'
!        labl = 'I1_1'
!        units = 'A'
!        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
!            I1_1,4,units,1)
!        
!        fname = 'I1_2'
!        labl = 'I1_2'
!        units = 'A'
!        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
!            I1_2,4,units,1)
!        
!        fname = 'I1_3'
!        labl = 'I1_3'
!        units = 'A'
!        call ncplot(noid,fname,labl,start3,count3_fldlne1,dim3_fldlne1, &
!            I1_3,4,units,1)
!	    
	fname = 'I2'
	labl = 'I2'
	units = 'A'
	call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
	    I2,2,units,1)
!	    
!        fname = 'I2_1'
!        labl = 'I2_1'
!        units = 'A'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            I2_1,4,units,1)
!	    
!        fname = 'I2_2'
!        labl = 'I2_2'
!        units = 'A'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            I2_2,4,units,1)
!	    
!        fname = 'I2_3'
!        labl = 'I2_3'
!        units = 'A'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            I2_3,4,units,1)
!	    
!        fname = 'I2oM2'
!        labl = 'I2oM2'
!        units = 'A/m2'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            I2oM2_tot,5,units,4)
!	    
!        
	fname = 'I3'
	labl = 'I3'
	units = 'A'
	call ncplot(noid,fname,labl,start3,count3_fldlne3,dim3_fldlne3, &
	    I3,2,units,1)
!        
!        ! fname = 'JrR'
!        ! labl = 'JrR'
!        ! units = 'A/m2'
!        ! call ncplot(noid,fname,labl,start3,count3_fldlne3,dim3_fldlne3, &
!        !     JrR,3,units,4)
!	    
	 fname = 'S_RHS'
	 labl = 'S_RHS'
	 units = '?'
	 call ncplot(noid,fname,labl,start3,count3_fldlnep,dim3_fldlnep, &
	     S_fldp,5,units,1)
!	    
	fname = 'Jf1Dyn'
	labl = 'Jf1Dyn'
	units = 'A/m2'
	call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
	    jf1dyn_fld2,6,units,4) 
	fname = 'Jf2Dyn'
	labl = 'Jf2Dyn'
	units = 'A/m2'
	call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
	    jf2dyn_fld2,6,units,4)
	   
!        fname = 'Jf1Ion2'
!        labl = 'Jf1Ion2'
!        units = 'A/m2'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            jf1ion2_fld2,7,units,4) 
	    
!        fname = 'Jf2Ion2'
!        labl = 'Jf2Ion2'
!        units = 'A/m2'
!        call ncplot(noid,fname,labl,start3,count3_fldlne2,dim3_fldlne2, &
!            jf2ion2_fld2,7,units,4)
	    
        ! fname = 'I1hor'
        ! labl = 'I1hor'
        ! units = 'A'
        ! call ncplot(noid,fname,labl,start3,count3_fldlnep,dim3_fldlnep, &
        !     I1hor,5,units,1)
	    
        ! fname = 'I2hor'
        ! labl = 'I2hor'
        ! units = 'A'
        ! call ncplot(noid,fname,labl,start3,count3_fldlnep,dim3_fldlnep, &
        !     I2hor,5,units,1)
	    
        !  fname = 'Jr'
        !  labl = 'Jr'
        !  units = 'A/m2'
        !  call ncplot(noid,fname,labl,start3,count3_fldlnep,dim3_fldlnep, &
        !      Jr,5,units,4)
	    
      endif 
      
        fname = 'poten'
        labl = 'poten'
        units = 'V'
        call ncplot(noid,fname,labl,start3,count3,dim3, &
            poten_2d,5,units,1)
        
	if(test_pot) then
          fname = 'poten_test'
          labl = 'poten_test'   
          units = 'V'
          call ncplot(noid,fname,labl,start3,count3,dim3, &
            poten_test,10,units,1)
	elseif(test_loc_pot) then 
          fname = 'potloc_test'
          labl = 'potloc_test'   
          units = 'V'
          call ncplot(noid,fname,labl,start3,count3,dim3, &
            poten_test,11,units,1)
	endif  
      
       if(output_max) then
        fname = 'fac_dens'
        labl = 'fac_dens'
        units = 'A/m2'
        call ncplot(noid,fname,labl,start3,count3,dim3, &
             fac_2d,8,units,4)
        
        fname = 'fac_map'
        labl = 'fac_map'
        units = 'A/m2'
        call ncplot(noid,fname,labl,start3,count3,dim3, &
            fac_mp,7,units,4)

        fname = 'bij'
        labl = 'bij'
        units = '-'
        call ncplot(noid,fname,labl,start3,count3,dim3, &
            bij_2d,3,units,1)
      
	fname = 'ZigP1'
	labl = 'ZigP1'
	units = 'Sm'
	call ncplot(noid,fname,labl,start3,count3,dim3_s1, &
	    zigP1,5,units,1)
	   
	fname = 'ZigP2'
	labl = 'ZigP2'
	units = 'Sm'
	call ncplot(noid,fname,labl,start3,count3_s2,dim3_s2, &
	    zigP2,5,units,1)
      
	fname = 'ZigH1'
	labl = 'ZigH1'
	units = 'Sm'
	call ncplot(noid,fname,labl,start3,count3,dim3_s1, &
	    zigH1,5,units,1)
	   
	fname = 'ZigH2'
	labl = 'ZigH2'
	units = 'Sm'
	call ncplot(noid,fname,labl,start3,count3_s2,dim3_s2, &
	    zigH2,5,units,1)
!      
!        fname = 'J3lb'
!        labl = 'J3lb'
!        units = 'A/m2'
!        call ncplot(noid,fname,labl,start3,count3_rqd,dim3_r3qd, &
!            I3lb_2d,4,units,4)
      
        fname = 'Ed1_S1'
        labl = 'Ed1_S1'
        units = 'V/m'
        call ncplot(noid,fname,labl,start3,count3,dim3_s1, &
            ed1_S1,6,units,3)
      
        fname = 'Ed2_S1'
        labl = 'Ed2_S1'
        units = 'V/m'
        call ncplot(noid,fname,labl,start3,count3,dim3_s1, &
            ed2_S1,6,units,3)
      
        fname = 'Ve1_S1'
        labl = 'Ve1_S1'
        units = 'm/s'
        call ncplot(noid,fname,labl,start3,count3,dim3_s1, &
            ve1_S1,6,units,3)
      
        fname = 'Ve2_S1'
        labl = 'Ve2_S1'
        units = 'm/s'
        call ncplot(noid,fname,labl,start3,count3,dim3_s1, &
            ve2_S1,6,units,3)
      
	fname = 'poten_hl'
	labl = 'poten_hl'
	units = 'V'
	call ncplot(noid,fname,labl,start3,count3,dim3_s1, &
	    pot_hl,8,units,1)
      
        fname = 'Ed1_S2'
        labl = 'Ed1_S2'
        units = 'V/m'
        call ncplot(noid,fname,labl,start3,count3_s2,dim3_s2, &
            ed1_S2,6,units,3)
      
        fname = 'Ed2_S2'
        labl = 'Ed2_S2'
        units = 'V/m'
        call ncplot(noid,fname,labl,start3,count3_s2,dim3_s2, &
            ed2_S2,6,units,3)
            
      endif
      
        fname = 'Be_grd'
        labl = 'Be_grd'
        units = 'T'
        call ncplot(noid,fname,labl,start3,count3_g,dim3_g, &
            delbegrd,6,units,1)
        fname = 'Bn_grd'
        labl = 'Bn_grd'
        units = 'T'
        call ncplot(noid,fname,labl,start3,count3_g,dim3_g, &
            delbngrd,6,units,1)
        fname = 'Bu_grd'
        labl = 'Bu_grd'
        units = 'T'
        call ncplot(noid,fname,labl,start3,count3_g,dim3_g, &
            delbugrd,6,units,1)
      
      if(output_max) then
        fname = 'Be_LEO'
        labl = 'Be_LEO'
        units = 'T'
        call ncplot(noid,fname,labl,start3,count3_g,dim3_g, &
            delbeLEO,6,units,1)
        fname = 'Bn_LEO'
        labl = 'Bn_LEO'
        units = 'T'
        call ncplot(noid,fname,labl,start3,count3_g,dim3_g, &
            delbnLEO,6,units,1)
	    
        fname = 'Bu_LEO'
        labl = 'Bu_LEO'
        units = 'T'
        call ncplot(noid,fname,labl,start3,count3_g,dim3_g, &
            delbuLEO,6,units,1)
	    
        fname = 'Bscl_LEO'
        labl = 'Bscl_LEO'
        units = 'T'
        call ncplot(noid,fname,labl,start3,count3_g,dim3_g, &
            delbsclLEO,8,units,1)
      endif
         
!        fname = 'qdlon_g'
!        labl = 'qdlon_g'
!        units = 'deg'
!        call ncplot(noid,fname,labl,start3,count3_g,dim3_g, &
!            qdlon_g,7,units,3)
	    
!        fname = 'qdlat_g'
!        labl = 'qdlat_g'
!        units = 'deg'
!        call ncplot(noid,fname,labl,start3,count3_g,dim3_g, &
!            qdlat_g,7,units,3)
      
        fname = 'Be3D'
        labl = 'Be3D'
        units = 'T'
        call ncplot4d(noid,fname,labl,start4,count4_gh,dim4_gh, &
            delbe,4,units,1)
        fname = 'Bn3D'
        labl = 'Bn3D'
        units = 'T'
        call ncplot4d(noid,fname,labl,start4,count4_gh,dim4_gh, &
            delbn,4,units,1)
        fname = 'Bu3D'
        labl = 'Bu3D'
        units = 'T'
        call ncplot4d(noid,fname,labl,start4,count4_gh,dim4_gh, &
            delbu,4,units,1)
	    
        fname = 'Bscl'
        labl = 'Bscl'
        units = 'T'
        call ncplot4d(noid,fname,labl,start4,count4_gh,dim4_gh, &
            delbscl,8,units,1)
	    
        fname = 'Psi_geo'
        labl = 'Psi_geo'
        units = 'A'
        call ncplot(noid,fname,labl,start3,count3_g,dim3_g, &
            psi,7,units,1)
	    
        fname = 'Keast'
        labl = 'Keast'
        units = 'A/m'
        call ncplot4d(noid,fname,labl,start4,count4_sph,dim4_sph, &
            Keast,5,units,3)
	    
        fname = 'Ksouth'
        labl = 'Ksouth'
        units = 'A/m'
        call ncplot4d(noid,fname,labl,start4,count4_sph,dim4_sph, &
            Ksouth,6,units,3)
	    
        fname = 'Jrtop'
        labl = 'Jrtop'
        units = 'A/m2'
        call ncplot4d(noid,fname,labl,start4,count4_sph,dim4_Tsph, &
            Jrtopgg,5,units,4)
      
      call nc_close  
!      
!      return
      end subroutine nc_output
!--------------------------------------------------------------------------
      end module nc_module
!      
!--------------------------------------------------------------------------
      subroutine ncplot(noid,fname,labl,start3,count3,dim3, &
                       psi,nw,units,nw_u)

! nc-output: define plot variable & attributes

      implicit none
!     
#include <netcdf.inc>
      
      integer, intent(in) :: noid,start3(3),count3(3),nw
      integer, intent(in) :: dim3(3),nw_u
      real, intent(in) :: psi
      character, intent(in) :: fname*10,labl*56,units*12

      integer :: istat,id
      character :: msgerr*19

      
! check if field is already defined
      istat = nf_inq_varid(noid,fname,id)
      if (istat /= NF_NOERR) then
	
        istat = nf_redef(noid)
        if (istat /= NF_NOERR) call check_err(istat,'redef ')

        istat = nf_def_var(noid,fname,NF_DOUBLE,3,dim3,id)
        msgerr = 'defvar '//fname
        if (istat /= NF_NOERR) call check_err(istat,msgerr)

        istat = nf_put_att_text(noid,id,'long_name',nw,labl)
        msgerr = 'put att_'//fname//' name'
        if (istat /= NF_NOERR) call check_err(istat,msgerr)
	
        istat = nf_put_att_text(noid,id,'units',nw_u,units)
        msgerr = 'put att_'//fname//' units'
        if (istat /= NF_NOERR) call check_err(istat,msgerr)

        istat = nf_enddef(noid)
        if (istat /= NF_NOERR) call check_err(istat,'enddef ')
	 
      endif
      
! put values in new file
      msgerr = 'putvar '//fname
      istat = nf_put_vara_double(noid,id,start3,count3,psi)
      if (istat /= NF_NOERR) call check_err(istat,msgerr) 

      end subroutine ncplot
!      
!--------------------------------------------------------------------------
      subroutine ncplot2d(noid,fname,labl,start2,count2,dim2,&
                       psi,nw,units,nw_u)

! nc-output: define plot variable & attributes

      implicit none
!     
#include <netcdf.inc>
      
      integer, intent(in) :: noid,start2(2),count2(2),nw
      integer, intent(in) :: dim2(2),nw_u
      real, intent(in) :: psi
      character, intent(in) :: fname*10,labl*56,units*12

      integer :: istat,id
      character :: msgerr*19

      
! check if field is already defined
      istat = nf_inq_varid(noid,fname,id)
      if (istat /= NF_NOERR) then
	
        istat = nf_redef(noid)
        if (istat /= NF_NOERR) call check_err(istat,'redef ')

        istat = nf_def_var(noid,fname,NF_DOUBLE,2,dim2,id)
        msgerr = 'defvar '//fname
        if (istat /= NF_NOERR) call check_err(istat,msgerr)

        istat = nf_put_att_text(noid,id,'long_name',nw,labl)
        msgerr = 'put att_'//fname//' name'
        if (istat /= NF_NOERR) call check_err(istat,msgerr)
	
        istat = nf_put_att_text(noid,id,'units',nw_u,units)
        msgerr = 'put att_'//fname//' units'
        if (istat /= NF_NOERR) call check_err(istat,msgerr)

        istat = nf_enddef(noid)
        if (istat /= NF_NOERR) call check_err(istat,'enddef ')
	 
      endif
      
! put values in new file
      msgerr = 'putvar '//fname
      istat = nf_put_vara_double(noid,id,start2,count2,psi)
      if (istat /= NF_NOERR) call check_err(istat,msgerr) 

      end subroutine ncplot2d
!----------------------------------------------
      subroutine ncplot4d(noid,fname,labl,start4,count4,dim4,&
                       psi,nw,units,nw_u)

! nc-output: define plot variable & attributes

      implicit none
!     
#include <netcdf.inc>
      
      integer, intent(in) :: noid,start4(4),count4(4),nw
      integer, intent(in) :: dim4(4),nw_u
      real, intent(in) :: psi
      character, intent(in) :: fname*10,labl*56,units*12

      integer :: istat,id
      character :: msgerr*19

      
! check if field is already defined
      istat = nf_inq_varid(noid,fname,id)
      if (istat /= NF_NOERR) then
	
        istat = nf_redef(noid)
        if (istat /= NF_NOERR) call check_err(istat,'redef ')

        istat = nf_def_var(noid,fname,NF_DOUBLE,4,dim4,id)
        msgerr = 'defvar '//fname
        if (istat /= NF_NOERR) call check_err(istat,msgerr)

        istat = nf_put_att_text(noid,id,'long_name',nw,labl)
        msgerr = 'put att_'//fname//' name'
        if (istat /= NF_NOERR) call check_err(istat,msgerr)
	
        istat = nf_put_att_text(noid,id,'units',nw_u,units)
        msgerr = 'put att_'//fname//' units'
        if (istat /= NF_NOERR) call check_err(istat,msgerr)

        istat = nf_enddef(noid)
        if (istat /= NF_NOERR) call check_err(istat,'enddef ')
	 
      endif
      
! put values in new file
      msgerr = 'putvar '//fname
      istat = nf_put_vara_double(noid,id,start4,count4,psi)
      if (istat /= NF_NOERR) call check_err(istat,msgerr) 

      end subroutine ncplot4d
!--------------------------------------------------------------------------
      subroutine check_err(status,name)

      implicit none

#include <netcdf.inc>

      integer,intent(in) :: status
      character(len=*),intent(in) :: name

      write(6,*) 'error in ',name
      write(6,*) NF_STRERROR(status)
      write(6,*) ' '

      stop
 
      end subroutine check_err

