!
      module params_module
! For testing, reduce array dimensions
!      
      implicit none
!
   integer,parameter :: &
! am 10/31/2014 test higher resolution case
!      nmlat_h  = 141,  &          ! a test see grid.f90 / number of magnetic latitudes in one hemisphere P,S1, and R points
       nmlat_h  = 91,   &          ! org. 81 pts; a number of magnetic latitudes in one hemisphere P,S1, and R points (new grid Feb2015)
!       nmlat_h  = 200,   &          ! b number of magnetic latitudes in one hemisphere P,S1, and R points (new grid Feb2015)
!
       nmlatS2_h= nmlat_h-1,    &  ! number of magnetic latitudes in one hemisphere S2 points
       nmlat_T1 = (2*nmlat_h-1),&  ! total number of magnetic latitudes P/S1 points- equator value is double
       nmlat_T2 = (2*nmlatS2_h),&  ! total number of magnetic latitudes S2 points
       nmlat_T3 = (2*nmlat_h)  ,&  ! total number of magnetic latitudes R points- no equator value
       nmlon    = 120,          &  ! number of magnetic longitudes P,S1,S2,R points
!       nmlon    = 12,          &  ! number of magnetic longitudes P,S1,S2,R points
       nmlon_h  = nmlon/2,      &  ! NOTE!! Assumes nmlon is even
       nmlonp1  = nmlon+1,      &
!       
       nlonlat = nmlon*nmlat_T1, &   ! 2023.02 am solve two hemisphere
!       nlonlat = nmlon*nmlat_h, &  ! 2023.02 am solve one hemisphere

       nlat_qd = 221,  &  !1181 ; 21,           &  ! number of quasi dipole latitudes, edge points j-0.5
!       nlat_qd = 17,  &  !1181 ; 21,           &  ! number of quasi dipole latitudes, edge points j-0.5
!       nlat_qd = 181,  &  !1181 ; 21,          &  ! number of quasi dipole latitudes, edge points j-0.5
       nlat_qd_h=(nlat_qd+1)*0.5, &! half of the hemisphere (assumes point at equator) edge points j-0.5
! nglon=73, nglat=91 gives 5 x 2 deg lon-lat grid for magnetic perturbations
       nglon = 119, nglat = 179      ! dimensions of geographic grid
!       nglon = 199, nglat = 359      ! TEST Patrick 2021/11/12
!       nglon = 73, nglat = 91      ! dimensions of geographic grid
!       nglon = 5, nglat = 5      ! dimensions of geographic grid
!        for calculating delB (cannot be larger than nggjlat)
! 
! lat/lon arrays      
    real :: ylonm(nmlon),    &    ! magnetic longitudes of p and s2 grid; same for both hemispheres
            ylatm(nmlat_h,2),&    ! magnetic latitudes of p and s1 points; 2 index for hemisphere
            ylatm_s(nmlatS2_h,2),&! magnetic latitudes of s2-points; 2 index for hemisphere
            ylonm_s(nmlon),&      ! magnetic longitudes of s1 points; same for both hemispheres
            rho(nmlat_h,2),&      ! cos of magnetic latitudes of p and s1 points; 2 index for hemisphere
            rho_s(nmlatS2_h,2),&  ! cos of magnetic latitudes of s2-points; 2 index for hemisphere 
            glon(nglon),&         ! geographic longitude grid for delB (degrees)
            glat(nglat)           ! geographic latitude grid for delB (degrees)
! apex heights for ylam & ylam_s          
    real :: ha(nmlat_h),    &     ! apex height calculated in grid.f90 for ylatm points; same for both hemispheres
            ha_s(nmlatS2_h)       ! apex height calculated in grid.f90 for ylatm_s points; same for both hemispheres
!	       
! for fixed height grid
! am 10/31/2014 test higher resolution case
      integer, parameter :: nhgt_fix   = 54   ! was 51         
        ! nhgt_fix   = 51 for       parameter (yb = 5., yc = 14.)
!                                   parameter (d1=25., d2=50., d3=60., d4=72., d5=82.)
        ! nhgt_fix   = 54 for       parameter (yb = 5., yc = 18.)
!                                   parameter (d1=30., d2=50., d3=60., d4=72., d5=82.)
        ! nhgt_fix   = 55 for       parameter (yb = 5., yc = 20.)
!                                   parameter (d1=35., d2=50., d3=60., d4=72., d5=82.)
!!
     integer, parameter :: nhgt_fix_r = nhgt_fix+1   ! looked at apex height of ylatm_s
       
!       
! Select speed and accuracy of delB calculations by the choice of
!   delBsolution and nggjhgt below.  nggjhgt is the number of current
!   layers used to get spherical-harmonic coefficients for magnetic
!   perturbations.  
!
! Single current layer combining horizontal currents up to 397.14 km,
!   with delB calculated only at the ground.
!     character(len=16), parameter :: delBsolution = 'quick_ground    '
!     integer,parameter :: nggjhgt=1
!     real,parameter :: h_LEO=397139.  ! Nominal height for calculating LEO delB
!
! Single current layer combining horizontal currents up to 397.14 km,
!   with delB calculated at the ground and and at h_LEO (which may not
!   exceed ggjtop(1)=397139 m for this case).
!     character(len=16), parameter :: delBsolution = 'quick_ground,LEO'
!     integer,parameter :: nggjhgt=1
!     real,parameter :: h_LEO=397139.  ! Nominal height for calculating LEO delB
!
! Horizontal currents are combined into 18 thick layers,
!   and delB is calculated at the ground and at heights between 299702 m
!   and 540303 m, and between 764409 m and 948105 m.
!     character(len=16), parameter :: delBsolution = 'ground,LEO     '
!     integer,parameter :: nggjhgt=18
!     real,parameter :: h_LEO=397139.  ! Nominal height for calculating LEO delB
!      (h_LEO may not exceed ggjtop(nggjhgt)=948105.)
!       
! Heights for current layers are set to heights of rho and QD grids.
!   This gives the most accurate but time-consuming solution.
     character(len=16), parameter :: delBsolution = 'full_hgt_delB  '
     integer,parameter :: nggjhgt=nhgt_fix
     real,parameter :: h_LEO=400000.  ! Nominal height for calculating LEO delB
!      (h_LEO may not exceed ggjtop(nggjhgt)=1114811.)
!
     integer, parameter :: &
               nggjlon = 120, & ! number of geographic longitude points
!               nggjlon = 200,  & ! TEST Patrick 2021/11/12
!               nggjlon = 12, & ! number of geographic longitude points
!                        for calculating currents, to get spherical-harmonic
!                        coefficients for magnetic perturbations (delB).
!               nggjlat = 120, & ! number of geographic latitude points
!               nggjlat = 16, & ! number of geographic latitude points
               nggjlat = 180, & ! number of geographic latitude points
!               nggjlat = 360, & !  TEST Patrick 2021/11/12
!                        for calculating currents, to get spherical-harmonic
!                        coefficients for magnetic perturbations.  
! Following parameters l1ggj through mdab are for SPHEREPACK 3.2
               l1ggj=min0(nggjlat,(nggjlon+2)/2), &
               l2ggj=(nggjlat+1)/2, &
               lvhags=l2ggj*nggjlat*(2*nggjlat-l1ggj+1)+nggjlon+15,  &
               lshags=nggjlat*(3*(l1ggj+l2ggj)-2)+(l1ggj-1)*       &
                      (l2ggj*(2*nggjlat-l1ggj)-3*l1ggj)/2+nggjlon+15, &
               lwork=max0(4*nggjlat*(nggjlat+2)+2, &
                      (2*nggjhgt+1)*nggjlat*nggjlon), &
               mdab=min0(nggjlat,(nggjlon+2)/2)
     integer ::  ktop         ! k index for the highest hgt_fix layer
!        used for calculations of currents, plus 1.
     integer :: k_fix_ggjbot(nhgt_fix_r) ! array that gives the appropriate
!        index of hgt_fix_r corresponding to the k index of ggjbot(k) (defined
!        in calc_B.f90 such that ggjbot(k+1)=ggjtop(k)).
     real :: hgt_fix(nhgt_fix)  	  ! array with fixed heights for s&p-grids
     real :: hgt_fix_r(nhgt_fix_r)  	  ! array with fixed heights for r-grid (not the highest point?)
     real :: ggjlon(nggjlon)   ! geographic longitude grid for J (radians)
     double precision ::  &
           ggjclat(nggjlat), & ! geographic Gaussian colatitude grid for J (rad)
           wts(nggjlat)       ! Gaussian weights
!
     real :: ggjhgt(nggjhgt), & ! geographic height grid for J (m)
             ggjtop(nggjhgt)    ! top heights of J layers (m)
!
! Each gg current point falls in a QD lat-lon box.
! The western edge of the box lies on QD longitude lon_qd_mp(iw(i,j,k)),
!  with iw=1 corresponding to QD longitude = -pi.
! The southern edge of the box lies on QD latitude lat_qd_ed(ls(i,j,k)),
!  with ls=1 corresponding to QD latitude = -pi/2 (south QD pole).
! The fractional distance of the gg point from the western box edge
!  is fw(i,j,k).
! The fractional distance of the gg point from the southern box edge
!  is fs(i,j,k).
     real :: iw(nggjlon,nggjlat,nggjhgt), &
             fw(nggjlon,nggjlat,nggjhgt), &
             ls(nggjlon,nggjlat,nggjhgt), &
             fs(nggjlon,nggjlat,nggjhgt), & 
             f11gg(nggjlon,nggjlat,nggjhgt), & 
             f12gg(nggjlon,nggjlat,nggjhgt), & 
             f21gg(nggjlon,nggjlat,nggjhgt), & 
             f22gg(nggjlon,nggjlat,nggjhgt), & 
             f31oFgg(nggjlon,nggjlat,nggjhgt), & 
             f32oFgg(nggjlon,nggjlat,nggjhgt)
!
! global constants
      real, parameter ::           &
         re = 6.37122e6,           &   ! earth radius (m)		     
         h0 = 8.0e4, r0 =re+h0,    &   ! use mean earth radius [m]
         pi = 3.14159265358979312, &
	 dtr = pi/180.,            &
	 rtd = 180./pi,            &
         mu0 = 4.e-7*pi,           &
         cm2m=0.01,                &
         km2m=1.e3,                &
         m2km=1.e-3,               &
         m2cm=100.,                &
	 val_fill=999999.,         &  ! fill value
	 matm = 1.6605e-24,        &  ! mass per atomic weight [g/mole] = 1/N_A (N_A Avogadro number)
	 grav = 8.7,               &  ! gravity [m/s2] 
	 boltz =  1.38065E-23        ! Boltzmann constant  [m2 kg/s2/K]
	 
! geophysical conditions & time
     real ::  &
       f107,	 &   ! solar radio flux [sfu]
       ap,	 &   ! ap index
       year,	 &   ! year
       doy,	 &   ! day of year
       ut,       &   ! ut
       swden,swvel, & ! solar wind
       bx,by,bz, &    ! IMF conditions (not used so far)
       ctpoten,hpower,& ! used in tiegcm
       sunlon          ! mag. longitude of subsolar point
	 
! solving both hemispheres         
     real, parameter :: ylatm_JT = 45.*dtr ! 45.*dtr  ! equatorward of this latitude the potential is the same at
                                            ! conjuagte points
     integer :: jlatm_JT                    ! corresponding index 
     real ::  bijSum                        ! sum over nmlon of bij needed for pole equation NH & SH b is the same
     logical, parameter :: pc_uncoupled = .true.  ! art_2023.06.20
     real :: pccolatrad(nmlon)
     logical, parameter :: readin_amie = .false.  ! flag AMIE FAC read in (has to be readin_fac == true as well
     logical, parameter :: readin_fac  = .true.   ! general flag is FAC is used at high latitude
     
! Boundary conditions
! lower boundary Je2LB defined by lower atmosphere model
    logical, parameter :: use_lbJ = .false.
    real  :: J3LB(nmlon,nmlat_h,2)    ! r-points current from lower atmosphere [A/m2]
    character(len=*),parameter :: lbcurrent_fname = & 
       '/glade/p/work/maute/3Dcurrent/LB_data/jaroslav_data.nc'
! 	 
! Boundary conditions
! lower boundary Je2LB defined by lower atmosphere model
    logical, parameter :: test_pot =.false.
    
! set up a regional test potential
    logical, parameter :: test_loc_pot =.true.   
!     
! No wind forcing
    logical, parameter :: no_wind =.false.
!   
! TIEGCM readin 
    logical, parameter :: read_tiegcm =.true.
!    
! Empirical conductivities (note does not have auroral conductivity included
!                           therefore do not use with high latitude potential)   
    logical, parameter :: get_empConduc =.false.
! Empirical Wind 
    logical, parameter :: get_empWind =.false.
! 	 
! Jpg
! Ionospheric current
    logical, parameter :: Jpg     =.false.
    logical, parameter :: Jpg_add =.false.  ! flag can be reomved once Jpg is tested
!
    
    contains
!-----------------------------------------------------------------
   subroutine set_condition(istep_end)
   
   integer, intent(inout) :: istep_end
 
   if(istep_end.eq.0) then
     f107= 80.     ! solar radio flux [sfu]
     ap  = 132.       ! ap index for use in IRI or MSIS?
     year= 2017.    ! year
     doy = 147.     ! day of year
     ut  = 0.	    ! ut
     istep_end = 1  ! how many time steps
   else
     ut = ut + 1.  ! increase time
     if(ut.ge.24) then
       ut  = ut -24.
       doy = doy+1
     endif
   endif  
    
   end subroutine set_condition
!-----------------------------------------------------------------------
   end module params_module
!-------------------------------------------------------------------
