     program main
!     
     use fieldline_p_module,only: fieldline_p_dim
     use fieldline_s_module,only: fieldline_s_dim
     use fieldline_r_module,only: fieldline_r_dim
     use qd_module,only: gen_qd_grid
     use params_module,only: year,doy,ut, &
        test_pot,use_lbJ,read_tiegcm, &
	get_empConduc,get_empWind,set_condition
     use nc_module,only: nc_create,nc_output
     use coef_module,only: calc_coef,const_rhs, &
        set_coef_ns,set_bij2     ! art_2023.06.20
     use Iqd_module, only: qcoef,calc_Iqd
     use lbcurrent_module, only: get_LBcurrent,map_LBcurrent
     use area_factors_module, only: calc_mf
     use readtiegcm_module, only: readin_tiegcm,map_tiegcm
     use delB_module, only: calc_Bcoef,calc_B,gen_geo_grid
!     
     implicit none
!	
     integer :: istep,istep_end,istart  ! controls time stepping
     logical,parameter :: debug=.true.
     real :: date_run,secs 
!   
! set up magnetic latitude and longitude grid  
     call gen_highres_grid
     if(debug) write(6,*) 'done gen_highres_grid'
     
     call gen_ggj_grid
     write (6,*) 'gen_ggj_grid done'
!     
! set up p-fieldline grid
     call fieldline_p_dim
     if(debug) write(6,*) 'done fieldline_p_dim' 
         
! set up s-fieldline grid
     call fieldline_s_dim
     if(debug) write(6,*) 'done fieldline_s_dim' 
         
! set up r-fieldline grid
     call fieldline_r_dim
     if(debug) write(6,*) 'done fieldline_r_dim'
     
! set up qd grid
     call gen_qd_grid
     call gen_geo_grid
     
     if(debug) write(6,*) 'done gen_qd_grid'
!
     istep_end = 0  ! get how many time steps -> istep_end
     if(read_tiegcm) then
       call readin_tiegcm(istep,istep_end)
       if(debug) write(6,*) 'done readin init'
     else
       call set_condition(istep_end) ! if not read in from tiegcm file
     endif
     
     call qcoef
     write (6,*) 'qcoef done'
     
     istep_end =1 !504   !204 !  480 !960 !480! 960  ! 480
     istart = 1 !504 ! 204   ! 1  481 !961 ! 481 ! 1
!     
!    do istep = 1,istep_end  ! time loop 
    do istep = istart,istep_end  ! time loop 
!
! readin TIEGCM conductivities and winds & conditions
     if(read_tiegcm) then
       call readin_tiegcm(istep,istep_end)
       if(debug) write(6,*) 'done readin tiegcm step=', istep
     else
       if(istep.gt.istart) call set_condition(istep_end) ! if not read in from tiegcm file
     endif                                        ! first step is set above

!     
! get apex values
     if(istep == istart) then ! only first timestep
       date_run = year + doy/365.
       call apxparm(date_run)
       if(debug) write(6,*) 'done apxparm'
     endif  
     
!  do the mapping if tiegcm file is used (need apex call before for geographic coordinates)   
     if(read_tiegcm) then
        secs = (ut)*3600  ! ut [h] convert to secs
        write(6,*) 'sunloc ',int(year),int(doy),secs
        call sunloc_apex(int(year),int(doy),secs) ! for mapping from mlt to mlon

        call map_tiegcm   ! map TIEGCM conductivities and winds
        if(debug) write(6,*) 'done map_tiegcm/amie'
     endif 
!     goto 100
    
! get LB current and map to 3Dynamo grid 
     if(use_lbJ) then
       call get_LBcurrent 
       if(debug) write(6,*) 'done get_LBcurrent' 
       call map_LBcurrent
       if(debug) write(6,*) 'done map_LBcurrent' 
     endif    
    
! get conductivities (either MSIS/IRI or read in data)
     if(get_empConduc) then 
       call get_conduct 
       if(debug) write(6,*) 'done get_conduct'
     endif           
    
! get horizonatal neutral wind (either HWM93 or read in data)
    if(get_empWind) then 
       call get_hwm93 
       if(debug) write(6,*) 'done get_hwm07'  
     endif           
    
! set up test case for prescribed wind fields
     if(test_pot) then
!       call setup_test
!	call setup_test2
!	call setup_test3
!	call setup_test4
	call setup_test5
       if(debug) write(6,*) 'done setup_test' 
     endif  
    
! create output file
     if(istep == istart) then
       call nc_create 
       if(debug) write(6,*) 'done nc_create' 
    endif
    ! goto 200
    
! calculate M- and N-coefficients (S1,S2,R points, but for QD is done in get_apex)
     call calc_mf
     call calc_mn_s1s2
     if(debug) write(6,*) 'done calc_MN_S1S2' 
     
! calculate JeD-coefficients (right hand side)
     call calc_je_s1s2
     if(debug) write(6,*) 'done calc_je_s1s2'  
     
! calculate S (right hand side)
     call calc_S
     if(debug) write(6,*) 'done calc_S'     
     
! calculate bij (interhemispheric conductance))
!     call set_bij		! art_2023.06.20 remove call here
 !    if(debug) write(6,*) 'done set_bij'     
     
! calculate coefficients and sum up in height (left hand side)
     call calc_coef
     if(debug) write(6,*) 'done calc_coef' 

! calculate bij (interhemispheric conductance))
     call set_bij2       ! art_2023.06.20 added call here
     if(debug) write(6,*) 'done set_bij2'   
     
! set coefficient stencil coef_ns in both hemispheres: lhs & rhs 2023.02 am solve two hemisphere
     call set_coef_ns
     if(debug) write(6,*) 'done set_coef_ns' 
    
! construct LHS & RHS matrix and solve; add bij effect to matrix
!      .not.readin_fac calculates otherwise corrects FAC forcing
!       test_loc_pot sets potential, set Dyn. focing to zero, calculates FAC, and special correcttion
     call const_rhs
     if(debug) write(6,*) 'done const_rhs' 
!     
! calculate electric fields
     call calc_Efield
     if(debug) write(6,*) 'done calc_Efield' 
!     
! calculate I1, I2 & I3
     call calc_I
     if(debug) write(6,*) 'done calc_I' 
!     
! calculate I1qd, I2qd & I3qd on qd volumes
     call remap_weights
     call calc_Iqd
     if(debug) write(6,*) 'done calc_Iqd'  
!     gladequta
! calculate magnetic perturbations
     call calc_Bcoef
     if(debug) write(6,*) 'done calc_Bcoef'
     call calc_B
     if(debug) write(6,*) 'done calc_B' 
!     
! output fields
 200    call nc_output (istep,istart) 
     if(debug) write(6,*) 'done nc_output'
     
     enddo   ! end time loop
     
 100 continue    
!     
     end program main	  
!-----------------------------------------------------------------------------------------------
