!
      module readtiegcm_module 
      
      use params_module,only:  nmlon,nmlat_T1,nmlat_h,dtr,h0,
     |  nmlat_T2,hgt_fix,rtd ,nmlatS2_h,readin_amie,readin_fac 
!      
      implicit none
      
      integer ::  
     |  nlon_tiegcm,    ! nlon
     |  nlat_tiegcm,    ! nlat
     |  nilev_tiegcm,   ! nilev
     |  nmlon_tiegcm,   ! nmlon
     |  nmlat_tiegcm,   ! nmlat
     |  nmlon_amie,     ! nmlon for amie
     |  nmlt_amie,      ! nmlt for amie
     |  nmlat_amie      ! nmlat for amie
      
      character(len=*),parameter :: input_type='NETCDF'

! working directory and filenames    
!      character(len=*),parameter :: work = 
!     |'//glade/campaign/hao/itmodel/ganglu/tiegcm_v2.0/'
!      character(len=*),parameter :: flnm  = 
!      |  'tiegcm_v2.0.s_mar2015_amie_34.nc'
!      character(len=*),parameter :: work = 
!     |'/glade/scratch/maute/tiegcm_mar2015_amie/'
!      character(len=*),parameter :: flnm  = 
!     |  'Dyn_tiegcm_v2.0.s_mar2015_amie_01_29.nc'
!     |  'Dyn_tiegcm_v2.0.s_mar2015_amie_60_84.nc'
!     |  'Dyn_tiegcm_res1.25.s_mar2015_amie_01_19.nc'
!     |  'Dyn_tiegcm_res1.25.s_mar2015_amie_20_36.nc'
!      character(len=*),parameter :: work = 
!     |'/glade/campaign/hao/itmodel/maute/projects/egbert_nsf2015/tiegcm_
!     |2002_1year/'
!      character(len=*),parameter :: flnm  = 
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_001_010.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_011_039.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_040_069.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_070_099.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_100_129.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_130_159.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_160_189.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_190_219.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_220_249.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_250_279.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_280_309.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_310_339.nc'
!     |  'Dyn_tiegcm_icon_trunk_3dyn_2009_340_364.nc'
!     
!      character(len=*),parameter :: work = 
!     |'/glade/campaign/hao/itmodel/maute/projects/egbert_nsf2015/tiegcm_
!     |2009/'
!      character(len=*),parameter :: flnm  = 
!     |  'Inp3D_tiegcm_iocn_trunk_2009.010_029.nc'
!     |  'Inp3D_tiegcm_iocn_trunk_2009.030_049.nc'
!     |  'Inp3D_tiegcm_iocn_trunk_2009.050_089.nc'
!     |  'Inp3D_tiegcm_iocn_trunk_2009.090_129.nc'
!     |  'Inp3D_tiegcm_iocn_trunk_2009.130_169.nc'
!     |  'Inp3D_tiegcm_iocn_trunk_2009.170_209.nc'
!     |  'Inp3D_tiegcm_iocn_trunk_2009.210_239.nc'
!     |  'Inp3D_tiegcm_iocn_trunk_2009.240_279.nc'
!     |  'Inp3D_tiegcm_iocn_trunk_2009.280_319.nc'
!     |  'Inp3D_tiegcm_iocn_trunk_2009.320_365.nc'
!     
!      character(len=*),parameter :: work = 
!     |'/glade/scratch/maute/tiegcm_mar2013_amie/'
!      character(len=*),parameter :: flnm  = 
!     |  'Dyn_tiegcm_v2.0.s_mar2013_amie_01_30.nc'
!     |  'Dyn_tiegcm_v2.0.s_mar2013_amie_31_60.nc'
!
!      character(len=*),parameter :: work = 
!     |'/glade/scratch/maute/tiegcm_sep2017_amie/'
!      character(len=*),parameter :: flnm  = 
!     |  'Dyn_tiegcm1.25_amie_s_sep2017_01_25.nc'
!     |  'Dyn_tiegcm1.25_amie_s_sep2017_26_50.nc'
!     |  'Dyn_tiegcm1.25_amie_s_sep2017_51_84.nc'
     
!      character(len=*),parameter :: work = 
!     |'/glade/scratch/maute/tiegcm_may2017_amie/'
!      character(len=*),parameter :: flnm  = 
!     |  'Dyn_tiegcm1.25_amie_s_may2017_01_25.nc'
!     |  'Dyn_tiegcm1.25_amie_s_may2017_26_50.nc'
!     |  'Dyn_tiegcm1.25_amie_s_may2017_51_72.nc'


!      character(len=*),parameter :: work = 
!     |'/glade/campaign/hao/itmodel/maute/projects/egbert_LWS_GIC/strom_s
!     |imulations/2017_may_tiegcm1.25_amie/'
!      character(len=*),parameter :: flnm  = 
!     |  'Dyn_tiegcm1.25_amie_s_may2017_01_24.nc'
!     |  'Dyn_tiegcm1.25_amie_s_may2017_25_49.nc'
!     |  'Dyn_tiegcm1.25_amie_s_may2017_50_72.nc'
!     | 'Dyn_Amie_may2017_148ut0.nc'
!     | 'Dyn_tiegcm1.25_amie_s_may2017_ut0800.nc'

!      character(len=*),parameter :: work = 
!     |'/glade/campaign/hao/itmodel/maute/projects/egbert_LWS_GIC/strom_s
!     |imulations/2017_sep_tiegcm1.25_amie/'
!      character(len=*),parameter :: flnm  = 
!     |  'Dyn_tiegcm1.25_amie_s_sep2017_01_29.nc'
!     |  'Dyn_tiegcm1.25_amie_s_sep2017_30_54.nc'
!     |  'Dyn_tiegcm1.25_amie_s_sep2017_55_84.nc'
      
      character(len=*),parameter :: work = 
     |'/glade/campaign/hao/itmodel/maute/projects/muri2017/simulations/2
     |010may/tiegcm_facKnipp_may2010/'
      character(len=*),parameter :: flnm  =
     |'tiegcm_Fac_may2010Dyn_FAC2Jqr_IncrS1.5fac1.1_s.018.nc'
     
!      character(len=*),parameter :: work = 
!     |  '/glade/campaign/hao/itmodel/maute/projects/egbert_LWS_GIC/stro
!     |m_simulations/2017_may_tiegcm1.25_amie/'
!      character(len=*),parameter :: flnm  =
!     |'Dyn_tiegcm1.25_amie_s_may2017_25_49.nc'
!
      real, allocatable,dimension(:,:,:) ::z_in,un_in,vn_in,
     | sigP_in,sigH_in,je1pg_in,je2pg_in
      real, allocatable,dimension(:,:) :: wei_in,fac_in
      real, allocatable,dimension(:,:) :: wei_smo
      real, allocatable,dimension(:)   :: lat_tie,lon_tie,
     |   ilev_tie,mlon_tie,mlat_tie 
      real, allocatable,dimension(:)   :: mlt_amie,mlon_amie,mlat_amie
      real, allocatable,dimension(:,:) :: facN_amie,facS_amie
!
      real, dimension(nmlon,nmlat_T1) :: poten_hl ! high latitude potential r-points   
!      
      contains
!-----------------------------------------------------------------------
      subroutine readin_tiegcm(istep,istep_end)
! for tiegcm amie simulations
!        float PED_DYN(time, lev, lat, lon) ;
!                long_name = "sigma-ped" ;
!                units = "S/m" ;
!        foat HAL_DYN(time, lev, lat, lon) ;
!                long_name = "sigma-hall" ;
!                units = "S/m" ;
!        foat UN(time, lev, lat, lon) ;
!                long_name = "zonal neutral wind" ;
!                units = "cm/s" ;
!        foat VN(time, lev, lat, lon) ;
!                long_name = "merid. neutral wind" ;
!                units = "cm/s" ;
!        float Z(time, lev, lat, lon) ;
!                long_name = "geopotential height" ;
!                units = "cm" ;
!        float  PHIHM(time, mlat, mlon) prescribed potential
!                PHIMW:units = "VOLTS" ;
!                PHIMW:missing_value = 1.e+36 ;    

      
      use params_module,only: year,f107,doy,ut,bx,by,bz,swden,swvel, 
     |   ctpoten,hpower,Jpg
     
      implicit none  
! 
      integer,intent(in):: istep  ! timestep to read in
      integer,intent(inout):: istep_end   ! if 0 then just read in # of timesteps
         
! Local 
      integer :: istat,ncid,id,iyr,iday,imtime(3),ntime_tiegcm,i
      integer :: count3_mag(3),start3_mag(3),count4_geo(4),
     |     start4_geo(4), count3_amie(3)
      character(len=160) :: path
      real :: inbx,inby,inbz,inswvel,inswden,time
      real, allocatable,dimension(:,:,:,:) :: vals_geo
      real, allocatable,dimension(:,:,:)   :: vals_mag
!      character :: 
!     
#include "netcdf.inc"
      
!  name of datafile 
      path  = work//flnm
      write(6,*) 'opening nc-file:',path

!  open datafile    
      istat = nf_open(path,NF_NOWRITE,ncid) 
      if (istat /= NF_NOERR) then
        call check_err(istat,'error w/ open') 
        stop
      endif
      
      if(istep_end.eq.0) then
      
        istat = nf_inq_dimid(ncid,'time',id)   
        if (istat /= NF_NOERR) call check_err(istat,'id time')
        istat = nf_inq_dimlen(ncid,id,ntime_tiegcm) 
        if (istat /= NF_NOERR) call check_err(istat,'get ntime')
	istep_end = ntime_tiegcm
	
	goto 100 
          
      endif

! read in year, day and mtime        
! int mtime(time, mtimedim)         
! int year(time) 
! int day(time) 
   
      istat = nf_inq_varid(ncid,'year',id)
      if (istat /= NF_NOERR) call check_err(istat,'id year')
      istat = nf_get_vara_int(ncid,id,istep,1,iyr)
      if (istat /= NF_NOERR) call check_err(istat,'vara year')
      year = real(iyr)
      
      istat = nf_inq_varid(ncid,'day',id)
      if (istat /= NF_NOERR) call check_err(istat,'id day')
      istat = nf_get_vara_int(ncid,id,istep,1,iday)
      if (istat /= NF_NOERR) call check_err(istat,'vara day')
      doy = real(iday)
      
      istat = nf_inq_varid(ncid,'mtime',id)
      if (istat /= NF_NOERR) call check_err(istat,'id mtime')
      istat = nf_get_vara_int(ncid,id,(/1,istep/),(/3,1/),imtime)
      if (istat /= NF_NOERR) call check_err(istat,'vara mtime')
      ut = real(imtime(2))+ real(imtime(3))/60.
      
      istat = nf_inq_varid(ncid,'f107d',id)
      if (istat /= NF_NOERR) call check_err(istat,'id f107d')
      istat = nf_get_vara_double(ncid,id,istep,1,f107)
      if (istat /= NF_NOERR) call check_err(istat,'vara f107d')
      
      istat = nf_inq_varid(ncid,'ctpoten',id)
      if (istat /= NF_NOERR) call check_err(istat,'id ctpoten')
      istat = nf_get_vara_double(ncid,id,istep,1,ctpoten)
      if (istat /= NF_NOERR) call check_err(istat,'vara ctpoten')
      
      istat = nf_inq_varid(ncid,'hpower',id)
      if (istat /= NF_NOERR) call check_err(istat,'id hpower')
      istat = nf_get_vara_double(ncid,id,istep,1,hpower)
      if (istat /= NF_NOERR) call check_err(istat,'vara hpower')
      
      write(6,*) 'mtime ',imtime(1:3)
      
! get time from data file 
      istat = nf_inq_varid(ncid,'time',id)     
      istat = nf_get_vara_double(ncid,id,istep,1,time) 
      if (istat /= NF_NOERR) call check_err(istat,'vara time ') 
      
! check dimensions
      istat = nf_inq_dimid(ncid,'lon',id)
      if (istat /= NF_NOERR) call check_err(istat,'id lon')   
      istat = nf_inq_dimlen(ncid,id,nlon_tiegcm)  
      if (istat /= NF_NOERR) call check_err(istat,'get nlon')
       
      istat = nf_inq_dimid(ncid,'lat',id)
      if (istat /= NF_NOERR) call check_err(istat,'id lat')   
      istat = nf_inq_dimlen(ncid,id,nlat_tiegcm)  
      if (istat /= NF_NOERR) call check_err(istat,'get nlat') 
      
      istat = nf_inq_dimid(ncid,'ilev',id)   
      if (istat /= NF_NOERR) call check_err(istat,'id ilev')
      istat = nf_inq_dimlen(ncid,id,nilev_tiegcm) 
      if (istat /= NF_NOERR) call check_err(istat,'get nilev') 
      
      istat = nf_inq_dimid(ncid,'mlon',id)
      if (istat /= NF_NOERR) call check_err(istat,'id mlon')   
      istat = nf_inq_dimlen(ncid,id,nmlon_tiegcm)  
      if (istat /= NF_NOERR) call check_err(istat,'get nmlon')
       
      istat = nf_inq_dimid(ncid,'mlat',id)
      if (istat /= NF_NOERR) call check_err(istat,'id mlat')   
      istat = nf_inq_dimlen(ncid,id,nmlat_tiegcm)  
      if (istat /= NF_NOERR) call check_err(istat,'get nmlat') 
      
! allocate arrays      
      if (.not.allocated(un_in)) then
        allocate(un_in(nlon_tiegcm,nlat_tiegcm,nilev_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating un_in')
      endif        
      if (.not.allocated(z_in)) then
        allocate(z_in(nlon_tiegcm,nlat_tiegcm,nilev_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating z_in')
      endif     
      if (.not.allocated(vn_in)) then
        allocate(vn_in(nlon_tiegcm,nlat_tiegcm,nilev_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating vn_in')
      endif    
      if (.not.allocated(sigP_in)) then
        allocate(sigP_in(nlon_tiegcm,nlat_tiegcm,nilev_tiegcm),
     |      stat=istat)
        if (istat /= 0) call shutdown('Error allocating sigP_in')
      endif  
      if (.not.allocated(sigH_in)) then
        allocate(sigH_in(nlon_tiegcm,nlat_tiegcm,nilev_tiegcm),
     |      stat=istat)
        if (istat /= 0) call shutdown('Error allocating sigH_in')
      endif  
      if(Jpg) then 
        if (.not.allocated(je1pg_in)) then
          allocate(je1pg_in(nlon_tiegcm,nlat_tiegcm,nilev_tiegcm),
     |        stat=istat)
          if (istat /= 0) call shutdown('Error allocating je1pg_in')
        endif  
        if (.not.allocated(je2pg_in)) then
          allocate(je2pg_in(nlon_tiegcm,nlat_tiegcm,nilev_tiegcm),
     |        stat=istat)
          if (istat /= 0) call shutdown('Error allocating je2pg_in')
        endif  
      endif
      
      if (.not.allocated(wei_in)) then
        allocate(wei_in(nmlon_tiegcm,nmlat_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating wei_in')
      endif 
      if (.not.allocated(wei_smo)) then
        allocate(wei_smo(nmlon_tiegcm,nmlat_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating wei_smo')
      endif 
      if (.not.allocated(vals_geo)) then
        allocate(vals_geo(nlon_tiegcm,nlat_tiegcm,nilev_tiegcm,1),
     |      stat=istat)
        if (istat /= 0) call shutdown('Error allocating vals_geo')
      endif  
      if (.not.allocated(vals_mag)) then
        allocate(vals_mag(nmlon_tiegcm,nmlat_tiegcm,1),
     |      stat=istat)
        if (istat /= 0) call shutdown('Error allocating vals_mag')
      endif 
      if (.not.allocated(lon_tie)) then
        allocate(lon_tie(nlon_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating lon_tie')
      endif   
      if (.not.allocated(lat_tie)) then
        allocate(lat_tie(nlat_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating lat_tie')
      endif   
      if (.not.allocated(ilev_tie)) then
        allocate(ilev_tie(nilev_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating ilev_tie')
      endif   
      if (.not.allocated(mlon_tie)) then
        allocate(mlon_tie(nmlon_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating mlon_tie')
      endif   
      if (.not.allocated(mlat_tie)) then
        allocate(mlat_tie(nmlat_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating mlat_tie')
      endif    
   
! get fields
      count3_mag= (/nmlon_tiegcm,nmlat_tiegcm,1/)
      start3_mag= (/1,1,istep/)
      count4_geo= (/nlon_tiegcm,nlat_tiegcm,nilev_tiegcm,1/)
      start4_geo= (/1,1,1,istep/)
      
!      istat = nf_inq_varid(ncid,'Z_DYN',id)
      istat = nf_inq_varid(ncid,'Z',id)
      if (istat /= NF_NOERR) call check_err(istat,'id Z')
      istat = nf_get_vara_double(ncid,id,start4_geo,count4_geo,vals_geo)
      if (istat /= NF_NOERR) call check_err(istat,'vara Z')
      z_in(:,:,:) = vals_geo(:,:,:,1) 
      
!      istat = nf_inq_varid(ncid,'U_DYN',id)
      istat = nf_inq_varid(ncid,'UN',id)
      if (istat /= NF_NOERR) call check_err(istat,'id U_Dyn')
      istat = nf_get_vara_double(ncid,id,start4_geo,count4_geo,vals_geo)
      if (istat /= NF_NOERR) call check_err(istat,'vara U_DYN')
      !vals_geo=0. ! for testing
      un_in(:,:,:) = vals_geo(:,:,:,1)*0.01  ! convert from cm/s to m/s
      
!      istat = nf_inq_varid(ncid,'V_DYN',id)
      istat = nf_inq_varid(ncid,'VN',id)
      if (istat /= NF_NOERR) call check_err(istat,'id V_Dyn')
      istat = nf_get_vara_double(ncid,id,start4_geo,count4_geo,vals_geo)
      if (istat /= NF_NOERR) call check_err(istat,'vara V_DYN')
      !vals_geo=0. ! for testing
      vn_in(:,:,:) = vals_geo(:,:,:,1) *0.01  ! convert from cm/s to m/s
      
!      istat = nf_inq_varid(ncid,'PED_DYN',id)
      istat = nf_inq_varid(ncid,'SIGMA_PED',id)
      if (istat /= NF_NOERR) call check_err(istat,'id PED_Dyn')
      istat = nf_get_vara_double(ncid,id,start4_geo,count4_geo,vals_geo)
      if (istat /= NF_NOERR) call check_err(istat,'vara PED_DYN')
      !vals_geo(:,:,:,1)=1.0! TEST 02.23.2023
      sigP_in(:,:,:) = vals_geo(:,:,:,1)  
      
!      istat = nf_inq_varid(ncid,'HAL_DYN',id)
      istat = nf_inq_varid(ncid,'SIGMA_HAL',id)
      if (istat /= NF_NOERR) call check_err(istat,'id HAL_Dyn')
      istat = nf_get_vara_double(ncid,id,start4_geo,count4_geo,vals_geo)
      if (istat /= NF_NOERR) call check_err(istat,'vara HAL_DYN')
      !vals_geo(:,:,:,1)=0.0 ! 1.e-3  !1.0 ! TEST 02.23.2023
      sigH_in(:,:,:) = vals_geo(:,:,:,1)   
        
      if(Jpg) then
        istat = nf_inq_varid(ncid,'JE1PG_DYN',id)
        if (istat /= NF_NOERR) call check_err(istat,'id JE1PG_DYN')
        istat = nf_get_vara_double(ncid,id,start4_geo,count4_geo,
     |     vals_geo)
        if (istat /= NF_NOERR) call check_err(istat,'vara JE1PG_DYN')
        je1pg_in(:,:,:) = vals_geo(:,:,:,1)*10000. ! convert from A/cm2 to A/m2
      
        istat = nf_inq_varid(ncid,'JE2PG_DYN',id)
        if (istat /= NF_NOERR) call check_err(istat,'id JE2PG_DYN')
        istat = nf_get_vara_double(ncid,id,start4_geo,count4_geo,
     |     vals_geo)
        if (istat /= NF_NOERR) call check_err(istat,'vara JE2PG_DYN')
        je2pg_in(:,:,:) = vals_geo(:,:,:,1)*10000.  ! convert from A/cm2 to A/m2 
      endif
     
      istat = nf_inq_varid(ncid,'lon',id)
      if (istat /= NF_NOERR) call check_err(istat,'id lon')
      istat = nf_get_vara_double(ncid,id,1,nlon_tiegcm,lon_tie)
      if (istat /= NF_NOERR) call check_err(istat,'vara lon_tie')
      lon_tie = lon_tie*dtr ! convert from rad to degree
      
      istat = nf_inq_varid(ncid,'lat',id)
      if (istat /= NF_NOERR) call check_err(istat,'id lat')
      istat = nf_get_vara_double(ncid,id,1,nlat_tiegcm,lat_tie)
      if (istat /= NF_NOERR) call check_err(istat,'vara lat_tie')
      lat_tie = lat_tie*dtr ! convert from rad to degree
      
      istat = nf_inq_varid(ncid,'ilev',id)
      if (istat /= NF_NOERR) call check_err(istat,'id ilev')
      istat = nf_get_vara_double(ncid,id,1,nilev_tiegcm,ilev_tie)
      if (istat /= NF_NOERR) call check_err(istat,'vara ilev_tie')
      
      istat = nf_inq_varid(ncid,'mlon',id)
      if (istat /= NF_NOERR) call check_err(istat,'id mlon')
      istat = nf_get_vara_double(ncid,id,1,nmlon_tiegcm,mlon_tie)
      if (istat /= NF_NOERR) call check_err(istat,'vara mlon_tie')
      mlon_tie = mlon_tie*dtr ! convert from rad to degree
      
      istat = nf_inq_varid(ncid,'mlat',id)
      if (istat /= NF_NOERR) call check_err(istat,'id mlat')
      istat = nf_get_vara_double(ncid,id,1,nmlat_tiegcm,mlat_tie)
      if (istat /= NF_NOERR) call check_err(istat,'vara mlat_tie')
      mlat_tie = mlat_tie*dtr   ! convert from rad to degree
      
!     make fields symmetric for testing begin
!      do i=1,0.5*nlat_tiegcm
!          sigH_in(:,nlat_tiegcm-i+1,:) = sigH_in(:,i,:)
!          sigH_in(:,nlat_tiegcm-i+1,:) = sigH_in(:,i,:)
!          un_in(:,nlat_tiegcm-i+1,:)   = un_in(:,i,:)
!          vn_in(:,nlat_tiegcm-i+1,:)   = vn_in(:,i,:)
!          z_in(:,nlat_tiegcm-i+1,:)    = z_in(:,i,:)
!       end do
!       ! end testing symmetric

      if(.not.readin_fac) then       ! readin FAC for high latitude
         
        ! istat = nf_inq_varid(ncid,'PHIMW',id)
         istat = nf_inq_varid(ncid,'PHIHM',id)
         if (istat /= NF_NOERR) call check_err(istat,'id PHIHW')
         istat = nf_get_vara_double(ncid,id,start3_mag,count3_mag,
     |     vals_mag)
         if (istat /= NF_NOERR) call check_err(istat,'vara PHIHW')
         wei_in(:,:) = vals_mag(:,:,1) 
      else
        if(readin_amie) then  ! use AMIE fields with FAC (not on tiegcm grid)
        ! get dimensions lon_amie, lat_amie,mlt_amie - needs to be same timestep as TIEGCM
          istat = nf_inq_dimid(ncid,'lon_amie',id)
          if (istat /= NF_NOERR) call check_err(istat,'id lon_amie')   
          istat = nf_inq_dimlen(ncid,id,nmlon_amie)  
          if (istat /= NF_NOERR) call check_err(istat,'get nlon_amie')
        
          istat = nf_inq_dimid(ncid,'lat_amie',id)
          if (istat /= NF_NOERR) call check_err(istat,'id lat_amie')   
          istat = nf_inq_dimlen(ncid,id,nmlat_amie)  
          if (istat /= NF_NOERR) call check_err(istat,'get nlat_amie')
        
          ! allocate arrays
          if (.not.allocated(facN_amie)) then
            allocate(facN_amie(nmlon_amie,nmlat_amie),
     |      stat=istat)
            if (istat /= 0) call shutdown('Error allocating facN_amie')
          endif 
          if (.not.allocated(facS_amie)) then
            allocate(facS_amie(nmlon_amie,nmlat_amie),
     |      stat=istat)
            if (istat /= 0) call shutdown('Error allocating facS_amie')
          endif 
          if (.not.allocated(mlon_amie)) then
             allocate(mlon_amie(nmlon_amie),stat=istat)
             if (istat /= 0) call shutdown('Error allocating mlon_amie')
          endif   
          if (.not.allocated(mlat_amie)) then
             allocate(mlat_amie(nmlat_amie),stat=istat)
             if (istat /= 0) call shutdown('Error allocating mlat_amie')
          endif   

        ! get FAC_NH, FAC SH
        ! mlon_amie from 0 deg to 360 deg - point is double
          istat = nf_inq_varid(ncid,'lon_amie',id)
          if (istat /= NF_NOERR) call check_err(istat,'id lon_amie')
          istat = nf_get_vara_double(ncid,id,1,nmlon_amie,mlon_amie)
          if (istat /= NF_NOERR) call check_err(istat,'vara mlon_amie')
        
        ! mlat_amie from 90 deg to 50 deg 
          istat = nf_inq_varid(ncid,'lat_amie',id)
          if (istat /= NF_NOERR) call check_err(istat,'id lat_amie')
          istat = nf_get_vara_double(ncid,id,1,nmlat_amie,mlat_amie)
          if (istat /= NF_NOERR) call check_err(istat,'vara mlat_amie')
        
          if (allocated(vals_mag)) deallocate(vals_mag,stat =istat)
          if (istat /= 0) call shutdown('deallocate: vals_mag')
        
          if (.not.allocated(vals_mag)) then
            allocate(vals_mag(nmlon_amie,nmlat_amie,1),
     |      stat=istat)
            if (istat /= 0) call shutdown('Error allocating vals_mag')
          endif
          count3_amie = (/nmlon_amie,nmlat_amie,1/)
       
          istat = nf_inq_varid(ncid,'FAC_NH',id)
          if (istat /= NF_NOERR) call check_err(istat,'id FAC_NH')
          istat = nf_get_vara_double(ncid,id,start3_mag,count3_amie,
     |     vals_mag)
          if (istat /= NF_NOERR) call check_err(istat,'vara FAC_NH')
          facN_amie(:,:) = -vals_mag(:,:,1)*1.e-6  ! from mue[A/m2] to A/m2 AMIE FAC positive downward
       
       
          istat = nf_inq_varid(ncid,'FAC_SH',id)
          if (istat /= NF_NOERR) call check_err(istat,'id FAC_SH')
          istat = nf_get_vara_double(ncid,id,start3_mag,count3_amie,
     |     vals_mag)
          if (istat /= NF_NOERR) call check_err(istat,'vara FAC_SH')
          facS_amie(:,:) = -vals_mag(:,:,1)*1.e-6  ! from mue[A/m2] to A/m2 AMIE FAC positive downward
         
          if (allocated(vals_mag)) deallocate(vals_mag,stat =istat)
          if (istat /= 0) call shutdown('deallocate: vals_mag')
          ! end readin AMIE FAC
        else  ! readin_fac == true and .not.readin_amie
          ! read in FAC from TIEGCM file -tiegcm grid
          ! fac_before(time, mlat, mlon)  - mlat and mlon are already read in
          if (allocated(vals_mag)) deallocate(vals_mag,stat =istat)
          if (istat /= 0) call shutdown('deallocate: vals_mag')
          allocate(vals_mag(nmlon_tiegcm,nmlat_tiegcm,1),
     |      stat=istat)
          if (istat /= 0) call shutdown('Error allocating vals_mag')
          if (.not.allocated(fac_in)) then
            allocate(fac_in(nmlon_tiegcm,nmlat_tiegcm),stat=istat)
            if (istat /= 0) call shutdown('Error allocating fac_in')
          endif 
          
          istat = nf_inq_varid(ncid,'fac_before',id)
          if (istat /= NF_NOERR) call check_err(istat,'id fac_before')
          istat = nf_get_vara_double(ncid,id,start3_mag,count3_mag,
     |     vals_mag)
          if (istat /= NF_NOERR) call check_err(istat,'vara fac_before')
          fac_in(:,:) = vals_mag(:,:,1)   ! assume A/m2 AMIE FAC positive upward in both hemispheres
          !fac_in = 0. ! am_2025.07.28 test
        endif  ! readin_amie 
      endif    ! readin_fac 
       
! close datafile
      istat = nf_close(ncid)
      if (istat /= NF_NOERR) 
     |   call check_err(istat,'closing data 2nd file ')
      
! deallocate arrays
      if (allocated(vals_geo)) deallocate(vals_geo,stat =istat)
      if (istat /= 0) call shutdown ('deallocate: vals_geo')
      if (allocated(vals_mag))deallocate(vals_mag,stat =istat)
      if (istat /= 0) call shutdown('deallocate: vals_mag')
!      
 100  continue    
!      
      end subroutine readin_tiegcm  

!--------------------------------------------------------------------------
      subroutine map_tiegcm 
      
      use fieldline_p_module,only: fieldline_p,fline_p
      use fieldline_s_module,only: fieldline_s1,fline_s1,
     |   fieldline_s2,fline_s2
      use params_module, only: nmlat_T1,nmlon, 
     |   nhgt_fix,ylonm,ylatm,ylatm_s,nmlat_T2,pi,Jpg,sunlon
      
      ! for 2D mag.to 2D mag grid :
      integer, allocatable,dimension(:) :: ig 
      real, allocatable,dimension(:,:)  :: wt1D ! weights for 1D interpolation
      real, allocatable,dimension(:,:)  :: valhalf
!      
! geog. to magnetic 
      real, allocatable,dimension(:,:,:)   :: valz_ext,valu_ext,
     |  valv_ext,valP_ext,valH_ext,val_ext,valPG1_ext,valPG2_ext   
      integer, allocatable,dimension(:,:,:):: igHgt    ! index for height interpolation
      integer, allocatable,dimension(:,:,:):: ig2DS1   ! index for 2D interpolation
      integer, allocatable,dimension(:,:,:):: ig2DS2   ! index for 2D interpolation
      integer, allocatable,dimension(:,:,:):: jg2DS1   ! index for 2D interpolation
      integer, allocatable,dimension(:,:,:):: jg2DS2   ! index for 2D interpolation
      real, allocatable,dimension(:,:,:,:) :: wthgt    ! weight for hgt interpolation   
      real, allocatable,dimension(:,:,:,:) :: wt2DS1   ! weight for 2D interpolation     
      real, allocatable,dimension(:,:,:,:) :: wt2DS2   ! weight for 2D interpolation  
      real, allocatable,dimension(:,:,:)   :: valhgt   ! mapped to 3D height grid- horiz: geog. tiegcm   
      real, allocatable,dimension(:,:,:)   :: valhgt2  ! mapped to 3D height grid- horiz: geog. tiegcm 
      real, allocatable,dimension(:,:,:)   :: valmagS1 ! mapped to mag 3Dynamo grid     
      real, allocatable,dimension(:,:,:)   :: valmagS2 ! mapped to mag 3Dynamo grid     
      real, allocatable,dimension(:)       :: lat_tie2 ! tiegcm latitude + polar point
      
      integer :: i,j,jj,jjg,l,k,isn,istat,istart,ilon,ilat,nilev_new,
     |  nmlev_top,nmlev_diff,lev0,lev1,nlat_tiegcm2,icase,nmax,
     |  icase_max
      real :: ylat_T1(nmlat_T1),dilev,ylat_T2(nmlat_T2),
     |     dellon,dellat,frki,frkj,xlongi,sumP,sumH

!  for FAC mapping mlt to mlon 
      integer :: m,mp1,nmlat_amie2,i180(1),imid
      real :: rot,dmltm,xmlt,del
      real, allocatable :: fac_amie2(:,:),mlat_amie2(:),facAmie_hl(:,:),
     |  mlon_amie_sv(:),fac_amie_sv(:,:)
      
! Set constants:
!   rl1,rl2 are rates at which sigma1 and sigma2 decay with height
!     below bottom of model.
      real,parameter :: rl1 = 5.e5,
     |                  rl2 = 3.e5
!     above top of model.
      real,parameter :: rtp = (1./50.+1./150.)*1.e-5, ! 1/H_el? + 1/H_neutral [1/cm]
     |                  rth = (1./25.+1./150. )*1.e-5 ! 1/H_ion? + 1/H_neutral [1/cm]
     
      logical :: found
!     
! put ylatm into ylat_T1(nmlat_T1)
      ylat_T1(1:nmlat_h) = ylatm(1:nmlat_h,1)  ! southern hemisphere
      do j=1,nmlat_h          ! pole to equator
        jj = nmlat_T1+1 -j    ! equator
        ylat_T1(jj) = ylatm(j,2) 
      enddo 
! put ylatm into ylat_T2(nmlat_T2)
      ylat_T2(1:nmlatS2_h) = ylatm(1:nmlatS2_h,1)  ! southern hemisphere
      do j=1,nmlatS2_h          ! pole to equator
        jj = nmlat_T2+1 -j      ! equator
        ylat_T2(jj) = ylatm_s(j,2) 
      enddo
!      
! allocate array for height mapping    will be used for S1 and S2 points
      if (.not.allocated(ig)) then
        allocate(ig(nmlon),stat=istat)
        if (istat /= 0) call shutdown('Error allocating ig')
      endif  
      if (.not.allocated(wt1D)) then
        allocate(wt1D(2,nmlon),stat=istat)
        if (istat /= 0) call shutdown('Error allocating wt1D')
      endif 
      if (.not.allocated(valhalf)) then
        allocate(valhalf(nmlon,nmlat_tiegcm),stat=istat)
        if (istat /= 0) call shutdown('Error allocating valhalf')
      endif
      
      if(readin_fac)   wei_in = fac_in ! since the mapping should be the same just copy fac into potential field

      if(.not.readin_amie) then  ! process either potential or fac
         
      ! start of  mapping
!        
! map 2D potential from tiegcm mag grid to 3Dynamo grid
! first in longitude (each latitude the same) mlon_tie & ylonm (P points)
!      
      istart = 1
      do i=1,nmlon   ! goal lon. loop monotonic increasing
!      
        do j=istart,nmlon_tiegcm-1 ! source lon. grid monotonic increasing
!	
	  if(ylonm(i).ge.mlon_tie(j).and.ylonm(i).lt.mlon_tie(j+1)) then
	    frki = (mlon_tie(j+1) - ylonm(i))/
     |           (mlon_tie(j+1)-mlon_tie(j))
            ig(i) = j
            wt1D(1,i) = frki
            wt1D(2,i) = 1- frki 
	    istart = j
	    exit
	  endif       
        enddo       
      enddo 
!           	
! 1D mapping
      call mag1D_lon(valhalf,wei_in,ig,wt1D,nmlon_tiegcm,nmlat_tiegcm,
     |       nmlon,nmlat_tiegcm)
 
!           
! 2nd in latitude (each longitude the same) mlat_tie & ylatm (p-points)
      deallocate(ig,stat =istat)
      deallocate(wt1D,stat =istat)
      if (.not.allocated(ig)) then
        allocate(ig(nmlat_T1),stat=istat)
        if (istat /= 0) call shutdown('Error allocating ig')
      endif  
      if (.not.allocated(wt1D)) then
        allocate(wt1D(2,nmlat_T1),stat=istat)
        if (istat /= 0) call shutdown('Error allocating wt1D')
      endif 
!      
      istart = 1
      i=1
      j=1
      frki = 1.
      ig(i) = j
      wt1D(1,i) = frki
      wt1D(2,i) = 1.- frki 
       !
      i=nmlat_T1
      j=nmlat_tiegcm-1
      frki = 0.
      ig(i) = j
      wt1D(1,i) = frki
      wt1D(2,i) = 1.- frki 
!
      do i=2,nmlat_T1-1   ! goal lat. loop monotonic increasing
!       	    
        do j=istart,nmlat_tiegcm-1 ! source lat. grid monotonic increasing
!	
	  if(ylat_T1(i).ge.mlat_tie(j).and.ylat_T1(i).lt.mlat_tie(j+1)) then
	    frki = (mlat_tie(j+1) - ylat_T1(i))/
     |           (mlat_tie(j+1)-mlat_tie(j))
            ig(i) = j
            wt1D(1,i) = frki
            wt1D(2,i) = 1.- frki 
	    istart = j
	    exit
	  endif       
        enddo       
      enddo 
!           	
! 1D mapping
      call mag1D_lat(poten_hl,valHalf,ig,wt1D,nmlon,nmlat_tiegcm,
     |     nmlon,nmlat_T1)
     

      if(readin_fac) then
        ! save fac
        do isn = 1,2  ! save to output
          do j=1,nmlat_h
            if(isn.eq.1) then
	      jj = j
	    else
	      jj = nmlat_T1 - j + 1
            endif
            fline_p(:,j,isn)%fac_hl  = poten_hl(:,jj)
            fline_p(:,j,isn)%fac_map = poten_hl(:,jj)
  	  enddo 
        enddo
      else
        ! save electric potential
        do isn = 1,2  ! save to output
          do j=1,nmlat_h
            if(isn.eq.1) then
	      jj = j
	    else
	      jj = nmlat_T1 - j + 1
            endif
            fline_p(:,j,isn)%pot_hl = poten_hl(:,jj)
  	  enddo 
        enddo
      end if
      
!      do i=1,nmlon
!       do isn = 1,2
!        do j=1,nmlat_h
!             if(isn.eq.1) then
!	      jj = j
!	     else
!	      jj = nmlat_T1 - j + 1
!	     endif
!	  write(55,'(3(x,e15.8))') fline_p(i,j,isn)%mlon_qd(1),
!     |      fline_p(i,j,isn)%mlat_qd(1),poten_hl(i,jj)
!	enddo 
!       enddo 
!      enddo 
!          
      deallocate(ig,stat =istat)
      deallocate(wt1D,stat =istat)
      deallocate(valHalf,stat =istat)

! end of electric potential mapping
      
      elseif(readin_amie) then  ! map amie fac
         
!     first map from MLT to mlon (this is adapted from tiegcm)
         nmlat_amie2 = 2*nmlat_amie+2 ! add two points to make sure the FAC is zero at subauroral latitudes
         
        if (.not.allocated(fac_amie2)) then
          allocate(fac_amie2(nmlon_amie,nmlat_amie2),stat=istat)
          if (istat /= 0) call shutdown('Error allocating fac_amie2')
        endif 
        if (.not.allocated(fac_amie_sv)) then  ! copy for shifting in longitude
          allocate(fac_amie_sv(nmlon_amie,nmlat_amie2),stat=istat)
          if (istat /= 0) call shutdown('Error allocating fac_amie_sv')
        endif 
        if (.not.allocated(mlat_amie2)) then
          allocate(mlat_amie2(nmlat_amie2),stat=istat)
          if (istat /= 0) call shutdown('Error allocating mlat_amie2')
        endif
        if (.not.allocated(mlon_amie_sv)) then ! copy for shifting in longitude
          allocate(mlon_amie_sv(nmlon_amie),stat=istat)
          if (istat /= 0) call shutdown('Error allocating mlon_amie_sv')
       endif

       mlat_amie2(1:nmlat_amie) = -mlat_amie ! mlat_amie goes from 90 to 50
       fac_amie2(:,1:nmlat_amie)=  facS_amie(:,1:nmlat_amie) 
       do j=1,nmlat_amie  ! goes from 90 to 50 deg
          mlat_amie2(nmlat_amie2-j+1) = mlat_amie(j)
          fac_amie2(:,nmlat_amie2-j+1)= facN_amie(:,j) 
       end do
       mlat_amie2(nmlat_amie+1) = mlat_amie2(nmlat_amie)+1.    ! one degree equatorward
       mlat_amie2(nmlat_amie+2) = mlat_amie2(nmlat_amie+3)+-1. ! one degree equatorward
       mlat_amie2 = mlat_amie2*dtr
       
       fac_amie2(:,nmlat_amie+1)= 0. ! makes sure the FAC is zero at midlatitudes
       fac_amie2(:,nmlat_amie+2)= 0. 

       ! rotate since AMIE FAC is in mlt
       rot = sunlon*rtd                 ! mlt_amie goes from 0 to 24, sunlon [rad]
       if(rot.lt.0) rot = rot + 360.    ! 0 to 360 degrees
       rot = rot/15.                    ! convert from degree to hrs
       dmltm = 24./float(nmlon_amie) ! amie mlt resolution
       
       write(6,*) 'sunlon', sunlon/rtd, rot*15., rot, dmltm
       !do i=1,nmlon_amie        ! test for correct rotation put mlt on fac
       !   fac_amie2(i,:) =  (i-1)*dmltm
       !end do   
       
       fac_amie_sv = fac_amie2           ! otherwise might be overwritten below
       do i=1,nmlon_amie                 ! loop over amie mlt
          xmlt = (i-1)*dmltm - rot + 24. ! mlt & rotated
          xmlt = AMOD(xmlt,24.)          ! hour
          m = IFIX(xmlt/dmltm + 1.01)    ! index
          mp1 = m + 1
          IF (mp1 > nmlon_amie) mp1 = 1
          del = xmlt - (m-1)*dmltm       ! for interpolation
         
         ! process only fac where the two hemisphere are in one array
          do j=1,nmlat_amie2
             fac_amie2(i,j) = (1.-del)*fac_amie_sv(m,j) +
     |                        del*fac_amie_sv(mp1,j)
          end do
       end do
       
        ! map on longitude mlon_amie goes from 0 to 360
        if (allocated(ig)) deallocate(ig,stat =istat)
        if (allocated(wt1D)) deallocate(wt1D,stat =istat)
        if (.not.allocated(ig)) then
            allocate(ig(nmlon),stat=istat)
            if (istat /= 0) call shutdown('Error allocating ig')
        endif  
        if (.not.allocated(wt1D)) then
            allocate(wt1D(2,nmlon),stat=istat)
            if (istat /= 0) call shutdown('Error allocating wt1D')
        endif
           
!     amie arrays shift from 0-360 to  -180 to 180- mlon_amie has wrap around point
        mlon_amie_sv = mlon_amie
        fac_amie_sv  = fac_amie2
        write(6,*) 'minloc ',minloc(abs(mlon_amie-180))
        i180 = minloc(abs(mlon_amie-180))
        imid=i180(1)
        
        if(mlon_amie(imid).gt.180) imid=imid-1
        
        mlon_amie(imid:nmlon_amie)  =  mlon_amie_sv(1:imid)
       ! fac_amie2(imid:nmlon_amie,:)= fac_amie_sv(1:imid,:) ! do not used this as already mapped to -180 to 180 grid
        do i=nmlon_amie,imid,-1
           j=i-imid+1
           mlon_amie(j)  =  mlon_amie_sv(i)-360.
          ! fac_amie2(j,:)= fac_amie_sv(i,:)   ! do not used this as already mapped to -180 to 180 grid
        end do
        mlon_amie=mlon_amie*dtr  ! malon_amie from deg to rad
        
        istart = 1
        ig=-99
        do i=1,nmlon   ! goal lon. loop monotonic increasing
!      
 100       do j=istart,nmlon_amie-1 ! source lon. grid monotonic increasing
!
	      if(ylonm(i).ge.mlon_amie(j).and.ylonm(i).lt.mlon_amie(j+1)) then
	          frki = (mlon_amie(j+1) - ylonm(i))/
     |                 (mlon_amie(j+1)-mlon_amie(j))
                  ig(i) = j
                  wt1D(1,i) = frki
                  wt1D(2,i) = 1- frki 
	          istart = j
	          exit
	      endif       
           enddo
           if(ig(i).eq.-99) then
              istart = 1
              goto 100
           endif   
       enddo    	
!     1D mapping
       if (allocated(valhalf)) deallocate(valhalf)
       if (.not.allocated(valhalf)) then
            allocate(valhalf(nmlon,nmlat_amie2),stat=istat)
            if (istat /= 0) call shutdown('Error allocating valhalf')
       endif

       call mag1D_lon(valhalf,fac_amie2,ig,wt1D,nmlon_amie,nmlat_amie2,
     |        nmlon,nmlat_amie2)
         
! 1D maping in latitude
! 2nd in latitude (each longitude the same) mlat_tie & ylatm (p-points)
      if (allocated(ig)) deallocate(ig,stat =istat)
      if (allocated(wt1D)) deallocate(wt1D,stat =istat)
      if (allocated(facAmie_hl)) deallocate(facAmie_hl,stat =istat)
      
      if (.not.allocated(ig)) then
        allocate(ig(nmlat_T1),stat=istat)
        if (istat /= 0) call shutdown('Error allocating ig')
      endif  
      if (.not.allocated(wt1D)) then
        allocate(wt1D(2,nmlat_T1),stat=istat)
        if (istat /= 0) call shutdown('Error allocating wt1D')
      endif 
      if (.not.allocated(facAmie_hl)) then
        allocate(facAmie_hl(nmlon,nmlat_T1),stat=istat)
        if (istat /= 0) call shutdown('Error allocating facAmie_hl')
      endif 
!      
      ig = -99
      istart = 1
      i=1
      j=1
      frki = 1.
      ig(i) = j
      wt1D(1,i) = frki
      wt1D(2,i) = 1.- frki 
       !
      i=nmlat_T1
      j=nmlat_amie2-1
      frki = 0.
      ig(i) = j
      wt1D(1,i) = frki
      wt1D(2,i) = 1.- frki 
!
      
      do i=2,nmlat_T1-1   ! goal lat. loop monotonic increasing
!       	    
        do j=istart,nmlat_amie2-1 ! source lat. grid monotonic increasing
!	
	  if(ylat_T1(i).ge.mlat_amie2(j).and.ylat_T1(i).lt.mlat_amie2(j+1))then
	    frki = (mlat_amie2(j+1) - ylat_T1(i))/
     |           (mlat_amie2(j+1)-mlat_tie(j))
            ig(i) = j
            wt1D(1,i) = frki
            wt1D(2,i) = 1.- frki 
	    istart = j
	    exit
         endif
        enddo     
      enddo 
!           	
! 1D mapping
      call mag1D_lat(facAmie_hl,valHalf,ig,wt1D,nmlon,nmlat_amie2,
     |     nmlon,nmlat_T1)
      
      ! put into fline array
      do isn = 1,2  
        do j=1,nmlat_h
           if(isn.eq.1) then
	      jj = j
	   else
	      jj = nmlat_T1 - j + 1
           endif
           fline_p(:,j,isn)%fac_hl = facAmie_hl(:,jj)
           fline_p(:,j,isn)%fac_map = facAmie_hl(:,jj)  ! temporary for saving

!          do i=1,nmlon
!             write(41,'( "fld ",i4,3(x,e15.7))') isn,ylat_T1(jj),
!     |       ylonm(i), facAmie_hl(i,jj)
!          enddo
	enddo 
      enddo
     
      else
         write(6,*) 'not a valid choice for readin_amie'
     |         ,readin_amie,' stop'
         stop
      end if   
!
! map geographic field to S1 & S2 point grids
     
! extrapolate in height (bottom and top)
! Extend neutral atmosphere inputs down to mlev0 (zpbot_dyn=-10.)
! At 5-deg res, this will be k=0,-2, and at 2.5-deg res, k=0,-5.
! Set three equally spaced levels for Z, take U, V, and W
! to be constant, and extrapolate sigmas exponentially.
       dilev = ilev_tie(2)-ilev_tie(1)  ! scale height resolution
       nmlev_diff = (ilev_tie(1)+10)/dilev ! additional levels at bottom
       ! at the top go to 1000km tiegcm approx. 450 km for solar minimum
       !   add 550 km with approx. scale height of 75 km  add 10 levels
      nmlev_top = 10
      nilev_new =  nilev_tiegcm+nmlev_top+nmlev_diff

! alloctae arrays for mapping            
      allocate(valz_ext(nlon_tiegcm,nlat_tiegcm,nilev_new),stat=istat)
      if (istat /= 0) call shutdown('Error allocating valz_ext')
      allocate(valu_ext(nlon_tiegcm,nlat_tiegcm,nilev_new),stat=istat)
      if (istat /= 0) call shutdown('Error allocating valu_ext')
      allocate(valv_ext(nlon_tiegcm,nlat_tiegcm,nilev_new),stat=istat)
      if (istat /= 0) call shutdown('Error allocating valv_ext')
      allocate(valP_ext(nlon_tiegcm,nlat_tiegcm,nilev_new),stat=istat)
      if (istat /= 0) call shutdown('Error allocating valP_ext')
      allocate(valH_ext(nlon_tiegcm,nlat_tiegcm,nilev_new),stat=istat)
      if (istat /= 0) call shutdown('Error allocating valH_ext')
      if(Jpg) then 
        allocate(valPG1_ext(nlon_tiegcm,nlat_tiegcm,nilev_new),
     |     stat=istat)
        if (istat /= 0) call shutdown('Error allocating valPG1_ext')
        allocate(valPG2_ext(nlon_tiegcm,nlat_tiegcm,nilev_new),
     |     stat=istat)
        if (istat /= 0) call shutdown('Error allocating valPG2_ext')
      endif
      allocate(val_ext(nlon_tiegcm,nlat_tiegcm,nilev_new),stat=istat)
      if (istat /= 0) call shutdown('Error allocating val_ext')
      
!      allocate(ighgt(nlon_tiegcm,nlat_tiegcm,nilev_new),stat=istat)
      allocate(ighgt(nlon_tiegcm,nlat_tiegcm,nhgt_fix),stat=istat)  ! corrected 7/13/2022
      if (istat /= 0) call shutdown('Error allocating ighgt') 
      allocate(ig2DS1(nmlon,nmlat_T1,nhgt_fix),stat=istat)
      if (istat /= 0) call shutdown('Error allocating ig2DS1') 
      allocate(ig2DS2(nmlon,nmlat_T2,nhgt_fix),stat=istat)
      if (istat /= 0) call shutdown('Error allocating ig2DS2') 
      allocate(jg2DS1(nmlon,nmlat_T1,nhgt_fix),stat=istat)
      if (istat /= 0) call shutdown('Error allocating jg2DS1') 
      allocate(jg2DS2(nmlon,nmlat_T2,nhgt_fix),stat=istat)
      if (istat /= 0) call shutdown('Error allocating jg2DS2') 
!      allocate(wthgt(2,nlon_tiegcm,nlat_tiegcm,nilev_new),stat=istat)
      allocate(wthgt(2,nlon_tiegcm,nlat_tiegcm,nhgt_fix),stat=istat)  ! corrected 7/13/2022
      if (istat /= 0) call shutdown('Error allocating wthgt') 
      allocate(wt2DS1(4,nmlon,nmlat_T1,nhgt_fix),stat=istat)
      if (istat /= 0) call shutdown('Error allocating wt2DS1')  
      allocate(wt2DS2(4,nmlon,nmlat_T2,nhgt_fix),stat=istat)
      if (istat /= 0) call shutdown('Error allocating wt2DS2') 
      allocate(valhgt(nlon_tiegcm,nlat_tiegcm,nhgt_fix),stat=istat)
      if (istat /= 0) call shutdown('Error allocating valhgt') 
      allocate(valmagS1(nmlon,nmlat_T1,nhgt_fix),stat=istat)
      if (istat /= 0) call shutdown('Error allocating valmagS1') 
      allocate(valmagS2(nmlon,nmlat_T2,nhgt_fix),stat=istat)
      if (istat /= 0) call shutdown('Error allocating valmagS2') 
      allocate(lat_tie2(nlat_tiegcm+2),stat=istat)
      if (istat /= 0) call shutdown('Error allocating lat_tie2')
      allocate(valhgt2(nlon_tiegcm,nlat_tiegcm+2,nhgt_fix),stat=istat)
      if (istat /= 0) call shutdown('Error allocating valhgt')  
!
! copy field in the extended arrays
      valz_ext(:,:,nmlev_diff+1:nilev_new-nmlev_top)  =z_in(:,:,:)   
      valu_ext(:,:,nmlev_diff+1:nilev_new-nmlev_top)  =un_in(:,:,:)	  
      valv_ext(:,:,nmlev_diff+1:nilev_new-nmlev_top)  =vn_in(:,:,:)	  
      valp_ext(:,:,nmlev_diff+1:nilev_new-nmlev_top)  =sigP_in(:,:,:)	
      valh_ext(:,:,nmlev_diff+1:nilev_new-nmlev_top)  =sigH_in(:,:,:)
      
!       do i=1,nlon_tiegcm      ! longitude loop   
!        do j=1,nlat_tiegcm    ! latitude loop     
!        valp_ext(i,j,nmlev_diff+1:nilev_new-nmlev_top)=sigP_in(144,72,:)	
!        valh_ext(i,j,nmlev_diff+1:nilev_new-nmlev_top)=sigH_in(144,72,:)	      
!        enddo   ! latitude loop   
!       enddo   ! longitude loop
      
      if(Jpg) then		  
         valpg1_ext(:,:,nmlev_diff+1:nilev_new-nmlev_top)=
     |       je1pg_in(:,:,:)   
         valpg2_ext(:,:,nmlev_diff+1:nilev_new-nmlev_top)=
     |       je2pg_in(:,:,:)
      endif
!      
      lev0 = nmlev_diff+1
      lev1 = nilev_new-nmlev_top

!      
!      write(6,*) nmlev_diff,lev0,nmlev_top
!      write(6,*) lev1,nilev_tiegcm,nilev_new-nmlev_top-1+1,nilev_new
      do i=1,nlon_tiegcm      ! longitude loop   
        do j=1,nlat_tiegcm    ! latitude loop   
! extend downward
          do l=1,nmlev_diff  ! 1 to 24
           valz_ext(i,j,l) = h0*100+float(l-1)*
     |       (valz_ext(i,j,lev0)-h0*100)/float(nmlev_diff)
           valp_ext(i,j,l) = valp_ext(i,j,lev0)*exp((valz_ext(i,j,l)
     |       -valz_ext(i,j,lev0))/(rl1))
           valh_ext(i,j,l) = valh_ext(i,j,lev0)*exp((valz_ext(i,j,l)
     |       -valz_ext(i,j,lev0))/(rl2))
           valu_ext(i,j,l) = un_in(i,j,1)
           valv_ext(i,j,l) = vn_in(i,j,1)
           if(Jpg) then
             valpg1_ext(i,j,l) = 0. 
             valpg2_ext(i,j,l) = 0. 
	   endif	  
          enddo
!       
! extend upward
          do l= nilev_new-nmlev_top+1,nilev_new
	    k = l-nilev_new+nmlev_top
            valz_ext(i,j,l) =  valz_ext(i,j,lev1)+float(k)*
!     |       (850.e5)/float(nmlev_diff)
     |       (850.e5)/float(nmlev_top)   ! am 2019.0816 error pointed out by XuZhou nmlev_diff is for the lower boundary      
          enddo		      
          do l= nilev_new-nmlev_top,nilev_new ! last tiegcm level does not have good conductivities in it
            valp_ext(i,j,l) = valp_ext(i,j,lev1-1)*exp(-
     |        (valz_ext(i,j,l)-valz_ext(i,j,lev1-1))*rtp)
            valh_ext(i,j,l) = valh_ext(i,j,lev1-1)*exp(-
     |       (valz_ext(i,j,l) -valz_ext(i,j,lev1-1))*rth)
            valu_ext(i,j,l) = un_in(i,j,nilev_tiegcm-1)
            valv_ext(i,j,l) = vn_in(i,j,nilev_tiegcm-1)	
            if(Jpg) then
              valpg1_ext(i,j,l) = 0. 
              valpg2_ext(i,j,l) = 0. 
	    endif	     
          enddo		      
        enddo   ! latitude loop   
      enddo   ! longitude loop
!  
! set up coefficients for height mapping      
! vertical 1D mapping (mapping same for S1 & S2 points)
!
      ighgt = -99 ! initialize
      do ilon = 1,nlon_tiegcm
        do ilat = 1,nlat_tiegcm
 	  istart = 1
          do i=1,nhgt_fix   ! goal height grid monotonic increasing
            do j=istart,nilev_new-1 ! source height grid monotonic increasing
!	
	      if(hgt_fix(i)*100.ge.valz_ext(ilon,ilat,j).and.
     |                hgt_fix(i)*100.lt.valz_ext(ilon,ilat,j+1)) then
	        frki = (valz_ext(ilon,ilat,j+1) - hgt_fix(i)*100)/
     |       	    (valz_ext(ilon,ilat,j+1)-valz_ext(ilon,ilat,j))
                ighgt(ilon,ilat,i) = j
                wthgt(1,ilon,ilat,i) = frki
                wthgt(2,ilon,ilat,i) = 1.- frki
 	        istart = j
	        exit
	      endif	
           enddo       
          enddo  
	  !     
        enddo       
      enddo 
!      
! set up coefficients for horizontal S1 mapping
!
! initialize fields (since not values are set in the array)
      ig2DS1 = -999
      ig2DS2 = -999
!      
      dellon = 360./nlon_tiegcm  ! assumes regular geog. grid 
      dellat = 180/nlat_tiegcm   ! assumes regular geog. grid 
!       
! extend tiegcm lat-grid 
      nlat_tiegcm2 = nlat_tiegcm + 2     
      lon_tie = lon_tie*rtd
      lat_tie2(2:nlat_tiegcm+1) = lat_tie*rtd
      lat_tie2(1)               = -90.        ! add polar point
      lat_tie2(nlat_tiegcm+2)   =  90.        ! add polar point
!       
      do k=1,nhgt_fix            ! loop over all height grids mag grid   
        do i=1,nmlon	         ! long. loop mag. grid
	  do isn = 1,2           ! southern and northern hemisphere
	
          ! mapping to S1 points
           do j=1,nmlat_h-k+1     ! lat. loop from SPole to NPole every height grid looses 1 point
             if(isn.eq.1) then
	      jj = j
	     else
	      jj = nmlat_T1 - j + 1
	     endif
             xlongi = (fline_s1(i,j,isn)%glon(k) - lon_tie(1))/dellon
             if (xlongi < 0.) xlongi = xlongi + float(nlon_tiegcm)
             ig2DS1(i,jj,k) = xlongi
             frki = xlongi - dble(ig2DS1(i,jj,k))
             ig2DS1(i,jj,k) = ig2DS1(i,jj,k) + 1
             if (ig2DS1(i,jj,k) >= nlon_tiegcm) ig2DS1(i,jj,k) = 
     |          ig2DS1(i,jj,k) - nlon_tiegcm+1
            !
	     found = .false.
             do jjg=1,nlat_tiegcm2-1
              if (fline_s1(i,j,isn)%glat(k) < lat_tie2(jjg).or.
     |           fline_s1(i,j,isn)%glat(k) > lat_tie2(jjg+1)) cycle
              jg2DS1(i,jj,k) = jjg 
              frkj =(fline_s1(i,j,isn)%glat(k)-lat_tie2(jjg))/  
     |  	 (lat_tie2(jjg+1) - lat_tie2(jjg))
            ! jg2DS1(i,jj,k) = jg2DS1(i,jj,k) + 1
	       found = .true.
              exit
             enddo

            wt2DS1(1,i,jj,k) = (1. - frki)*(1. - frkj)
            wt2DS1(2,i,jj,k) =	   frki*(1. - frkj)
            wt2DS1(3,i,jj,k) =	   frki*frkj
            wt2DS1(4,i,jj,k) = (1. - frki)*frkj
        
           enddo ! lat. loop
	   
          ! mapping to S2 points
           do j=1,nmlatS2_h-k+1     ! lat. loop from SPole to NPole every height grid looses 1 point
             if(isn.eq.1) then
	      jj = j
	     else
	      jj = nmlat_T2 - j + 1
	     endif
             xlongi = (fline_s2(i,j,isn)%glon(k) - lon_tie(1))/dellon
             if (xlongi < 0.) xlongi = xlongi + float(nlon_tiegcm)
             ig2DS2(i,jj,k) = xlongi
             frki = xlongi - dble(ig2DS2(i,jj,k))
             ig2DS2(i,jj,k) = ig2DS2(i,jj,k) + 1
             if (ig2DS2(i,jj,k) >= nlon_tiegcm) ig2DS2(i,jj,k) = 
     |          ig2DS2(i,jj,k) - nlon_tiegcm+1
            !
	     found = .false.
             do jjg=1,nlat_tiegcm2-1
              if (fline_s2(i,j,isn)%glat(k) < lat_tie2(jjg).or.
     |           fline_s2(i,j,isn)%glat(k) > lat_tie2(jjg+1)) cycle
              jg2DS2(i,jj,k) = jjg 
              frkj =(fline_s2(i,j,isn)%glat(k)-lat_tie2(jjg))/  
     |  	 (lat_tie2(jjg+1) - lat_tie2(jjg))
            ! jg2DS1(i,jj,k) = jg2DS1(i,jj,k) + 1
	       found = .true.
              exit
             enddo

            wt2DS2(1,i,jj,k) = (1. - frki)*(1. - frkj)
            wt2DS2(2,i,jj,k) =	   frki*(1. - frkj)
            wt2DS2(3,i,jj,k) =	   frki*frkj
            wt2DS2(4,i,jj,k) = (1. - frki)*frkj
        
           enddo ! lat. loop
	   
         enddo ! hemisphere loop
       enddo ! lon. loop
      enddo ! height loop 
!
! do mapping one variable at a time to save memory (Un,Vn,sigH,sigP,je1pg,je2pg)
      icase_max = 4
      if(Jpg) icase_max = 6
      do icase = 1,icase_max
!      
        select case (icase)
	  case(1)  ! Pedersen conductivity
	     val_ext = valp_ext
	  case(2)   ! Hall conductivity
	     val_ext = valh_ext
	  case(3)   ! zonal wind
	     val_ext = valu_ext
	  case(4)   ! meridional wind
	     val_ext = valv_ext 
	  case(5)   ! Je1pg
	     val_ext = valpg1_ext 
	  case(6)   ! Je2pg
	     val_ext = valpg2_ext 
	  case default
	     STOP "select case"
	 end select  
      
! vertical mapping  	
! 1D mapping (looping over all horizontal points)
        call mag1D_hgt(valhgt,val_ext,ighgt,wthgt,nlon_tiegcm,
     |     nlat_tiegcm,nilev_new,nlon_tiegcm,nlat_tiegcm,nhgt_fix) 
!     
! copy array valhgt into array with pole values
! polar value is just the average of all pole-/+1 values
        valhgt2(:,2:nlat_tiegcm+1,:)= valhgt(:,:,:)
!      
        do k=1,nhgt_fix
          valhgt2(:,1,k)  = sum(valhgt(:,1,k))/nlon_tiegcm
          valhgt2(:,nlat_tiegcm+2,k)= sum(valhgt(:,nlat_tiegcm,k))/
     |     nlon_tiegcm
        enddo
!
! horizontal mapping 
        call  geo2mag(valmagS1,valhgt2,ig2DS1,jg2DS1,wt2DS1,nlon_tiegcm,
     |    nlat_tiegcm2,nmlon,nmlat_T1,nhgt_fix,nmlat_h,nmlat_T1)
        call  geo2mag(valmagS2,valhgt2,ig2DS2,jg2DS2,wt2DS2,nlon_tiegcm,
     |    nlat_tiegcm2,nmlon,nmlat_T2,nhgt_fix,nmlatS2_h,nmlat_T2)
!     
! copy into fieldline array
        do i=1,nmlon
           do k=1,nhgt_fix 
      	     do isn = 1,2	 ! southern and northern hemisphere
	       !
      	       do j=1,nmlat_h-k+1  ! S1 points
      	     	  if(isn.eq.1) then
      	     	    jj = j
      	     	  else
                      jj = nmlat_T1 - j + 1
      	     	  endif
                  select case (icase)
	            case(1)  ! Pedersen conductivity
      	               fline_s1(i,j,isn)%sigP(k)= valmagS1(i,jj,k)
 !     	               fline_s1(i,j,isn)%sigP(k)= 
 !    |                     valmagS1(i,nmlat_T1 - j + 1,k) ! test !!!!!!!!!!
	            case(2)   ! Hall conductivity
      	               fline_s1(i,j,isn)%sigH(k)= valmagS1(i,jj,k)
 !     	               fline_s1(i,j,isn)%sigH(k)= 
 !    |                     valmagS1(i,nmlat_T1 - j + 1,k) ! test !!!!!!!!!!
!		       if(isn.eq.1) 
!     |               fline_s1(i,j,isn)%sigH(k)= 0.8*valmagS1(i,jj,k)
	            case(3)   ! zonal wind
      	               fline_s1(i,j,isn)%un(k)= valmagS1(i,jj,k)
!		       if(hgt_fix(k).gt.140e3.and.isn.eq.1) 
!     |               fline_s1(i,j,isn)%un(k)= 1.2*valmagS1(i,jj,k)
	            case(4)   ! meridional wind
      	               fline_s1(i,j,isn)%vn(k)= valmagS1(i,jj,k)
!		       if(hgt_fix(k).gt.140e3.and.isn.eq.1) 
!     |               fline_s1(i,j,isn)%vn(k)= 1.2*valmagS1(i,jj,k)
	            case(5)   ! Je1pg
      	               fline_s1(i,j,isn)%Je1Ion(k)= valmagS1(i,jj,k)
	            case(6)   ! Je2pg
      	               fline_s1(i,j,isn)%Je2Ion(k)= valmagS1(i,jj,k)
	            case default
	               STOP "select case"
	           end select  
      	        enddo    
		!  S2 points 
      	        do j=1,nmlatS2_h-k+1  ! S1 points
      	     	  if(isn.eq.1) then
      	     	    jj = j
      	     	  else
      	     	     jj = nmlat_T2 - j + 1
      	     	  endif
                  select case (icase)
	            case(1)  ! Pedersen conductivity
      	               fline_s2(i,j,isn)%sigP(k)= valmagS2(i,jj,k)
 !     	               fline_s2(i,j,isn)%sigP(k)= 
 !    |                     valmagS2(i,nmlat_T2 - j + 1,k) ! test !!!!!!!!!!
	            case(2)   ! Hall conductivity
      	               fline_s2(i,j,isn)%sigH(k)= valmagS2(i,jj,k)
 !     	               fline_s2(i,j,isn)%sigH(k)= 
  !   |                     valmagS2(i,nmlat_T2 - j + 1,k)
!		       if(isn.eq.1) 
!     |               fline_s2(i,j,isn)%sigH(k)= 0.8*valmagS2(i,jj,k)
	            case(3)   ! zonal wind
      	               fline_s2(i,j,isn)%un(k)= valmagS2(i,jj,k)
!		       if(hgt_fix(k).gt.140e3.and.isn.eq.1) 
!     |               fline_s2(i,j,isn)%un(k)= 1.2*valmagS2(i,jj,k)
	            case(4)   ! meridional wind
      	               fline_s2(i,j,isn)%vn(k)= valmagS2(i,jj,k)
!		       if(hgt_fix(k).gt.140e3.and.isn.eq.1) 
!     |               fline_s2(i,j,isn)%vn(k)= 1.2*valmagS2(i,jj,k)
	            case(5)   ! Je1pg
      	               fline_s2(i,j,isn)%Je1Ion(k)= valmagS2(i,jj,k)
	            case(6)   ! Je2pg
      	               fline_s2(i,j,isn)%Je2Ion(k)= valmagS2(i,jj,k)
	            case default
	               STOP "select case"
	           end select  
      	        enddo   ! end S2 lat. loop
		 
      	    enddo   ! end hemisphere loop 
      	  enddo   ! end height loop 
        enddo  ! end longitude loop
! 	
      enddo ! loop over all fields 

! test with symmetric conductuvities am_5/2025	      	      
!      do i=1,nmlon
!      	     do j=1,nmlat_h  ! S1 points  isn=1 is SH, isn=2 is NH
!      		fline_s1(i,j,2)%sigP(:) = fline_s1(i,j,1)%sigP(:)
!     		 fline_s1(i,j,2)%sigH(:) = fline_s1(i,j,1)%sigH(:)
!      	     enddo   ! end S1 lat. loop
!      	     do j=1,nmlatS2_h
!      		fline_s2(i,j,2)%sigP(:) = fline_s2(i,j,1)%sigP(:)
!      		fline_s2(i,j,2)%sigH(:) = fline_s2(i,j,1)%sigH(:)
!      	     enddo   ! end S1 lat. loop
!        enddo  ! end longitude loop
!
! calculate conductances for FAC correction	      	      
      do i=1,nmlon
      	 do isn = 1,2	 ! southern and northern hemisphere
	     !
      	     do j=1,nmlat_h  ! S1 points
	      sumP = 0.
	      sumH = 0.
	      nmax = fline_s1(i,j,isn)%npts ! maximum of points on fieldlinep
	      do k=1,nmax-1
	       sumP = sumP + fline_s1(i,j,isn)%sigP(k)*2*abs
     |      (fline_s1(i,j,isn)%Vmp(k+1)-fline_s1(i,j,isn)%Vmp(k))/
     |	         (fline_s1(i,j,isn)%Bmag(k+1)+fline_s1(i,j,isn)%Bmag(k))
	       sumH = sumH + fline_s1(i,j,isn)%sigH(k)*2*abs
     |      (fline_s1(i,j,isn)%Vmp(k+1)-fline_s1(i,j,isn)%Vmp(k))/ 
     |	         (fline_s1(i,j,isn)%Bmag(k+1)+fline_s1(i,j,isn)%Bmag(k))
	      enddo
	      fline_s1(i,j,isn)%zigP = sumP
	      fline_s1(i,j,isn)%zigH = sumH
      	    enddo   ! end hemisphere loop
	    ! 
      	    do j=1,nmlatS2_h  ! S2 points
	      sumP = 0.
	      sumH = 0.
	      nmax = fline_s2(i,j,isn)%npts ! maximum of points on fieldlinep
	      do k=1,nmax-1
	       sumP = sumP + fline_s2(i,j,isn)%sigP(k)*2*abs
     |      (fline_s2(i,j,isn)%Vmp(k+1)-fline_s2(i,j,isn)%Vmp(k))/ 
     |	         (fline_s2(i,j,isn)%Bmag(k+1)+fline_s2(i,j,isn)%Bmag(k))
	       sumH = sumH + fline_s2(i,j,isn)%sigH(k)*2*abs
     |      (fline_s2(i,j,isn)%Vmp(k+1)-fline_s2(i,j,isn)%Vmp(k))/ 
     |	         (fline_s2(i,j,isn)%Bmag(k+1)+fline_s2(i,j,isn)%Bmag(k))
	      enddo
	      fline_s2(i,j,isn)%zigP = sumP
	      fline_s2(i,j,isn)%zigH = sumH
      	    enddo   ! end hemisphere loop 
      	  enddo   ! end height loop 
        enddo  ! end longitude loop		  
!     
!      k=1
!      do i=1,nmlon
!	do j=1,nmlat_h-k+1
!	  do isn = 1,2         ! southern and northern hemisphere
!	    if(isn.eq.1) then
!	     jj = j
!	   else
!	     jj = nmlat_T1 - j + 1
!	   endif
!	    write(33,'(6(x,e15.8))')  fline_s1(i,j,isn)%glon(k),
!     |        fline_s1(i,j,isn)%glat(k),valmagS1(i,jj,k),
!     |        valhgt2(ig2DS1(i,jj,k),jg2DS1(i,jj,k),k),
!     |        lon_tie(ig2DS1(i,jj,k)),
!     |        lat_tie2(jg2DS1(i,jj,k))
!	  enddo    
!	enddo	 
!      enddo  
!      k=1
!      do i=1,nlon_tiegcm
!        do j=1,nlat_tiegcm2
!            write(44,'(3(x,e15.8))')  lon_tie(i),
!     |        lat_tie2(j),valhgt2(i,j,k)
!        enddo    
!      enddo    
!
! deallocate arrays
      deallocate(val_ext,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating val_ext')
      deallocate(valz_ext,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating valz_ext')
      deallocate(valu_ext,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating valu_ext')
      deallocate(valv_ext,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating valv_ext')
      deallocate(valP_ext,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating valP_ext')
      deallocate(valH_ext,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating valH_ext')
      !	
      if(Jpg) then
        deallocate(valpg1_ext,stat=istat)
        if (istat /= 0) call shutdown('Error deallocating valpg1_ext')
        deallocate(valpg2_ext,stat=istat)
        if (istat /= 0) call shutdown('Error deallocating valpg2_ext')
      endif
      !
      deallocate(ighgt,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating ighgt')
      deallocate(ig2DS1,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating ig2DS1')
      deallocate(ig2DS2,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating ig2DS2')
      deallocate(jg2DS1,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating jg2DS1')
      deallocate(jg2DS2,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating jg2DS2')
      deallocate(wthgt,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating wthgt')
      deallocate(wt2DS1,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating wt2DS1')
      deallocate(wt2DS2,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating wt2DS2')
      deallocate(valhgt,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating valhgt')
      deallocate(valmagS1,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating valmagS1')
      deallocate(valmagS2,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating valmagS2')
      deallocate(valhgt2,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating valhgt2')
      deallocate(lat_tie2,stat=istat)
      if (istat /= 0) call shutdown('Error deallocating lat_tie2')
!    
      end subroutine map_tiegcm 

!-----------------------------------------------------------------------
      subroutine mag1D_lon(f_out,f_in,long,wght,nlon_in,nlat_in, 
     |  nlon_out,nlat_out)
!
! Transform field fgeo on geographic grid to geomagnetic grid using
!   indices long,latg and weights wght. 
!
! Args:
      integer,intent(in) :: nlon_in,nlat_in,nlon_out,nlat_out
      integer,dimension(nlon_out),intent(in) :: long
      real,intent(in) :: f_in(nlon_in,nlat_in), wght(2,nlon_out)
      real,intent(out) :: f_out(nlon_out,nlat_out)
!
! Local:
      integer :: i,j,lat,lon0,lon1,lat0,lat1
!
        do i=1,nlon_out
	  lon0 = long(i)
	  lon1 = long(i) + 1
	  if (lon0 == 0) lon0 = nlon_in  	! no cyclic point
	  if (lon1 == nlon_in+1) lon0 = 1	! no cyclic point
	  do j=1,nlat_in
            f_out(i,j) =  f_in(lon0,j)*wght(1,i)+ 
     |	      f_in(lon1,j)*wght(2,i)
!             !write(33,'(2i4,5(x,e19.11))') i,j,f_in(lon0,j),wght(1,i),
!     |	      f_in(lon1,j),wght(2,i),f_out(i,j)
           enddo
        enddo	
!	
      end subroutine mag1D_lon  
!-----------------------------------------------------------------------
      subroutine mag1D_lat(f_out,f_in,long,wght,nlon_in,nlat_in, 
     |  nlon_out,nlat_out)
!
! Transform field fgeo on geographic grid to geomagnetic grid using
!   indices long,latg and weights wght. 
!
! Args:
      integer,intent(in) :: nlon_in,nlat_in,nlon_out,nlat_out
      integer,intent(in) :: long(nlat_out)
      real,intent(in)    :: f_in(nlon_in,nlat_in), wght(2,nlat_out)
      real,intent(out)   :: f_out(nlon_out,nlat_out)
!
! Local:
      integer :: i,j,lat,lon0,lon1,lat0,lat1
!
        do i=1,nlat_out
	  lon0 = long(i)
	  lon1 = long(i) + 1
	  if (lon0 == 0) STOP "mag1D_lat"
	  if (lon1 == nlat_in+1) STOP "mag1D_lat"
	  do j=1,nlon_out
            f_out(j,i) =  f_in(j,lon0)*wght(1,i)+ 
     |	     f_in(j,lon1)*wght(2,i) 
          enddo
        enddo	
!	
      end subroutine mag1D_lat  
!-----------------------------------------------------------------------
      subroutine mag1D_hgt(f_out,f_in,hgtg,wght,nlon_in,nlat_in,nhgt_in, 
     |  nlon_out,nlat_out,nhgt_out)
!
! Transform field fgeo on geographic grid to geomagnetic grid using
!   indices long,latg and weights wght. 
!
! Args:
      integer,intent(in) :: nlon_in,nlat_in,nlon_out,
     |   nlat_out,nhgt_in,nhgt_out
      integer,intent(in) :: hgtg(nlon_in,nlat_in,nhgt_out)
      real,intent(in)    :: f_in(nlon_in,nlat_in,nhgt_in), 
     |    wght(2,nlon_out,nlat_out,nhgt_out)
      real,intent(out)   :: f_out(nlon_out,nlat_out,nhgt_out)
!
! Local:
      integer :: i,j,k,hgt0,hgt1
!
        do i=1,nlon_out
         do j=1,nlat_out
          do k=1,nhgt_out
	   hgt0 = hgtg(i,j,k)
	   hgt1 = hgtg(i,j,k) + 1
	   if (hgt0 == 0) STOP "stop in mag1D_hgt"
	   if (hgt1 == nhgt_in+1) STOP "stop in mag1D_hgt"
           f_out(i,j,k) =  f_in(i,j,hgt0)*wght(1,i,j,k)+ 
     |	     f_in(i,j,hgt1)*wght(2,i,j,k)
          enddo	
         enddo	
        enddo	
!	
      end subroutine mag1D_hgt
!-----------------------------------------------------------------------
      subroutine geo2mag(fmag,fgeo,long,latg,wght,nlon_geo,nlat_geo,
     |  nlon_mag,nlat_mag,nhgt,nmlat_half,nmlat_total)
!
! Transform field fgeo on geographic grid to geomagnetic grid using
!   indices long,latg and weights wght. Return field fmag on magnetic
!   grid.
!
! Args:
      integer,intent(in) :: nlon_geo,nlat_geo,nlon_mag,nlat_mag,nhgt,
     |   nmlat_half,nmlat_total
      integer,dimension(nlon_mag,nlat_mag,nhgt),intent(in) :: long,latg
      real,intent(in) :: fgeo(nlon_geo,nlat_geo,nhgt),
     |   wght(4,nlon_mag,nlat_mag,nhgt)
      real,intent(out) :: fmag(nlon_mag,nlat_mag,nhgt)
!
! Local:
      integer :: i,j,k,jj,isn
!
      do k=1,nhgt
        do i=1,nlon_mag
          do j=1,nmlat_half-k+1  ! every height losses one grid point in each hemisphere
	   do isn = 1,2         ! southern and northern hemisphere
            if(isn.eq.1) then
	      jj = j
	    else
	      jj = nmlat_total - j + 1
	    endif
	    if(latg(i,jj,k)+1.gt.nlat_geo) then
	      write(6,*) 'latg > nlat',i,jj,k,latg(i,jj,k),nlat_geo
	      STOP "stop in geo2mag lat.index"
	    elseif(latg(i,jj,k).lt.1) then
	      write(6,*) 'latg < 1',i,jj,k,latg(i,jj,k)
	      STOP "stop in geo2mag lat.index"
	    else
            fmag(i,jj,k) =
     |        fgeo(long(i,jj,k)  ,latg(i,jj,k),k)*wght(1,i,jj,k)+
     |        fgeo(long(i,jj,k)+1,latg(i,jj,k),k)*wght(2,i,jj,k)+
     |        fgeo(long(i,jj,k)+1,latg(i,jj,k)+1,k)*wght(3,i,jj,k)+
     |       fgeo(long(i,jj,k)  ,latg(i,jj,k)+1,k)*wght(4,i,jj,k)
!       if (iprint > 0) write(6,"('geo2mag: i=',i3,' lat=',i3,' long=',
!    |    i3,' latg=',i3,' wght=',4e12.4,' fgeo=',e12.4,' fmag=',
!    |    e12.4)") i,lat,long(i,lat),latg(i,lat),wght(:,i,lat),
!    |    fgeo(long(i,lat),latg(i,lat)),fmag(i,1)
             !if(k.eq.1) write(44,'(2i4,1(x,e15.8))') i,jj,fmag(i,jj,k)
	    endif
            enddo
          enddo
        enddo
      enddo
      end subroutine geo2mag
!--------------------------------------------------------------------------
      subroutine check_err(status,name)
!
#include "netcdf.inc"
!
      integer,intent(in) :: status
      character(len=*),intent(in) :: name
!
      write(6,*) 'error in ',name
      write(6,*) NF_STRERROR(status)
      write(6,*) ' '
!
      stop
! 
      end subroutine check_err
!--------------------------------------------------------------------------  
      end module readtiegcm_module
