  subroutine setup_test
  
  use params_module,only:nmlon, &
     nmlat_h,nmlatS2_h,r0
  use fieldline_s_module,only: fieldline_s1,fline_s1, &
     fieldline_s2,fline_s2
!  
  implicit none
  
  integer :: isn,i,j,k,nmax
  real :: ed1,ed2,ue1,ue2,dpotdphi,dpotdlam, &
    coslam,sinlam,cosphi,sinphi,sinIm

! Ed1 = -1/Ro/cos(lam_m)*dPhi/dphi_m 
! Ed2 = 1/Ro/sinIm *dPhi/dlam_m  
!
! with Phi = cos^2(lam_m)*sin(phi_m)
!    dPhi/dphi_m = cos^2(lam_m)*cos(phi_m)
!    dPhi/dlam_m = -2*cos(lam_m)*sin(lam_m)*sin(phi_m)
!  
! ue2 = -Ed1/Be3  from setting Je1 and Je2 to zero for an aligned dipole field
! ue1 = Ed2/Be3 
! 

  do isn = 1,2 ! loop over both hemisphere
    do i=1,nmlon ! loop over all longitudes  
    
      do j=1,nmlatS2_h,1     ! loop over all latitudes in one hemisphere 
	nmax = fline_s2(i,j,isn)%npts ! maximum of points on fieldline
				     ! use it to be sure that right art of array is used
        coslam = cos(fline_s2(i,j,isn)%mlat_m)
        sinlam = sin(fline_s2(i,j,isn)%mlat_m)
        cosphi = cos(fline_s2(i,j,isn)%mlon_m)
        sinphi = sin(fline_s2(i,j,isn)%mlon_m)
	dpotdphi = coslam**2*cosphi
        dpotdlam =-2*coslam*sinlam*sinphi
	!
	sinIm = 2.*sinlam/sqrt(4.-3.*coslam**2)
        ed1      = -dpotdphi/r0/coslam
	ed2      =  dpotdlam/r0/sinIm 
 
        do k=1,nmax
     
          fline_s2(i,j,isn)%un(k)=  ed2/fline_s2(i,j,isn)%be3(k) !ue1
          fline_s2(i,j,isn)%vn(k)= -ed1/fline_s2(i,j,isn)%be3(k) !ue2
!	  write(77,'(5(x,e18.8))') fline_s2(i,j,isn)%mlon_m,fline_s2(i,j,isn)%mlat_m, &
!	   fline_s2(i,j,isn)%hgt_pt(k),fline_s2(i,j,isn)%un(k),fline_s2(i,j,isn)%vn(k)

        end do ! end height loop
      end do ! end latitude loop
      
      do j=2,nmlat_h,1     ! loop over all latitudes in one hemisphere 
	nmax = fline_s1(i,j,isn)%npts ! maximum of points on fieldline
				     ! use it to be sure that right art of array is used
        coslam = cos(fline_s1(i,j,isn)%mlat_m)
        sinlam = sin(fline_s1(i,j,isn)%mlat_m)
        cosphi = cos(fline_s1(i,j,isn)%mlon_m)
        sinphi = sin(fline_s1(i,j,isn)%mlon_m)
	dpotdphi = coslam**2*cosphi
        dpotdlam =-2.*coslam*sinlam*sinphi
	!
	if(j == nmlat_h) then
	  ! sinIm =0 at magnetic equator -> L'Hospital rule
	  ! dPhi/dlam_m/sinIm -> sin(phi_m)/cos(lam_m)[2sin^2(lam_m)-1]/[4-3*cos^2(lam_m)]^1.5
	   ed2   = sinphi/coslam/r0*(2*sinlam**2-1.)/(4.-3.*coslam**2)**1.5
	else
	   sinIm = 2.*sinlam/sqrt(4.-3.*coslam**2)
	   ed2   = dpotdlam/r0/sinIm 
	endif
	ed1      = -dpotdphi/r0/coslam
	
        do k=1,nmax
     
          fline_s1(i,j,isn)%un(k)=  ed2/fline_s1(i,j,isn)%be3(k) !ue1
          fline_s1(i,j,isn)%vn(k)= -ed1/fline_s1(i,j,isn)%be3(k) !ue2
!	  write(66,'(5(x,e18.8))') fline_s1(i,j,isn)%mlon_m,fline_s1(i,j,isn)%mlat_m, &
!	   fline_s1(i,j,isn)%hgt_pt(k),fline_s1(i,j,isn)%un(k),fline_s1(i,j,isn)%vn(k)

        end do ! end height loop
      end do ! end latitude loop
      !
      ! set polar winds to zero 
      fline_s1(i,1,isn)%un(:)=  0. !ue1
      fline_s1(i,1,isn)%vn(:)=  0. !ue2
    end do
  end do
!	
  end subroutine setup_test
!------------------------------------------------------------------------------------  
  subroutine setup_test3
  
  use params_module,only:nmlon, &
     nmlat_h,nmlatS2_h,r0,pi
  use fieldline_s_module,only: fieldline_s1,fline_s1, &
     fieldline_s2,fline_s2
  use fieldline_p_module,only: fieldline_p,fline_p
!  
  implicit none
  
  integer :: isn,i,j,k,nmax
  real :: ed1,ed2,ue1,ue2,dpotdphi,dpotdlam, &
    coslam,sinlam,cosphi,sinphi,sinIm,fac1,lam
  real :: po18 , po2,po16,pot 

! Ed1 = -1/Ro/cos(lam_m)*dPhi/dphi_m 
! Ed2 = 1/Ro/sinIm *dPhi/dlam_m  
!
! with Phi = cos^2(F1)*sin(phi_m) for |lam_m| > Pi/18
!          = 0                    for |lam_m| <= Pi/18
! test potential should be zero between |lam_m| <= Pi/18
! with F1 = 2*{|lam_m|+|lam_m|/8-Pi/16}+Pi/2
!
!    dPhi/dphi_m =cos^2(F1)*cos(phi_m)  for |lam_m| > Pi/18
!                = 0                    for |lam_m| <= Pi/18
!    dPhi/dlam_m = 0   for |lam_m| <= Pi/18
!                = 2*cos(F1)*sin(F1)*F2         for lam_m > Pi/18
!                = 2*cos(F1)*sin(F1)*(-F2)      for lam_m < -Pi/18
! with F1 = 2*{|lam_m|+|lam_m|/8-Pi/16}+Pi/2 (same as above)
!      F2 = 9/4
!  
! ue2 = -Ed1/Be3  from setting Je1 and Je2 to zero for an aligned dipole field
! ue1 = Ed2/Be3 
! 
  po18 = pi/18
  po16 = pi/16 
  po2  = pi/2   
!       
  do isn = 1,2  ! loop over hemisphere
    do j=1,nmlat_h  ! loop over latitudes (pole to equator)
      do i=1,nmlon ! loop over longitude
        if( abs(fline_p(i,j,isn)%mlat_m).le.po18) then
          pot= 0.
	else
	   lam    = fline_p(i,j,isn)%mlat_m
           cosphi = cos(fline_p(i,j,isn)%mlon_m)
           sinphi = sin(fline_p(i,j,isn)%mlon_m)
	   fac1   = 2*(abs(lam)+abs(lam)/8-po16)+po2
	   pot    = cos(fac1)*cos(fac1)*sinphi
	endif
	fline_p(i,j,isn)%pot_test = pot
      enddo
    enddo
  enddo  
! end am 1/2015 testing
!
  do isn = 1,2 ! loop over both hemisphere
    do i=1,nmlon ! loop over all longitudes  
    
      do j=1,nmlatS2_h,1     ! loop over all latitudes in one hemisphere
	nmax = fline_s2(i,j,isn)%npts ! maximum of points on fieldline
				     ! use it to be sure that right art of array is used
        if( abs(fline_s2(i,j,isn)%mlat_m).le.po18) then
          fline_s2(i,j,isn)%un(:)= 0.
          fline_s2(i,j,isn)%vn(:)= 0.
	else
	   lam = fline_s2(i,j,isn)%mlat_m
           cosphi = cos(fline_s2(i,j,isn)%mlon_m)
           sinphi = sin(fline_s2(i,j,isn)%mlon_m)
           coslam = cos(fline_s2(i,j,isn)%mlat_m)
           sinlam = sin(fline_s2(i,j,isn)%mlat_m)
	   fac1 = 2*(abs(lam)+abs(lam)/8-po16)+po2
	   dpotdphi = cos(fac1)*cos(fac1)*cosphi
	   if(lam.gt.po18)then
	     dpotdlam = -2*cos(fac1)*sin(fac1)*9./4.*sinphi
	   elseif(lam.lt.po18) then
	     dpotdlam =  2*cos(fac1)*sin(fac1)*9./4.*sinphi	     
	   else
	     write(6,*) 'in setup_test3 and code should not stop!'
	     exit
	   endif
	    !
	    sinIm = 2.*sinlam/sqrt(4.-3.*coslam**2)
            ed1   = -dpotdphi/r0/coslam
	    ed2   =  dpotdlam/r0/sinIm  
            do k=1,nmax
     	 
              fline_s2(i,j,isn)%un(k)=  ed2/fline_s2(i,j,isn)%be3(k) !ue1
              fline_s2(i,j,isn)%vn(k)= -ed1/fline_s2(i,j,isn)%be3(k) !ue2
!	      write(77,'(5(x,e18.8))') fline_s2(i,j,isn)%mlon_m,fline_s2(i,j,isn)%mlat_m, &
!	       fline_s2(i,j,isn)%hgt_pt(k),fline_s2(i,j,isn)%un(k),fline_s2(i,j,isn)%vn(k)

            end do ! end height loop
	 endif ! end lam_m 
      end do ! end latitude loop
      
      do j=2,nmlat_h,1     ! loop over all latitudes in one hemisphere 
	nmax = fline_s1(i,j,isn)%npts ! maximum of points on fieldline
				     ! use it to be sure that right art of array is used
        if( abs(fline_s1(i,j,isn)%mlat_m).le.po18) then
          fline_s1(i,j,isn)%un(:)= 0.
          fline_s1(i,j,isn)%vn(:)= 0.
	else
	   lam = fline_s1(i,j,isn)%mlat_m
           cosphi = cos(fline_s1(i,j,isn)%mlon_m)
           sinphi = sin(fline_s1(i,j,isn)%mlon_m)
           coslam = cos(fline_s1(i,j,isn)%mlat_m)
           sinlam = sin(fline_s1(i,j,isn)%mlat_m)
	   fac1 = 2*(abs(lam)+abs(lam)/8-po16)+po2
	   dpotdphi = cos(fac1)*cos(fac1)*cosphi
	   if(lam.gt.po18)then
	     dpotdlam = -2.*cos(fac1)*sin(fac1)*9./4.*sinphi
	   elseif(lam.lt.po18) then
	     dpotdlam =  2*cos(fac1)*sin(fac1)*9./4.*sinphi	     
	   else
	     write(6,*) 'in setup_test3 and code should not stop!'
	     exit
	   endif
	   pot = cos(fac1)*cos(fac1)*sinphi
	!   write(66,'(5(x,e18.8))') fline_s1(i,j,isn)%mlon_m,fline_s1(i,j,isn)%mlat_m, &
	!      pot,dpotdphi,dpotdlam 
	!
	   if(j == nmlat_h) then
	     ! sinIm =0 at magnetic equator -> L'Hospital rule
	     ! dPhi/dlam_m/sinIm -> sin(phi_m)/cos(lam_m)[2sin^2(lam_m)-1]/[4-3*cos^2(lam_m)]^1.5
	      ed2   = sinphi/coslam/r0*(2*sinlam**2-1.)/(4.-3.*coslam**2)**1.5
	   else
	      sinIm = 2.*sinlam/sqrt(4.-3.*coslam**2)
	      ed2   = dpotdlam/r0/sinIm 
	   endif
	   ed1 = -dpotdphi/r0/coslam
	   
           do k=1,nmax
     
             fline_s1(i,j,isn)%un(k)=  ed2/fline_s1(i,j,isn)%be3(k) !ue1
             fline_s1(i,j,isn)%vn(k)= -ed1/fline_s1(i,j,isn)%be3(k) !ue2
!	     write(66,'(5(x,e18.8))') fline_s1(i,j,isn)%mlon_m,fline_s1(i,j,isn)%mlat_m, &
!	      fline_s1(i,j,isn)%hgt_pt(k),fline_s1(i,j,isn)%un(k),fline_s1(i,j,isn)%vn(k)

           end do ! end height loop
	endif
      end do ! end latitude loop
      !
      ! set polar winds to zero 
      fline_s1(i,1,isn)%un(:)=  0. !ue1
      fline_s1(i,1,isn)%vn(:)=  0. !ue2
    end do
  end do
!	
  end subroutine setup_test3
!------------------------------------------------------------------------------------  
  subroutine setup_test4
  
  use params_module,only:nmlon, &
     nmlat_h,nmlatS2_h,r0,pi
  use fieldline_s_module,only: fieldline_s1,fline_s1, &
     fieldline_s2,fline_s2
  use fieldline_p_module,only: fieldline_p,fline_p
!  
  implicit none
  
  integer :: isn,i,j,k,nmax
  real :: ed1,ed2,ue1,ue2,dpotdphi,dpotdlam, &
    coslam,sinlam,cosphi,sinphi,sinIm,fac1,lam
  real :: po2,pot 

! Ed1 = -1/Ro/cos(lam_m)*dPhi/dphi_m 
! Ed2 = 1/Ro/sinIm *dPhi/dlam_m  
!
! with Phi = cos^2(F1)*sin(phi_m) 
! test potential should be zero at equator
! with F1 = 2|lam_m|+Pi/2
!
!    dPhi/dphi_m =cos^2(F1)*cos(phi_m)  
!    dPhi/dlam_m =  2*cos(F1)*sin(F1)*F2         for lam_m >= 0
!                = 2*cos(F1)*sin(F1)*(-F2)       for lam_m < 0
! with F1 = 2|lam_m|+Pi/2 (same as above)
!      F2 = 2
!  
! ue2 = -Ed1/Be3  from setting Je1 and Je2 to zero for an aligned dipole field
! ue1 = Ed2/Be3 
! 
  po2  = pi/2   
!       
  do isn = 1,2  ! loop over hemisphere
    do j=1,nmlat_h  ! loop over latitudes (pole to equator)
      do i=1,nmlon ! loop over longitude
	   lam    = fline_p(i,j,isn)%mlat_m
           cosphi = cos(fline_p(i,j,isn)%mlon_m)
           sinphi = sin(fline_p(i,j,isn)%mlon_m)
	   fac1   = 2*abs(lam)+po2
	   pot    = cos(fac1)*cos(fac1)*sinphi
	
	   fline_p(i,j,isn)%pot_test = pot
      enddo
    enddo
  enddo  
! end am 1/2015 testing
!
  do isn = 1,2 ! loop over both hemisphere
    do i=1,nmlon ! loop over all longitudes  
    
      do j=1,nmlatS2_h,1     ! loop over all latitudes in one hemisphere
	nmax = fline_s2(i,j,isn)%npts ! maximum of points on fieldline
				     ! use it to be sure that right art of array is used
	   lam = fline_s2(i,j,isn)%mlat_m
           cosphi = cos(fline_s2(i,j,isn)%mlon_m)
           sinphi = sin(fline_s2(i,j,isn)%mlon_m)
           coslam = cos(fline_s2(i,j,isn)%mlat_m)
           sinlam = sin(fline_s2(i,j,isn)%mlat_m)
	   fac1 = 2*abs(lam)+po2
	   dpotdphi = cos(fac1)*cos(fac1)*cosphi
	   if(lam.ge.0)then
	     dpotdlam = -2*cos(fac1)*sin(fac1)*2*sinphi
	   elseif(lam.lt.0) then
	     dpotdlam =  2*cos(fac1)*sin(fac1)*2*sinphi	     
	   else
	     write(6,*) 'in setup_test4 and code should not stop!'
	     exit
	   endif
	    !
	    sinIm = 2.*sinlam/sqrt(4.-3.*coslam**2)
            ed1   = -dpotdphi/r0/coslam
	    ed2   =  dpotdlam/r0/sinIm  
            do k=1,nmax
     	 
              fline_s2(i,j,isn)%un(k)=  ed2/fline_s2(i,j,isn)%be3(k) !ue1
              fline_s2(i,j,isn)%vn(k)= -ed1/fline_s2(i,j,isn)%be3(k) !ue2
!	      write(77,'(5(x,e18.8))') fline_s2(i,j,isn)%mlon_m,fline_s2(i,j,isn)%mlat_m, &
!	       fline_s2(i,j,isn)%hgt_pt(k),fline_s2(i,j,isn)%un(k),fline_s2(i,j,isn)%vn(k)

            end do ! end height loop
      end do ! end latitude loop
      
      do j=2,nmlat_h,1     ! loop over all latitudes in one hemisphere 
	nmax = fline_s1(i,j,isn)%npts ! maximum of points on fieldline
				     ! use it to be sure that right art of array is used
	   lam = fline_s1(i,j,isn)%mlat_m
           cosphi = cos(fline_s1(i,j,isn)%mlon_m)
           sinphi = sin(fline_s1(i,j,isn)%mlon_m)
           coslam = cos(fline_s1(i,j,isn)%mlat_m)
           sinlam = sin(fline_s1(i,j,isn)%mlat_m)
	   fac1 = 2*abs(lam)+po2
	   dpotdphi = cos(fac1)*cos(fac1)*cosphi
	   if(lam.ge.0)then
	     dpotdlam = -2.*cos(fac1)*sin(fac1)*2*sinphi
	   elseif(lam.lt.0) then
	     dpotdlam =  2*cos(fac1)*sin(fac1)*2*sinphi	     
	   else
	     write(6,*) 'in setup_test3 and code should not stop!'
	     exit
	   endif
	   pot = cos(fac1)*cos(fac1)*sinphi
	   write(66,'(5(x,e18.8))') fline_s1(i,j,isn)%mlon_m,fline_s1(i,j,isn)%mlat_m, &
	      pot,dpotdphi,dpotdlam 
	!
	   if(j == nmlat_h) then
	     ! sinIm =0 at magnetic equator -> L'Hospital rule
	     ! dPhi/dlam_m/sinIm -> sin(phi_m)/cos(lam_m)[2sin^2(lam_m)-1]/[4-3*cos^2(lam_m)]^1.5
	      ed2   = sinphi/coslam/r0*(2*sinlam**2-1.)/(4.-3.*coslam**2)**1.5
	   else
	      sinIm = 2.*sinlam/sqrt(4.-3.*coslam**2)
	      ed2   = dpotdlam/r0/sinIm 
	   endif
	   ed1 = -dpotdphi/r0/coslam
	   
           do k=1,nmax
     
             fline_s1(i,j,isn)%un(k)=  ed2/fline_s1(i,j,isn)%be3(k) !ue1
             fline_s1(i,j,isn)%vn(k)= -ed1/fline_s1(i,j,isn)%be3(k) !ue2
!	     write(66,'(5(x,e18.8))') fline_s1(i,j,isn)%mlon_m,fline_s1(i,j,isn)%mlat_m, &
!	      fline_s1(i,j,isn)%hgt_pt(k),fline_s1(i,j,isn)%un(k),fline_s1(i,j,isn)%vn(k)

           end do ! end height loop
      end do ! end latitude loop
      !
      ! set polar winds to zero 
      fline_s1(i,1,isn)%un(:)=  0. !ue1
      fline_s1(i,1,isn)%vn(:)=  0. !ue2
    end do
  end do
!	
  end subroutine setup_test4
!-----------------------------------------------------------------------------  
  subroutine setup_test2
! zonal wind 1 m/s
! meridional wind 0 m/s
! Hall conductivity 0S
! Pedersen conductivity 10 S

  
  use params_module,only:nmlon, &
     nmlat_h,nmlatS2_h,r0
  use fieldline_s_module,only: fieldline_s1,fline_s1, &
     fieldline_s2,fline_s2
!  
  implicit none
  
  integer :: isn,i,j,k,nmax
  real :: ed1,ed2,ue1,ue2,dpotdphi,dpotdlam, &
    coslam,sinlam,cosphi,sinphi
! 
  do isn = 1,2 ! loop over both hemisphere
    do i=1,nmlon ! loop over all longitudes  
    
      do j=1,nmlatS2_h,1     ! loop over all latitudes in one hemisphere 
	nmax = fline_s2(i,j,isn)%npts ! maximum of points on fieldline
        do k=1,nmax
     
          fline_s2(i,j,isn)%un(k)= 1.
          fline_s2(i,j,isn)%vn(k)= 0.
          fline_s2(i,j,isn)%sigP(k)= 10.
          fline_s2(i,j,isn)%sigH(k)= 0.
        end do ! end height loop
      end do ! end latitude loop
      
      do j=2,nmlat_h,1     ! loop over all latitudes in one hemisphere 
	nmax = fline_s1(i,j,isn)%npts ! maximum of points on fieldline
				     ! use it to be sure that right art of array is used
        do k=1,nmax
     
          fline_s1(i,j,isn)%un(k)= 1. 
          fline_s1(i,j,isn)%vn(k)= 0. 
          fline_s1(i,j,isn)%sigP(k)= 10.
          fline_s1(i,j,isn)%sigH(k)= 0.
        end do ! end height loop
      end do ! end latitude loop
      fline_s1(i,1,isn)%un(:)=  0. 
      fline_s1(i,1,isn)%vn(:)=  0. 
      fline_s1(i,1,isn)%sigP(k)= 10.
      fline_s1(i,1,isn)%sigH(k)= 0.
    end do
  end do
!	
  end subroutine setup_test2
!------------------------------------------------------------------------------------  
  subroutine setup_test5  ! Asymmetric potential confined to polar caps 
  
  use params_module,only:nmlon, &
     nmlat_h,nmlatS2_h,r0,pi
  use fieldline_s_module,only: fieldline_s1,fline_s1, &
     fieldline_s2,fline_s2
  use fieldline_p_module,only: fieldline_p,fline_p
!  
  implicit none
  
  integer :: isn,i,j,k,nmax
  real :: ed1,ed2,ue1,ue2,dpotdphi,dpotdlam, &
    coslam,sinlam,cosphi,sinphi,sinIm,fac1,lam
  real :: po2,pot 

! Ed1 = -1/Ro/cos(lam_m)*dPhi/dphi_m 
! Ed2 = 1/Ro/sinIm *dPhi/dlam_m  
!
! with Phi = cos^2(F1)*sin(phi_m) 
! test potential should be zero at equator
! with F1 = 2|lam_m|+Pi/2
!
!    dPhi/dphi_m =cos^2(F1)*cos(phi_m)  
!    dPhi/dlam_m =  2*cos(F1)*sin(F1)*F2         for lam_m >= 0
!                = 2*cos(F1)*sin(F1)*(-F2)       for lam_m < 0
! with F1 = 2|lam_m|+Pi/2 (same as above)
!      F2 = 2
!  
! ue2 = -Ed1/Be3  from setting Je1 and Je2 to zero for an aligned dipole field
! ue1 = Ed2/Be3 
! 
  po2  = pi/2   
!       
  do isn = 1,2  ! loop over hemisphere
    do j=1,nmlat_h  ! loop over latitudes (pole to equator)
      do i=1,nmlon ! loop over longitude
	   lam    = fline_p(i,j,isn)%mlat_m
           cosphi = cos(fline_p(i,j,isn)%mlon_m)
           sinphi = sin(fline_p(i,j,isn)%mlon_m)
! Construct antisymmetric potential varying smoothly from -1 at S pole to 0 at -78.46 mlat; 
!   from 1 at N pole to 0 at 78.46 mlat, zero at low and middle latitudes.
	   pot = 1. - 25.*(cos(lam))**2
	   if (pot.gt.0.) then
	     pot = pot*pot
	   else
	     pot = 0.
	   endif
	   if (lam.lt.0.) pot = -pot
	   fline_p(i,j,isn)%pot_test = pot
      enddo
    enddo
  enddo  
!
  do isn = 1,2 ! loop over both hemisphere
    do i=1,nmlon ! loop over all longitudes  
    
      do j=1,nmlatS2_h,1     ! loop over all latitudes in one hemisphere
	nmax = fline_s2(i,j,isn)%npts ! maximum of points on fieldline
				     ! use it to be sure that right art of array is used
	   lam = fline_s2(i,j,isn)%mlat_m
!           cosphi = cos(fline_s2(i,j,isn)%mlon_m)
!           sinphi = sin(fline_s2(i,j,isn)%mlon_m)
           coslam = cos(fline_s2(i,j,isn)%mlat_m)
           sinlam = sin(fline_s2(i,j,isn)%mlat_m)
	   dpotdphi = 0.
	   if(lam.gt.0..and.coslam.lt..2)then
	     dpotdlam = 100.*sinlam*coslam*(1.-25.*coslam**2) 
	   elseif(lam.lt.0..and.coslam.lt..2) then
	     dpotdlam = -100.*sinlam*coslam*(1.-25.*coslam**2) 
	   else
	     dpotdlam = 0.
	   endif
	    !
	    sinIm = 2.*sinlam/sqrt(4.-3.*coslam**2)
            ed1   = -dpotdphi/r0/coslam
	    ed2   =  dpotdlam/r0/sinIm  
            do k=1,nmax
              fline_s2(i,j,isn)%un(k)=  ed2/fline_s2(i,j,isn)%be3(k) !ue1
              fline_s2(i,j,isn)%vn(k)= -ed1/fline_s2(i,j,isn)%be3(k) !ue2
!	      write(77,'(5(x,e18.8))') fline_s2(i,j,isn)%mlon_m,fline_s2(i,j,isn)%mlat_m, &
!	       fline_s2(i,j,isn)%hgt_pt(k),fline_s2(i,j,isn)%un(k),fline_s2(i,j,isn)%vn(k)

            end do ! end height loop
      end do ! end latitude loop
      
      do j=2,nmlat_h,1     ! loop over all latitudes in one hemisphere 
	nmax = fline_s1(i,j,isn)%npts ! maximum of points on fieldline
				     ! use it to be sure that right art of array is used
	   lam = fline_s1(i,j,isn)%mlat_m
!           cosphi = cos(fline_s1(i,j,isn)%mlon_m)
!           sinphi = sin(fline_s1(i,j,isn)%mlon_m)
           coslam = cos(fline_s1(i,j,isn)%mlat_m)
           sinlam = sin(fline_s1(i,j,isn)%mlat_m)
	   dpotdphi = 0.
	   if(lam.gt.0..and.coslam.lt..2)then
	     dpotdlam = 100.*sinlam*coslam*(1.-25.*coslam**2) 
	   elseif(lam.lt.0..and.coslam.lt..2) then
	     dpotdlam = -100.*sinlam*coslam*(1.-25.*coslam**2) 
	   else
	     dpotdlam = 0.
	   endif

	   pot = 0.
	   if (coslam.lt..2) then
	     pot = (1. - 25.*(cos(lam))**2)**2
	     if (lam.lt.0.) pot = -pot
	   endif
	   write(66,'(5(x,e18.8))') fline_s1(i,j,isn)%mlon_m,fline_s1(i,j,isn)%mlat_m, &
	      pot,dpotdphi,dpotdlam 
	!
!	   if(j == nmlat_h) then
!	     ! sinIm =0 at magnetic equator -> L'Hospital rule
!	     ! dPhi/dlam_m/sinIm -> sin(phi_m)/cos(lam_m)[2sin^2(lam_m)-1]/[4-3*cos^2(lam_m)]^1.5
!	      ed2   = sinphi/coslam/r0*(2*sinlam**2-1.)/(4.-3.*coslam**2)**1.5
!	   else
	   ed2 = 0.
	   if (j.ne.nmlat_h) then
	      sinIm = 2.*sinlam/sqrt(4.-3.*coslam**2)
	      ed2   = dpotdlam/r0/sinIm 
	   endif
	   ed1 = -dpotdphi/r0/coslam
	   
           do k=1,nmax
             fline_s1(i,j,isn)%un(k)=  ed2/fline_s1(i,j,isn)%be3(k) !ue1
             fline_s1(i,j,isn)%vn(k)= -ed1/fline_s1(i,j,isn)%be3(k) !ue2
!	     write(66,'(5(x,e18.8))') fline_s1(i,j,isn)%mlon_m,fline_s1(i,j,isn)%mlat_m, &
!	      fline_s1(i,j,isn)%hgt_pt(k),fline_s1(i,j,isn)%un(k),fline_s1(i,j,isn)%vn(k)

           end do ! end height loop
      end do ! end latitude loop
      !
      ! set polar winds to zero 
      fline_s1(i,1,isn)%un(:)=  0. !ue1
      fline_s1(i,1,isn)%vn(:)=  0. !ue2
    end do
  end do
!	
  end subroutine setup_test5
