      subroutine conduc_empirical(glon,glat,alts,nalt,f107,ap,
     |  year,doy,ut,sigH,sigP,teiH,rhoH,neH)
! this code is from Art Richmond and uses MSIS, IRI and apex
! to calculate the conductivities
! am 2/2014 modified for including in the dynamo
!       
      implicit none
!   
      integer,intent(in) :: nalt
      real,intent(in) :: glon(nalt),glat(nalt),alts(nalt)
      real,intent(in) :: f107,ap,year,doy,ut
      real,intent(out) :: sigH(nalt),sigP(nalt)
      real,intent(out) :: teiH(nalt),rhoH(nalt),neH(nalt) ! for Jpg=.tru.
!      
! local variables 
      integer :: iyd
! 
      real :: SIGPAR(NALT)
      real :: XMO,XMO2, XMN2
      data XMO/2.6567E-26/, XMO2/5.3134E-26/, XMN2/4.6518E-26/ 
C
      IYD  = int(year*1000 + doy)
      
      call CONDUC(IYD,UT,GLAT,GLON,F107,AP,NALT,ALTS, 
     1  SIGPAR,SIGP,SIGH,teiH,rhoH,neH)
 !    
      CLOSE(3)
!      
      end subroutine conduc_empirical
!----------------------------------------------------------------------
      SUBROUTINE CONDUC(IYD,UT,GLAT,GLON,F107,AP,NALT,ALTS, 
     1  SIGPAR,SIGP,SIGH,dteiH,drhoH,dneH)
C
C Uses ion and electron densities and temperatures from IRI90, 
C   neutral densities from MSIS, and IGRF magnetic field to calculate 
C   vertical profile of ionospheric conductivity components
C Directory DIRECT, which has files containing IRI coefficients, is 
C   given in a DATA statement; this will have to be modified for use on 
C   non-HAO computers.
C
C Inputs:
C	IYD  = 7-digit integer YYYYDDD, where YYYY is year, and DDD is
C		day number of the year (January 1 = day 1).  Used to
C		select epoch of IGRF.
C	UT   = universal time in hours and fraction (real)
C	GLAT = geographic latitude (real)
C	GLON = geographic longitude (real)
C	F107 = solar 10.7-cm flux index (real)
C	AP   = daily Ap index (real)
C 	NALT = integer number of altitudes in profile; must be greater 
C		than or equal to 3 and less than or equal to 60
C	ALTS = real array containing NALT altitude values in km, 
C		increasing monotonically upward
C Outputs:
C	CHI  = solar zenith angle in degrees (real)
C	TN   = real array of neutral temperature (K) at ALTS
C	TE   = real array of electron temperature (K) at ALTS
C	TI   = real array of ion temperature (K) at ALTS
C	DENOP= real array of O+ density (m-3) at ALTS
C	DENO2P= real array of O2+ density (m-3) at ALTS
C	DENNOP= real array of NO+ density (m-3) at ALTS
C	DENE = real array of electron density (m-3) at ALTS
C	CFOP = real array of O+ - neutral collision frequency (s-1)
C	CFO2P= real array of O2+ - neutral collision frequency (s-1)
C	CFNOP= real array of NO+ - neutral collision frequency (s-1)
C	CFE  = real array of electron-neutral collision frequency (s-1)
C		for motion perpendicular to magnetic field
C	CFEP = real array of electron collision frequency (s-1)
C		for motion parallel to magnetic field, including 
C		collisions with both neutrals and ions
C	CFI  = real array of mean ion-neutral collision frequency (s-1)
C	GFOP = real array of O+ angular gyrofrequency (s-1)
C	GFO2P= real array of O+ angular gyrofrequency (s-1)
C	GFNOP= real array of O+ angular gyrofrequency (s-1)
C	GFE  = real array of electron angular gyrofrequency (s-1)
C	GFE  = real array of mean ion angular gyrofrequency (s-1)
C	SIGPAR= real array of parallel conductivity (S.m-1)
C	SIGP = real array of Pedersen conductivity (S.m-1)
C	SIGH = real array of Hall conductivity (S.m-1)
C	B125nT= magnetic field strength at 125 km in nT
C	DENO = real array of neutral O density (m-3)
C	DENN2= real array of neutral N2 density (m-3)
C	DENO2= real array of neutral O2 density (m-3)
C	DENT = real array of O + O2 + N2 neutral number density (m-3)

      use apex,only: cofrm,feldg
      LOGICAL JF(12)
      COMMON/CHTD/TINFX,FL(7)
      DIMENSION glon(nalt),glat(nalt),ALTS(NALT),D(8),T(2)
      DIMENSION OUTF(11,nalt),OARR(30),OUTF_loc(11,1)
      DIMENSION TE(NALT),TI(NALT),TN(NALT)
     1	 ,DENOP(NALT),DENO2P(NALT),DENNOP(NALT),DENE(NALT)
     2	 ,CFOP(NALT),CFO2P(NALT),CFNOP(NALT),CFE(NALT),CFI(NALT)
     3	 ,GFOP(NALT),GFO2P(NALT),GFNOP(NALT),GFE(NALT),GFI(NALT)
     4   ,CFEP(NALT),SIGPAR(NALT),SIGP(NALT),SIGH(NALT)
     5   ,DENO(NALT),DENN2(NALT),DENO2(NALT),DENT(NALT)
     6   ,dteiH(nalt),drhoH(nalt),dneH(nalt)         ! for Jpg calculation
C
      DATA XME /9.1093897E-31/XMOP/2.6567E-26/XMO2P/5.3134E-26/
     1 XMNOP/4.9826E-26/ EC/1.60217733E-19/
      DATA MASS/48/
      DATA TINFX/0./ FL/1.,1.,1.,1.,1.,1.,1./
      DATA JF/12*.TRUE./ JMAG/0/
      
      CHARACTER*50 DIRECT
      DATA DIRECT /'./data_files/'/
      DATA IENTY/1/
!
      integer :: nloc
      real :: glon_loc,glat_loc,alt_loc,date_loc,slt,ut      
!     
      IYR = FLOAT(IYD)/1000.
C  NDD = Negative of Day number.
      NDD = IYR*1000 - IYD
      DATE_loc = FLOAT(IYR) + (FLOAT(-NDD)-.5)/365.24
      DHOUR = UT + 25.
      SEC = UT*3600.
      F107A = F107
      RZ12 = 1.16*F107 - 72.
      CALL METERS(.TRUE.)
      
      ! CALL COFRM (DATE_loc) ! was already done
      
      nloc = 1
      outf = 0.
      oarr = 0.
      do i=1,nalt  ! loop over all points
	N = NALT - I + 1 ! loop from top to bottom since some densities might
	                 ! get small see O+,NO+,O2+
        glon_loc = glon(n)
        glat_loc = glat(n)
	alt_loc  = alts(n)
        STL = UT + GLON_loc/15.
	! changed rz12 to -f107 in call irr
	outf_loc = 0.
	oarr = 0.
        CALL IRI90(JF,JMAG,GLAT_loc,GLON_loc,rz12,NDD,DHOUR,
     &                  ALT_loc,Nloc,DIRECT,OUTF_loc,OARR)
        outf(:,n) = outf_loc(:,1)  ! copy arrya from one height into array of all heights
        
        CHI = OARR(23)
        SOLDEC = OARR(24)
C        CALL FELDG (IENTY,GLAT_loc,GLON_loc,125.,BNRTH,BEAST,BDOWN,B125)
C Note: FELDG in stdmdls.f returns magnetic field in Gauss
C        B125nT = B125*1.e5
C Call GTD6 once to get rid of anomalous value at top
        D = 0.
	T = 0.
C	write(6,'(a14,i4,3(x,f15.4)') '1nd call gtd6',n,ALT_loc,
C     &           GLAT_loc,GLON_loc
C        if(n.eq.nalt) CALL GTD6 (IYD,SEC,ALT_loc,GLAT_loc,GLON_loc,STL,
C     1 	  F107A,F107,AP,MASS, D, T)
     
      	CALL FELDG (IENTY,GLAT_loc,GLON_loc,ALT_loc,
     1 	  BNRTH,BEAST,BDOWN,BABS)
	BMAG = 1.E-4*BABS
	ECB = EC*BMAG
     	CALL GTD6 (IYD,SEC,ALT_loc,GLAT_loc,GLON_loc,STL,F107A,F107,AP,
     1 	  MASS, D, T)
	DENO(N) = D(2)
	DENN2(N) = D(3)
	DENO2(N) = D(4)
	DENT(N) = D(1) + D(2) + D(3) + D(4) + D(5) + D(7) + D(8)
	TN(N) = T(2)
	TI(N) = OUTF(3,N)
	IF (OUTF(3,N).LT.0.) TI(N) = T(2)
	TE(N) = OUTF(4,N)
	IF (OUTF(4,N).LT.0.) TE(N) = T(2)
	dteiH(n) = TE(N) + TI(N)  ! for Jpg calculation [K]
C Set electron density to 1.E-20 below bottom of IRI
	OUTF(1,N) = AMAX1(OUTF(1,N),1.E-20)
	DENE(N) = OUTF(1,N)
	dneH(n)  = DENE(N)   ! for Jpg calculation [m-3]
	
!	write(6,'(i3,i3,3(x,f10.5),3(x,e15.8))') n,nalt,glat_loc,
!     | glon_loc,alt_loc,OUTF(5,N),OUTF(8,N),OUTF(9,N)
	
	IF (OUTF(5,N).LT.0. .and. n.lt.nalt) then  ! am 2/2014 ions of iri90 below 100km are not defined
	   OUTF(5,N) = OUTF(5,N+1)
	endif  
	if(OUTF(5,N).LT.0. .and. n.eq.nalt) then
	  OUTF(5,N) = 0.0
	endif  
	DENOP(N) = .01*OUTF(5,N)*OUTF(1,N)
	
	IF (OUTF(8,N).LT.0..and. n.lt.nalt) then  ! am 2/2014 ions of iri90 below 100km are not defined
	 OUTF(8,N) = OUTF(8,N+1)
	endif  
	if(OUTF(8,N).LT.0. .and. n.eq.nalt) then
	  OUTF(8,N) = 50.
	endif  
	DENO2P(N) = .01*OUTF(8,N)*OUTF(1,N)	
	
	IF (OUTF(9,N).LT.0. .and. n.lt.nalt) then
	  OUTF(9,N) = OUTF(9,N+1)
	endif 
	if(OUTF(9,N).LT.0. .and. n.eq.nalt) then  ! am 2/2014 ions of iri90 below 100km are not defined
	  OUTF(9,N) = 50.
	endif  
	DENNOP(N) = .01*OUTF(9,N)*OUTF(1,N) 
	
	drhoH(n) = DENOP(N)*16 +DENO2P(N)*32 + DENNOP(N)*28 ! for Jpg calculation [#/m3*mol]
	
	GFE(N)   = ECB/XME
	GFOP(N)  = ECB/XMOP
	GFO2P(N) = ECB/XMO2P
	GFNOP(N) = ECB/XMNOP
C CFE from Gagnepain et al. (J. Atmos. Terr. Phys., 34, 1119, 1977),
C based on Table 2 of Itikawa (Planet. Space Sci., 19, 993, 1971).
	CFE(N) = 7.23E-15*(TE(N)/300.)**.95*D(3)
     1         + 5.19E-15*(TE(N)/300.)**.79*D(4)
     2         + 1.92E-15*(TE(N)/300.)**.85*D(2)
C CFEP from Richmond (Numerical model of the equatorial electrojet, 
C  AFCRL Rept. No. 72-0668, 1972), based on Itikawa (1971).
	CFEP(N) = 4.56E-15*(TE(N)/300.)**.90*D(3)
     1         + 4.29E-15*(TE(N)/300.)**.55*D(4)
     2         + 1.46E-15*(TE(N)/300.)**.83*D(2)
C NU(ei) from Spitzer conductivity, with Coulomb logarithm of 15. 
	CFEP(N) = CFEP(N) + 27.6E-6*DENE(N)/TE(N)**1.5
	TR = .5*(TN(N)+TI(N))
C NU(OP-N2) and NU(OP-O2) based on Table 3 of Mason (Planet. Space Sci, 
C  18, 137, 1970)
	CFOP(N) = 5.37E-16*(TR/500.)**(-.20)*D(3)
     1          + 7.00E-16*(TR/500.)**.05*D(4)
C NU(OP-O) from Pesnell et al. (Geophys. Res. Lett., 20, 1343, 1993)
     2        + 3.E-17*SQRT(TR)*(1.-0.0586*ALOG(TR*1.E-3))**2*D(2)
C NU(O2P-N2) calculated from NU(O2P-air) and NU(O2P-O2) from Viehland 
C  and Mason (Atomic Data and Nuclear Data Tables, 60, 37-95, 1995),
C  assuming 0.79NU(O2P-N2) = NU(O2P-air) - 0.21NU(O2P-O2).    
C  K0(0) for NU(O2P-air) is for T=300, Teff=325.
C  K0(0) for NU(O2P-O2) is for T=264, Teff=275.
C  Both of these K0(0)s show zero variation with Teff.
	CFO2P(N) = 4.31E-16*D(3) + 5.24E-16*D(4)
C NU(O2P-O) based on Table 3 of Mason (1970)
     1           + 1.84E-16*D(2)*(TR/500.)**(-.19)
C NU(NOP-air) from Viehland and Mason (1995), using K0(0) for T=300,
C  Teff=500.
	CFNOP(N) = 4.35E-16*(D(3) + D(4))*(TR/500)**(-.11)
C NU(NOP-O) based on Table 3 of Mason (1970)
     1           + 1.93E-16*D(2)*(TR/500.)**(-.19)
	SIGP(N) = 0.
	SIGH(N) = 0.
	ECOB = EC/BMAG
	SIGPAR(N) = DENE(N)*ECOB*GFE(N)/CFEP(N)
	RE = CFE(N)/GFE(N)
	OPRE2 = 1. + RE*RE
	CFE(N) = (CFE(N)+RE*RE*CFEP(N))/OPRE2
	RI = CFOP(N)/GFOP(N)
	OPRI2 = 1. + RI*RI
	SIGP(N) = SIGP(N) + DENOP(N)*ECOB*(RE/OPRE2 + RI/OPRI2)
	SIGH(N) = SIGH(N) + DENOP(N)*ECOB*(1./OPRE2 - 1./OPRI2)
	RI = CFO2P(N)/GFO2P(N)
	OPRI2 = 1. + RI*RI
	SIGP(N) = SIGP(N) + DENO2P(N)*ECOB*(RE/OPRE2 + RI/OPRI2)
	SIGH(N) = SIGH(N) + DENO2P(N)*ECOB*(1./OPRE2 - 1./OPRI2)
	RI = CFNOP(N)/GFNOP(N)
	OPRI2 = 1. + RI*RI
	SIGP(N) = SIGP(N) + DENNOP(N)*ECOB*(RE/OPRE2 + RI/OPRI2)
	SIGH(N) = SIGH(N) + DENNOP(N)*ECOB*(1./OPRE2 - 1./OPRI2)
!	TOTI = DENOP(N) + DENO2P(N) + DENNOP(N)
!	write(6,*) toti
!	GFI(N) = (DENOP(N)*GFOP(N) + DENO2P(N)*GFO2P(N)
!     1   +DENNOP(N)*GFNOP(N))/TOTI
!	CFI(N) = (DENOP(N)*CFNOP(N) + DENO2P(N)*CFO2P(N)
!     1   +DENNOP(N)*CFNOP(N))/TOTI
      enddo
      
!      DO NI=1,NALT
!	N = NALT - NI + 1
!        write(99,'(3(x,f12.5),2(x,e15.8)')glon(n),glat(n),ALTS(n),
!     |       sigp(n),sigh(n)
!      enddo
!      
!      RETURN
      END
