subroutine get_hwm93
;
  use params_module,only: f107,ap,year,doy,ut,m2km,nmlon, &
     nmlat_h,nmlatS2_h
  use fieldline_s_module,only: fieldline_s1,fline_s1, &
     fieldline_s2,fline_s2
;
  implicit none 
;
  INTEGER      :: iyd,imil,iyr,nmax
  integer      :: i,j,isn,k
  REAL      :: SEC,ALT,GLAT,GLON,STL,F107A,F107_loc,APloc(2)
  REAL      :: W(2),unavg,vnavg,untmp(nmlon),vntmp(nmlon)
  real,parameter :: unitv(nmlon)=1.
  real :: tmpv(nmlon)
  
! HEIGHT PROFILE
  imil= int(year/100)
  iyr = int(year-imil*100)
  iyd = int(doy)  ! yyddd !!!!WATCH YEAR NOT INCLUDED
  sec = real(ut) * 3600.0
  apLoc(1) = real(ap)
  apLoc(2) = real(ap)  ! for HWM07 if negative dwm is not called - code is crashing in dwm
  f107a    = real(f107)
  f107_loc = real(f107)
!  
! 
  do isn = 1,2 ! loop over both hemisphere
    do i=1,nmlon ! loop over all longitudes
    
      do j=nmlatS2_h,1,-1 ! loop over all latitudes in one hemisphere 
	nmax = fline_s2(i,j,isn)%npts ! maximum of points on fieldline
				     ! use it to be sure that right art of array is used
        do k=1,nmax
	  glat = real(fline_s2(i,j,isn)%glat(k))
	  glon = real(fline_s2(i,j,isn)%glon(k))
	  alt = real(fline_s2(i,j,isn)%hgt_pt(k)*m2km)     ! convert from m to km
	  
	  stl = real(ut + glon/15.0)
	  if (stl.gt.24) then
	     stl = stl -24.
	  elseif(stl.lt.0) then
	     stl = stl + 24.
	  end if 
	  w = 0.
          call gws5(iyd,sec,alt,glat,glon,stl,f107a,f107_loc,apLoc,w)
          ! put neutral wind into fieldline array
          fline_s2(i,j,isn)%un(k)= dble(w(2))
          fline_s2(i,j,isn)%vn(k)= dble(w(1))
	  
!	  if(alt.lt.200) then
!            fline_s2(i,j,isn)%un(k)= 0. 
!            fline_s2(i,j,isn)%vn(k)= 0.
!	  end if
	  
	  !write(88,'(3(x,f10.5),2(x,e15.8))') alt,glat,glon,w
    
        end do ! end height loop
      end do ! end latitude loop
	
      do j=nmlat_h,1,-1 ! loop over all latitudes in one hemisphere 
        nmax = fline_s1(i,j,isn)%npts ! maximum of points on fieldline
				    ! use it to be sure that right art of array is used
	do k=1,nmax
	  glat = real(fline_s1(i,j,isn)%glat(k))
	  glon = real(fline_s1(i,j,isn)%glon(k))
	  alt = real(fline_s1(i,j,isn)%hgt_pt(k)*m2km)   ! convert from m to km
	  stl = real(ut + glon/15.0)
	  if (stl.gt.24) then
	     stl = stl -24.
	  elseif(stl.lt.0) then
	     stl = stl + 24.
	  end if 
	 
	  call gws5(iyd,sec,alt,glat,glon,stl,f107a,f107_loc,apLoc,w)
	  ! put neutral wind into fieldline array
	  fline_s1(i,j,isn)%un(k)= dble(w(2))
	  fline_s1(i,j,isn)%vn(k)= dble(w(1))
	  
!	  if(alt.lt.200) then
!            fline_s1(i,j,isn)%un(k)= 0. 
!            fline_s1(i,j,isn)%vn(k)= 0.
!	  end if
    
	end do ! end height loop
      end do ! end of latitude loop
      
    end do
  end do
  
  ! 8/12/2014 for polar value do a longitudinal average since values did not look
  ! right -> looking at the plots it did not seem to make a difference (need to check numerical
  ! values)
  do isn = 1,2
    do k=1,nmax
      do i=1,nmlon
      untmp(i) = fline_s1(i,2,isn)%un(k)
      vntmp(i) = fline_s1(i,2,isn)%vn(k)
      end do
      unavg = dot_product(unitv,untmp)/nmlon
      vnavg = dot_product(unitv,vntmp)/nmlon
      do i=1,nmlon
        fline_s1(i,1,isn)%un(k)= unavg
        fline_s2(i,1,isn)%un(k)= vnavg
      end do
    end do
  end do

end subroutine get_hwm93
!******************************************************************************
