!----------------------------------------------------------------------------- 
      subroutine remap_weights
! 
      use params_module, only: nlat_qd,nlat_qd_h,nhgt_fix,nmlat_h,nhgt_fix_r &
        ,re,ylonm_s,hgt_fix_r,hgt_fix,pi &
        ,rho,h0
      use qd_module, only: a1q,wgt1,jl_qd,a3q,wgt3,jl3_qd,lat_qd_ed &
        ,q1,q2,q3
      use area_factors_module, only: a1,a3 
!     
      implicit none
!     
      integer :: j,k,l,nlatmax,jstart
      real :: fac,dlonm,dlatm,x

! 250119 ADR: Remove unneeded second index from a1q_upd and a3q_upd
!      real :: a1q_upd(nlat_qd_h,nhgt_fix),& ! (updated 8/3/2015)
      real :: a1q_upd(nlat_qd_h),&           
! a1q is the normalized area from the pole to the poleward edge of
!  element l, i.e., the equatorward edge of element l-1.
!              a3q_upd(nlat_qd_h,nhgt_fix_r) ! (updated 8/3/2015)
              a3q_upd(nlat_qd_h), & 
! a3q is the normalized area from the pole to the poleward edge of
!  element l, i.e., the equatorward edge of element l-1.
              rhoq(nlat_qd_h,nhgt_fix_r) 
! rhoq is the value of rho at k-1/2 and at the poleward edge of
!  element l, i.e., the equatorward edge of element l-1.
!      
! a1q(l+0.5,k) = l/Lq (page 4 2015 April 20 bottom) at edges
! a1q is the normalized area from the pole to the poleward edge of
!  element l, i.e., the equatorward edge of element l-1.
      dlonm = ylonm_s(2)-ylonm_s(1) ! Assume constant in longitude.
      dlatm = abs(lat_qd_ed(2)-lat_qd_ed(1)) ! Assume constant in latitude.
      a1q_upd  = 0.
      do k=1,nhgt_fix
        q2(1,k) = 0.
        fac = (hgt_fix_r(k+1)-hgt_fix_r(k))*(re+hgt_fix(k))
!        a1q_upd(1,k)  = 0  ! pole value 
        a1q_upd(1)  = 0  ! pole value 
        do l=2,nlat_qd_h   ! south pole to equator; edge max number nlat_qd; midpoint l max number nlat_qd-1
! Assume that the number of qd grid points is the same at all altitudes
!  (if this is not the case, the formula for a1q will be k-dependent).
!	  a1q_upd(l,k) = real((l-1))/real(nlat_qd_h-1)
!	  a1q_upd(l,k) = abs((lat_qd_ed(l)-lat_qd_ed(1)))
	  a1q_upd(l)  = abs((lat_qd_ed(l)-lat_qd_ed(1)))
	  ! q1(l,k) = rk*(r_k+0.5-r_k-0.5)*[A1q(l+0.5,k)-A1q(l-0.5,k)]
	  ! with A1q(l+0.5,k) = 1-2/pi*|lam_q(l+0.5)|
          ! q1(l-1,k) = fac*(a1q_upd(l,k)-a1q_upd(l-1,k))  ! (224a) page 56 Oct 8, 2015
          q1(l-1,k) = fac*(a1q_upd(l)-a1q_upd(l-1)) 
          q2(l,k)   = fac*dlonm*cos(abs(lat_qd_ed(l)))     ! (252a) page 56 Oct 8, 2015
        end do
      end do
!  
! For each index l find the corresponding j (jl_qd) to linearly
!  interpolate LI1qd(l-.5,isn) between LI1(j-.5) and LI1(j+.5).
! isn,i,k are the same for the qd and rho grids.
      wgt1  = 9999.
      jl_qd = 9999
      a1q_upd = a1q_upd*2/pi ! normalize but reverse at end
      do k=1,nhgt_fix ! number of levels for I1 and I1qd
        jstart = 1	       ! when the latitude loop starts always start searching from the pole
! AM 2022-08-08 mapping of LI1
        wgt1(1,k,:)  = 0.   ! for polar value since a1 and LI1 are zero
!        wgt1(1,k,1)  = 0.  ! 241113 ADR: changes to qd mapping
!        wgt1(1,k,2)  = 0.  ! 241113 ADR: changes to qd mapping
!        wgt1(1,k,3)  = 0.  ! 241113 ADR: changes to qd mapping
        jl_qd(1,k) = 1
! nlatmax is one plus the number of S2 points at level k in one hemisphere.
!  This is one less than the number of points used for the first index
!  of a1 and LI1.
        nlatmax = nmlat_h-k+1
! loop over poleward qd box edges, except for edges lying at pole and equator.
        lloop: do l=2,nlat_qd_h-1
          jloop: do j=jstart,nlatmax  ! always start searching from the last found j*
             !
             ! if(a1q_upd(l,k).ge.a1(j,k).and.a1q_upd(l,k).lt.a1(j+1,k)) then
             if(a1q_upd(l).ge.a1(j,k).and.a1q_upd(l).lt.a1(j+1,k)) then
               jl_qd(l,k) = j
               ! calculate weighting function 
! AM 2022-08-08 mapping of LI1 
!               wgt1(l,k)  = (a1q_upd(l,k) - a1(j,k))/(a1(j+1,k)- a1(j,k))
               !x = (a1q_upd(l,k) - a1(j,k))/(a1(j+1,k)- a1(j,k))
               x = (a1q_upd(l) - a1(j,k))/(a1(j+1,k)- a1(j,k))
               wgt1(l,k,1) =   x*(-2.+x*(3.-x))/6.
               wgt1(l,k,2) = 1+x*(-.5+x*(-1.+x*.5))
               wgt1(l,k,3) =   x*(1.+x*(.5-x*.5))
               wgt1(l,k,4) =   x*(-1.+x*x)/6.
               
              !250110 ADR: Change to linear interpolation if j.le.2
              if (j.le.2) then
                 wgt1(l,k,1) = 0.
                 wgt1(l,k,2) = 1. - x
                 wgt1(l,k,3) = x
                 wgt1(l,k,4) = 0.
               endif
               
               jstart = j  ! save last found value to start from that one
               exit jloop
             end if
             !
          end do jloop 
        end do lloop
        !
        l= nlat_qd_h
        jl_qd(l,k) = nlatmax
! AM 2022-08-08 mapping of LI1 
!        wgt1(l,k)  = 1.
        wgt1(l,k,1) = 0.
        wgt1(l,k,2) = 0.
        wgt1(l,k,3) = 1.
        wgt1(l,k,4) = 0.
        !	
      end do
      a1q_upd = a1q_upd/2*pi ! normalize but reverse at end
!      
! updated 8/3/2015 equation (235')     
! a3q(l+0.5,k-0.5) = [1-sin(|lamq(l+0.5)|)]
!                 see (page 6 2015 April 20 top) at edges
! a3q is the normalized area from the pole to the poleward edge of
!  element l, i.e., the equatorward edge of element l-1.
      a3q_upd  = 0.
      do k=1,nhgt_fix_r
        fac = dlonm*(re+hgt_fix_r(k))**2
        !a3q_upd(1,k)  = 0  ! pole value 
        a3q_upd(1)  = 0  ! pole value 

	rhoq(1,k) = 0.
	
        do l=2,nlat_qd_h   ! south pole to equator; edge max number nlat_qd; midpoint l max number nlat_qd-1
! Assume that the number of qd grid points is the same at all altitudes
!  (if this is not the case, the formula for a1q will be k-dependent).
	  !a3q_upd(l,k)  = 1-sin(abs(lat_qd_ed(l)))
	  a3q_upd(l)  = 1-sin(abs(lat_qd_ed(l)))
          !q3(l-1,k) = fac*(a3q_upd(l,k)-a3q_upd(l-1,k)) 
          q3(l-1,k) = fac*(a3q_upd(l)-a3q_upd(l-1))

	  rhoq(l,k) = sqrt((re+h0)/(re+hgt_fix_r(k)))*cos(lat_qd_ed(l))
! lat_qd_ed(l) is southern (poleward, in S hemisphere) edge of l QD box.
        end do
      end do
!
! For each index l find the corresponding j (jl3_qd) to 
!  interpolate LI3qd(l-.5,isn) between LI3(j-.5) and LI3(j+.5).
! isn,i,k are the same for the qd and rho grids.
      wgt3   = 9999.
      jl3_qd = 9999.
      do k=1,nhgt_fix_r ! number of levels for I3 and I3qd
        jstart      = 1	  ! when the latitude loop starts always start searching from the pole
        l = 1
! orginal        wgt3(l,k)   = 0.  ! for polar value since a3 and LI3 are zero
        wgt3(l,k,:)   = 0.  ! for polar value since a3 and LI3 are zero
        !wgt3(l,k,1)   = 0.  ! 241113 ADR added
        !wgt3(l,k,2)   = 0.  ! 241113 ADR added
        !wgt3(l,k,3)   = 0.  ! 241113 ADR added
        jl3_qd(l,k) = 1
! Write out jl's and wgt's.
!          if (k.eq.1) write(8,'(2i5,f10.5,i5,f10.5)') l, &
!            jl_qd(l,k),wgt1(l,k),jl3_qd(l,k),wgt3(l,k)
        nlatmax     = nmlat_h-k+1
        !
! loop over poleward [240115 ADR should be equatorward, in S hemisphere] qd box edges, except for edges lying at pole and equator.
        lloop3: do l=2,nlat_qd_h-1
          jloop3: do j=jstart,nlatmax  ! always start searching from the last found j*
!             if(a3q(l,k).ge.a3(j,k).and.a3q(l,k).lt.a3(j+1,k)) then
!             if(a3q_upd(l,k).ge.a3(j,k).and.a3q_upd(l,k).lt.a3(j+1,k)) then
!
! 250119 ADR: use rho instead of a3 as independent variable for interpolation.
	     if(rhoq(l,k).le.rho(2,2)) then
               jl3_qd(l,k) = 2
		x = (rhoq(l,k)-rho(1,2))/(rho(2,2)-rho(1,2))
		wgt3(l,k,1) = 0.
		wgt3(l,k,2) = 1 + x*(3-4.*x*x)
		wgt3(l,k,3) = x*(1 + 4.*x*(1.+x))/9.
		wgt3(l,k,4) = 0.	
             elseif(rhoq(l,k).ge.rho(j,2).and.rhoq(l,k).lt.rho(j+1,2)) then
               jl3_qd(l,k) = j
! calculate weighting function  
!               wgt3(l,k)  = (a3q(l,k) - a3(j,k))/(a3(j+1,k)- a3(j,k))
! 2022-7-26 ADR Generate weighting factors for cubic spline interpolation of LI3 to get LI3qd
!               x = (a3q_upd(l,k) - a3(j,k))/(a3(j+1,k)- a3(j,k))

	       x = (rhoq(l,k)-rho(j,2))/(rho(j+1,2)-rho(j,2))

               wgt3(l,k,1) =   x*(-2.+x*(3.-x))/6.
               wgt3(l,k,2) = 1+x*(-.5+x*(-1.+x*.5))
               wgt3(l,k,3) =   x*(1.+x*(.5-x*.5))
               wgt3(l,k,4) =   x*(-1.+x*x)/6.
!   orginal            wgt3(l,k)  = (a3q_upd(l,k) - a3(j,k))/(a3(j+1,k)- a3(j,k))
               jstart = j
               exit jloop3
             end if
             
          end do jloop3   
! Write out jl's and wgt's.
!          if (k.eq.1) write(8,'(2i5,f10.5,i5,f10.5)') l, &
!            jl_qd(l,k),wgt1(l,k),jl3_qd(l,k),wgt3(l,k)
        end do lloop3
! Now do equatorial value.
        l= nlat_qd_h
        jl3_qd(l,k) = nlatmax
! 2022-7-26 ADR
        wgt3(l,k,1) = 0.
        wgt3(l,k,2) = 0.
        wgt3(l,k,3) = 1.
        wgt3(l,k,4) = 0.
! orginal        wgt3(l,k)  = 1.	
! Write out jl's and wgt's.
!          if (k.eq.1) write(8,'(2i5,f10.5,i5,f10.5)') l, &
!            jl_qd(l,k),wgt1(l,k),jl3_qd(l,k),wgt3(l,k)
      end do !k
!  
      end subroutine remap_weights
!----------------------------------------------------------------------------- 
