!
      subroutine set_bij
! these are from Art's notes from Feb 7, 2023
!  B(i,j) [ Phi(i,j) - Phi*(i,j)]      
!     Phi*(i,j) is the potential at the conjugate location
      
      use fieldline_p_module,only: fieldline_p,fline_p
      use params_module,only: nmlon,nmlat_h, &  ! dimension of bij
          jlatm_JT,bijSum
          
      implicit none
      
      integer :: i,j
      real, parameter :: b_high =33.e-12 ! 33.e-12 ! 33. !33.e-12 !0.03 ! 33.e-12 ! start with one value 
      
      ! b(i,j) non zero in region of non equitpotential fieldlines pole to jlatm_JT
      do j=1,jlatm_JT
        fline_p(:,j,1)%bij = b_high
        fline_p(:,j,2)%bij = b_high
      end do
      
      ! set to zero in region where fieldlines are assumed to be equipotential
      ! should not be used (zero actually would mean the hemispheres are decoupled)
      fline_p(:,jlatm_JT+1:nmlat_h,1)%bij = 0. 
      fline_p(:,jlatm_JT+1:nmlat_h,2)%bij = 0.
      
      ! the sum of the polar value is needed for the pole equation 
      ! B is the same in both hemisphere, therefore it does not matter which hemisphere is used
      bijSum = 0.
      do i=1,nmlon
        bijSum = bijSum + fline_p(i,1,2)%bij 
      end do
       
      end subroutine set_bij
