;+
; NAME:  CART_TO_SPHERE
;
; PURPOSE:  Transform 3D vectors from cartesian to spherical coordinates
;
; CATEGORY:  Utility
;
; CALLING SEQUENCE:  result = cart_to_sphere(cart)
;
; INPUTS:  cartesian coordaintes of vector (x, y, z), integer, long, float, or double
;
; OUTPUTS:  spherical coordiantes of vector (r,theta, phi) in radians, double precision
;	  
; PROCEDURE: r=sqrt(x^2+y^2+z^2), theta=acos(z/r), phi=atan(y/x)
;            note that these can be two-dimensional 3 x N arrays of vector triplets
;            dimensions must be consistent, however, and no more than two-dimensions allowed
;            there is no error checking, consistency is up to the user
;
; MODIFICATION HISTORY:  SCS, 3/15
;
;+

function cart_to_sphere, v

u = double(v)
s = u
s[0,*] = sqrt(u[0,*]^2+u[1,*]^2+u[2,*]^2)
s[1,*] = acos(u[2,*]/s[0,*])
s[2,*] = atan(u[1,*],u[0,*])

return, s

end
