pro colorwind, red, green, blue

; Color table with blue-white-red scale, for neg-zero-pos data, e.g., winds
; Range is from 1 to !d.table_size-2 (usually 254) with midpoint at 127.

common colors, r_orig, g_orig, b_orig, r_curr, g_curr, b_curr

red=fltarr(256) & green=fltarr(256) & blue=fltarr(256)
r=fltarr(9)    & g=fltarr(9)      & b=fltarr(9)

r=[0.0, 0.0, 0.0, 0.5, 1.0, 1.0, 1.0, 1.0, 1.0]
g=[0.0, 0.3, 0.6, 0.8, 1.0, 0.8, 0.6, 0.3, 0.0]
b=[1.0, 1.0, 1.0, 1.0, 1.0, 0.5, 0.0, 0.0, 0.0]

n=!d.table_size-2

re=interpol(r,n)
gr=interpol(g,n)
bl=interpol(b,n)
red(0)=0
green(0)=0
blue(0)=0
red(1:n)=re
green(1:n)=gr
blue(1:n)=bl
red(n+1:255)=1.
green(n+1:255)=1.
blue(n+1:255)=1.
red=bytscl(red)
green=bytscl(green)
blue=bytscl(blue)

tvlct,red,green,blue

r_orig=red
g_orig=green
b_orig=blue
r_curr=red
g_curr=green
b_curr=blue

return
end
