;+
; NAME:  LENGTH
;
; PURPOSE:  Find the length (absolute value, magnitude) of a 3D vector
;
; CATEGORY:  Utility
;
; CALLING SEQUENCE:  result = length(v) 
;
; INPUTS:  v is a vector (x,y,z)
;
; OUTPUTS:  Length (absolute value, magnitude) of v 
;	  
; PROCEDURE: length = sqrt(x^2+y^2+z^2)
;            Note that this can be a two-dimensional 3xN array of vector triplets.
;            No more than two-dimensions allowed.
;            There is no error checking.
;
; MODIFICATION HISTORY:  SCS, 3/15
;
;+

function length, v

length = reform(sqrt(v[0,*]^2 + v[1,*]^2 + v[2,*]^2))

return, length

end
