;+
; NAME:  SPHERE_TO_CART
;
; PURPOSE:  Transform  3D vectors from spherical to cartesian coordinates
;
; CATEGORY:  Utility
;
; CALLING SEQUENCE:  v = sphere_to_cart(sph)
;
; INPUTS:  spherical coordaintes of vector (r, theta, phi) in radians, int, long, float, or double
;
; OUTPUTS:  cartesian coordiantes of vector (x,y,z), double precision
;	  
; PROCEDURE: x = r sin(theta)cos(phi), y = r sin(theta)sin(phi),z = r cos(theta)
;            note that these can be two-dimensional 3 x N arrays of vector triplets
;            dimensions must be consistent, however, and no more than two-dimensions allowed
;            there is no error checking, consistency is up to the user
;
; MODIFICATION HISTORY:  SCS, 3/15
;
;+

function sphere_to_cart, sph

sp = double(sph)
v = sp
v[0,*] = sp[0,*] * sin(sp[1,*]) * cos(sp[2,*])
v[1,*] = sp[0,*] * sin(sp[1,*]) * sin(sp[2,*])
v[2,*] = sp[0,*] * cos(sp[1,*])

return, v

end
