;+
; NAME:  ANGLE
;
; PURPOSE:  Find the angle between two 3D vectors
;
; CATEGORY:  Utility
;
; CALLING SEQUENCE:  result = angle(v1,v2) 
;
; INPUTS:  v1 is the first vector, (x1,y1,z1), v2 is the second vector (x2,y2,z2) 
;
; OUTPUTS:  Angle between the two vectors in radians
;	  
; PROCEDURE: angle = acos ( (v1 dot v2) / |v1| * |v2| )
;            Note that these can be two-dimensional 3xN arrays of vector triplets.
;            Dimensions must be consistent, however, and no more than two-dimensions allowed.
;            There is no error checking, consistency is up to the user.
;
; KEYWORDS:  If the /SPHERE keyword is set, v1 and v2 are considered to be in
;            spherical coordinates (r, theta, phi) in radians.
;
; ROUTINES USED:  dot.pro, length.pro
;
; MODIFICATION HISTORY:  SCS, 3/15
;
;+

function angle, v1, v2, sphere=sphere

if keyword_set(sphere) then begin
  angle = reform (acos(cos(v1[1,*])*cos(v2[1,*])+sin(v1[1,*])*sin(v2[1,*])*cos(v1[2,*]-v2[2,*])))
endif else begin
  angle = reform (acos(dot(v1,v2)/(length(v1)*length(v2))))
endelse

return, angle

end
