;+
; NAME:
;	CHIPSI_TO_THETAPHI
;
; PURPOSE:
;	Converts coordinates from instrument chi-psi to ECR theta-phi
;
; CATEGORY:
;	Utility
;
; CALLING SEQUENCE:
;	chipsi_to_thetaphi, satlon, chi, psi, theta, phi
; 
; INPUTS:
;	satlon	Satellite longitude, any type
;	chi	Instrument look angle from nadir toward east, any type
;	psi	Instrument look angle from nadir toward north, any type
;
; OUTPUTS:
;	theta	Zenith angle of observation in ECR coordinate system, double precision
;	phi	Azimuthal angle of observation in ECR coordinate system, double precision
;
; KEYWORDS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; PROCEDURE:
;	Simple transform from instrument look angles to Earth-Centered Rotational (ECR)i
;	coordinate system assuming a geostationary satellite (or any equatorial location).
;	The chi-psi coordinate system is defined as look angles from nadir.
;	Note this essentially assumes that nadir is in the -z direction for a right-hand system.
;	S/C coordinates, however, generally and perversely assume that nadir is +z.
;	Therefore, in this type of S/C coordinates, chi is +x but psi is -y.
;	Arrays of coordiantes of any dimension are OK.
;	
; ROUTINES USED:
;	None.
;
; MODIFICATION HISTORY:
;       Stan Solomon, 3/15
;
;-

pro chipsi_to_thetaphi, satlon, chi, psi, theta, phi

theta = !dpi/2. - psi
phi = !dpi + satlon - chi

return
end
