;+
; NAME:  DOT
;
; PURPOSE:  Find the dot product (inner product or scalar product) of two 3D vectors
;
; CATEGORY:  Utility
;
; CALLING SEQUENCE:  result = dot(v1,v2) 
;
; INPUTS:  v1 is the first vector, (x1,y1,z1), v2 is the second vector (x2,y2,z2) 
;
; OUTPUTS:  Dot product of the two vectors (inner product or scalar product)  
;	  
; PROCEDURE: v1 dot v2 = x1*x2 + y1*y2 + z1*z2
;            Note that these can be two-dimensional 3xN arrays of vector triplets.
;            Dimensions must be consistent, however, and no more than two-dimensions allowed.
;            There is no error checking, consistency is up to the user.
;
; MODIFICATION HISTORY:  SCS, 3/15
;
;+

function dot, v1, v2

dot = reform(v1[0,*]*v2[0,*] + v1[1,*]*v2[1,*] + v1[2,*]*v2[2,*])

return, dot

end
