;+
; NAME:
;	GST
;
; PURPOSE:
;	Calcualtes Greenwich Sidereal Time
;
; CATEGORY:
;	Utility
;
; CALLING SEQUENCE:  
;	result = GST(year,doy,ut)
;
; INPUTS:
;	year	Date in yyyy, integer or longword integer
;	doy  	Day of year in ddd, integer or longword integer
;	ut	Time of day in seconds, UTC, floating point or double precision
;
; OUTPUTS:  
;	gst	Greenwich sidereal time, radians, double precision
;
; COMMON BLOCKS:
;	None.
;
; PROCEDURE:
;	Greenwich Sidereal Time (the angle between the Greenwich meridian
;       and the vernal equinox)	is calculated using formula from C.T. Russell.
;       Array input is OK.
;	Will not work properly before 1900 or after 2100 due to lack of leap year.
;
; REFERENCE:
;	C.T. Russell, Geophysical Coordinate Transforms.
;
; MODIFICATION HISTORY:
;	3/15	Adapted from SUNCOR by Stan Solomon
;
;+

function gst, year, doy, ut

fday=ut/86400.d
iyr=long(year)-1900
iday=long(doy)
dj=365*iyr+(iyr-1)/4+iday+fday-0.5
gst=(279.696678+.9856473354*dj+360.*fday+180.) mod 360. * !dpi/180.

return, gst

end
