;+
; NAME:
; 	PLOTCUBE
;
; PURPOSE:
;	Makes plots of UV airglow output from image cube files creaded by GOLDLOS
;	Optionally saves images to plot files
;
; CATEGORY:
;	Graphics
;
; CALLING SEQUENCE:
;       Main program  
;
; INPUTS:
;	Input file path
;
; OUTPUTS:  
;	Plots to screen windows and optionally to files
;
; COMMON BLOCKS:
;	None
;
; PROCEDURE:
;	Makes global images of O 135.6 and LBH emission, their ratio, and effective temperature 
;
; ROUTINES CALLED:
;	PLOTIMAGES
;
; MODIFICATION HISTORY:
;	Stan Solomon, 2016, 2018
;
;+

; Specify  directory and file codes:

directory='/hao/tethysv1/data/glowout/msisiri/gold2018/day305/'
filecode='cons'

; Specify file number to process, and set switches for plots and output

ntime=32
nplots=3
writeplots=1
nodisplay=0

; Specify satellite location:

satlat = 0.
satlon =-47.5
satalt = 35786.                  ; km
satrad = (satalt+6370.)/6370.    ; Earth radii

; Read image cube file:

cubefilepath=directory+'cube.'+filecode
cubefile=cubefilepath+'.'+string(ntime,format='(i3.3)')+'.nc'
read_netcdf,cubefile,cube

; Calculate 1356 / LBHshort ratio:

rat=(cube.scbo5s+cube.scblbh30)/((cube.scblbhs*1.4)>100.)

; Make plots:

plotfilepath=directory+'plot.'+filecode
plotimagestemp,ntime,nplots,plotfilepath,cube.date,cube.ut,cube.amodel,cube.gmodel, $
           satlat,satlon,satrad,cube.scbo5s,cube.scblbhs,cube.scblbh30,rat,cube.teff, $
           writeplots,nodisplay

end

