;+
; NAME:
;	THETAPHI_TO_CHIPSI
;
; PURPOSE:
;	Converts coordinates from ECR theta-phi to Instrument chi-psi
;
; CATEGORY:
;	Utility
;
; CALLING SEQUENCE:
;	thetaphi_to_chipsi, satlon, theta, phi, chi, psi
; 
; INPUTS:
;	satlon	Satellite longitude, radians
;	theta	Zenith angle of observation in ECR coordinate system, radians
;	phi	Azimuthal angle of observation in ECR coordinate system, radians
;
; OUTPUTS:
;	chi	Instrument look angle from nadir toward east, double precision
;	psi	Instrument look angle from nadir toward north, double precision
;
; KEYWORDS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; PROCEDURE:
;	Simple transform from Earth-Centered Rotational (ECR) coordinate system to 
;	instrument look angles assuming a geostationary satellite (or any equatorial location).
;	The chi-psi coordinate system is defined as look angles from nadir.
;	Note this essentially assumes that nadir is in the -z direction for a right-hand system.
;	S/C coordinates, however, generally and perversely assume that nadir is +z.
;	Therfore, in this type of S/C coordinates, chi is +x but psi is -y.
;	Arrays of coordiantes of any dimension are OK.
;	
; ROUTINES USED:
;	None.
;
; MODIFICATION HISTORY:
;       Stan Solomon, 3/15
;
;-

pro thetaphi_to_chipsi, satlon, theta, phi, chi, psi

chi = !dpi + satlon - phi
psi = !dpi/2. - theta

return
end
