pro colorspec, red, green, blue

; Color table with blue-green-yellow-red ("spectrum") scale

common colors, r_orig, g_orig, b_orig, r_curr, g_curr, b_curr

red=fltarr(256) & green=fltarr(256) & blue=fltarr(256)
r=fltarr(26)    & g=fltarr(26)      & b=fltarr(26)
r=[ 0.2,  0.2,  0.2,  0.2,  0.2,  0.1,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,$
    0.2,  .56,  .70, 0.82,  0.9, 0.95,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0, 1.0]
g=[ 0.1,  0.1,  0.1,  0.1,  0.1,  0.1, 0.35,  0.5, 0.65, 0.75, 0.85, 0.9, 0.93,$
   0.95,0.94, 0.93, 0.90, 0.86, 0.82, 0.77,  0.7,  0.6,  0.5, 0.4,  0.3,  0.0 ]
b=[ 0.2,  0.6,  0.7,  0.8,  0.9,  1.0,  1.0,  1.0,  0.9,  0.8,  0.7, 0.6,  0.5,$
    0.1,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0]

n=!d.table_size-1

re=interpol(r,n)
gr=interpol(g,n)
bl=interpol(b,n)
red(0:n-1)=re
green(0:n-1)=gr
blue(0:n-1)=bl
red(0)=0.
green(0)=0.
blue(0)=0.
red(n:255)=1.
green(n:255)=1.
blue(n:255)=1.
red=bytscl(red)
green=bytscl(green)
blue=bytscl(blue)

tvlct,red,green,blue

r_orig=red
g_orig=green
b_orig=blue
r_curr=red
g_curr=green
b_curr=blue

return
end
