;+
; NAME:  CROSS
;
; PURPOSE:  Find the cross product (vector product) of two 3D vectors
;
; CATEGORY:  Utility
;
; CALLING SEQUENCE:  result = cross(v1,v2) 
;
; INPUTS:  v1 is the first vector, (x1,y1,z1), v2 is the second vector (x2,y2,z2) 
;
; OUTPUTS:  Cross product of the two vectors (vector product), 3 x N array, double precision
;	  
; PROCEDURE: v1 cross v2 = [y1*z2-z1-y2, z1*x2-x1*z2, x1*y2-y1-x2]
;            note that these can be two-dimensional 3 x N arrays of vector triplets
;            dimensions must be consistent, however, and no more than two dimensions allowed
;            there is no error checking, consistency is up to the user
;
; MODIFICATION HISTORY:  SCS, 3/15
;
;+

function cross, v1, v2

cross = double(v1)
cross[0,*] = v1[1,*]*v2[2,*] - v1[2,*]*v2[1,*]
cross[1,*] = v1[2,*]*v2[0,*] - v1[0,*]*v2[2,*]
cross[2,*] = v1[0,*]*v2[1,*] - v1[1,*]*v2[0,*]

return, cross

end
